/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.utils;

import com.openexchange.mail.MailField;
import com.openexchange.mail.mime.HeaderName;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.protocol.UIDSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.mail.FetchProfile;
import javax.mail.UIDFolder;

public final class MimeStorageUtility {
    private static final FetchProfile CACHE_FETCH_PROFILE = new FetchProfile();
    private static final Collection<MailField> CACHE_FIELDS;
    private static final MailField[] CACHE_FIELDS_ARR;
    private static final EnumSet<MailField> ENV_FIELDS;
    private static final EnumSet<MailField> ENUM_SET_FULL;
    private static final List<HeaderName> ENV_LIST;
    private static final EnumMap<MailField, FetchProfile.Item> FIELD2ITEM;
    private static final EnumMap<MailField, List<String>> FIELD2STRING;

    private MimeStorageUtility() {
    }

    public static FetchProfile cloneFetchProfile(FetchProfile toClone) {
        if (null == toClone) {
            return null;
        }
        FetchProfile clone = new FetchProfile();
        for (FetchProfile.Item item : toClone.getItems()) {
            clone.add(item);
        }
        for (String string : toClone.getHeaderNames()) {
            clone.add(string);
        }
        return clone;
    }

    public static Collection<MailField> getCacheFields() {
        return CACHE_FIELDS;
    }

    public static MailField[] getCacheFieldsArray() {
        return CACHE_FIELDS_ARR;
    }

    public static FetchProfile getCacheFetchProfile() {
        return CACHE_FETCH_PROFILE;
    }

    public static FetchProfile getUIDFetchProfile() {
        FetchProfile fp = new FetchProfile();
        fp.add((FetchProfile.Item)UIDFolder.FetchProfileItem.UID);
        return fp;
    }

    public static FetchProfile getFlagsFetchProfile() {
        FetchProfile fp = new FetchProfile();
        fp.add(FetchProfile.Item.FLAGS);
        return fp;
    }

    public static Collection<MailField> fetchProfile2MailListFields(FetchProfile fetchProfile) {
        EnumSet<MailField> set = EnumSet.noneOf(MailField.class);
        set.add(MailField.FOLDER_ID);
        if (fetchProfile.contains(FetchProfile.Item.ENVELOPE)) {
            set.add(MailField.FROM);
            set.add(MailField.TO);
            set.add(MailField.CC);
            set.add(MailField.BCC);
            set.add(MailField.SUBJECT);
            set.add(MailField.RECEIVED_DATE);
            set.add(MailField.SENT_DATE);
            set.add(MailField.SIZE);
        } else {
            set.add(MailField.RECEIVED_DATE);
            if (fetchProfile.contains((FetchProfile.Item)IMAPFolder.FetchProfileItem.SIZE)) {
                set.add(MailField.SIZE);
            }
        }
        if (fetchProfile.contains((FetchProfile.Item)UIDFolder.FetchProfileItem.UID)) {
            set.add(MailField.ID);
        }
        if (fetchProfile.contains(FetchProfile.Item.CONTENT_INFO)) {
            set.add(MailField.CONTENT_TYPE);
        }
        if (fetchProfile.contains(FetchProfile.Item.FLAGS)) {
            set.add(MailField.FLAGS);
            set.add(MailField.COLOR_LABEL);
        }
        if (fetchProfile.contains((FetchProfile.Item)IMAPFolder.FetchProfileItem.HEADERS)) {
            set.add(MailField.HEADERS);
        } else {
            if (fetchProfile.contains("From")) {
                set.add(MailField.FROM);
            }
            if (fetchProfile.contains("To")) {
                set.add(MailField.TO);
            }
            if (fetchProfile.contains("Cc")) {
                set.add(MailField.CC);
            }
            if (fetchProfile.contains("Bcc")) {
                set.add(MailField.BCC);
            }
            if (fetchProfile.contains("Subject")) {
                set.add(MailField.SUBJECT);
            }
            if (fetchProfile.contains("Disposition-Notification-To")) {
                set.add(MailField.DISPOSITION_NOTIFICATION_TO);
            }
            if (fetchProfile.contains("Importance")) {
                set.add(MailField.PRIORITY);
            }
            if (fetchProfile.contains("X-Priority")) {
                set.add(MailField.PRIORITY);
            }
        }
        return set;
    }

    public static UIDSet[] toUIDSet(long[] uids) {
        ArrayList<UIDSet> sets = new ArrayList<UIDSet>(uids.length);
        for (int i = 0; i < uids.length; ++i) {
            long current = uids[i];
            UIDSet set = new UIDSet();
            set.start = current;
            ++i;
            while (i < uids.length) {
                long next = uids[i];
                if (next != current + 1L) {
                    --i;
                    break;
                }
                current = next;
                ++i;
            }
            set.end = current;
            sets.add(set);
        }
        if (sets.isEmpty()) {
            return null;
        }
        return sets.toArray(new UIDSet[sets.size()]);
    }

    public static FetchProfile getFetchProfile(MailField[] fields, boolean preferEnvelope) {
        return MimeStorageUtility.getFetchProfile(fields, null, preferEnvelope);
    }

    public static FetchProfile getFetchProfile(MailField[] fields, MailField sortField, boolean preferEnvelope) {
        return MimeStorageUtility.getFetchProfile(fields, null, sortField, preferEnvelope);
    }

    public static FetchProfile getFetchProfile(MailField[] fields, MailField[] searchFields, MailField sortField, boolean preferEnvelope) {
        return MimeStorageUtility.getFetchProfile(fields, null, searchFields, sortField, preferEnvelope);
    }

    public static FetchProfile getFetchProfile(MailField[] fields, String[] headerNames, MailField[] searchFields, MailField sortField, boolean preferEnvelope) {
        List<MailField> list = Arrays.asList(fields);
        EnumSet<MailField> fieldSet = list.isEmpty() ? EnumSet.noneOf(MailField.class) : EnumSet.copyOf(list);
        MailField[] arr = fieldSet.contains((Object)MailField.FULL) ? ENUM_SET_FULL.toArray(new MailField[ENUM_SET_FULL.size()]) : fields;
        FetchProfile fetchProfile = new FetchProfile();
        EnumSet<MailField> set = EnumSet.noneOf(MailField.class);
        if (arr != null) {
            set.addAll(Arrays.asList(arr));
        }
        if (searchFields != null) {
            set.addAll(Arrays.asList(searchFields));
        }
        if (sortField != null) {
            set.add(sortField);
        }
        Set<Object> names = null == headerNames ? Collections.emptySet() : new HashSet<HeaderName>(Arrays.asList(HeaderName.valuesOf(headerNames)));
        if (preferEnvelope && set.removeAll(ENV_FIELDS)) {
            fetchProfile.add(FetchProfile.Item.ENVELOPE);
            names.removeAll(ENV_LIST);
        }
        if (!set.isEmpty()) {
            if (set.contains((Object)MailField.FROM)) {
                names.remove(HeaderName.valueOf("From"));
            }
            if (set.contains((Object)MailField.TO)) {
                names.remove(HeaderName.valueOf("To"));
            }
            if (set.contains((Object)MailField.CC)) {
                names.remove(HeaderName.valueOf("Cc"));
            }
            if (set.contains((Object)MailField.BCC)) {
                names.remove(HeaderName.valueOf("Bcc"));
            }
            if (set.contains((Object)MailField.SUBJECT)) {
                names.remove(HeaderName.valueOf("Subject"));
            }
            if (set.contains((Object)MailField.SENT_DATE)) {
                names.remove(HeaderName.valueOf("Date"));
            }
            if (set.contains((Object)MailField.DISPOSITION_NOTIFICATION_TO)) {
                names.remove(HeaderName.valueOf("Disposition-Notification-To"));
            }
            if (set.contains((Object)MailField.PRIORITY)) {
                names.remove(HeaderName.valueOf("X-Priority"));
            }
            for (MailField mailField : set) {
                MimeStorageUtility.addFetchItem(fetchProfile, mailField);
            }
            for (HeaderName headerName : names) {
                fetchProfile.add(headerName.toString());
            }
        }
        return fetchProfile;
    }

    private static void addFetchItem(FetchProfile fp, MailField field) {
        if (MailField.COLOR_LABEL.equals((Object)field)) {
            if (!fp.contains(FetchProfile.Item.FLAGS)) {
                fp.add(FetchProfile.Item.FLAGS);
            }
            return;
        }
        FetchProfile.Item item = FIELD2ITEM.get((Object)field);
        if (null != item) {
            fp.add(item);
            return;
        }
        List<String> strings = FIELD2STRING.get((Object)field);
        if (null != strings) {
            for (String string : strings) {
                fp.add(string);
            }
        }
    }

    static {
        CACHE_FETCH_PROFILE.add(FetchProfile.Item.ENVELOPE);
        CACHE_FETCH_PROFILE.add(FetchProfile.Item.FLAGS);
        CACHE_FETCH_PROFILE.add(FetchProfile.Item.CONTENT_INFO);
        CACHE_FETCH_PROFILE.add((FetchProfile.Item)UIDFolder.FetchProfileItem.UID);
        CACHE_FETCH_PROFILE.add((FetchProfile.Item)IMAPFolder.FetchProfileItem.SIZE);
        CACHE_FETCH_PROFILE.add("Importance");
        CACHE_FETCH_PROFILE.add("X-Priority");
        Collection<MailField> fields = MimeStorageUtility.fetchProfile2MailListFields(CACHE_FETCH_PROFILE);
        fields.add(MailField.ACCOUNT_NAME);
        CACHE_FIELDS = fields;
        CACHE_FIELDS_ARR = CACHE_FIELDS.toArray(new MailField[CACHE_FIELDS.size()]);
        ENV_FIELDS = EnumSet.noneOf(MailField.class);
        ENV_FIELDS.add(MailField.FROM);
        ENV_FIELDS.add(MailField.TO);
        ENV_FIELDS.add(MailField.CC);
        ENV_FIELDS.add(MailField.BCC);
        ENV_FIELDS.add(MailField.SUBJECT);
        ENV_FIELDS.add(MailField.SENT_DATE);
        ENUM_SET_FULL = EnumSet.complementOf(EnumSet.of(MailField.BODY, MailField.FULL, MailField.ACCOUNT_NAME));
        ENV_LIST = Arrays.asList(HeaderName.valuesOf("From", "To", "Cc", "Bcc", "Subject", "Date", "ReplyTo"));
        FIELD2ITEM = new EnumMap(MailField.class);
        FIELD2ITEM.put(MailField.HEADERS, (FetchProfile.Item)IMAPFolder.FetchProfileItem.HEADERS);
        FIELD2ITEM.put(MailField.ID, (FetchProfile.Item)UIDFolder.FetchProfileItem.UID);
        FIELD2ITEM.put(MailField.CONTENT_TYPE, FetchProfile.Item.CONTENT_INFO);
        FIELD2ITEM.put(MailField.SIZE, (FetchProfile.Item)IMAPFolder.FetchProfileItem.SIZE);
        FIELD2ITEM.put(MailField.FLAGS, FetchProfile.Item.FLAGS);
        FIELD2STRING = new EnumMap(MailField.class);
        FIELD2STRING.put(MailField.FROM, Collections.singletonList("From"));
        FIELD2STRING.put(MailField.TO, Collections.singletonList("To"));
        FIELD2STRING.put(MailField.CC, Collections.singletonList("Cc"));
        FIELD2STRING.put(MailField.BCC, Collections.singletonList("Bcc"));
        FIELD2STRING.put(MailField.SUBJECT, Collections.singletonList("Subject"));
        FIELD2STRING.put(MailField.SENT_DATE, Collections.singletonList("Date"));
        FIELD2STRING.put(MailField.DISPOSITION_NOTIFICATION_TO, Collections.singletonList("Disposition-Notification-To"));
        FIELD2STRING.put(MailField.PRIORITY, Arrays.asList("Importance", "X-Priority"));
    }
}

