/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.parser;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccessFactory;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.LdapExceptionCode;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.upload.impl.UploadUtility;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailSessionParameterNames;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.dataobjects.compose.TextBodyMailPart;
import com.openexchange.mail.json.parser.AbstractAttachmentHandler;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.text.HtmlProcessing;
import com.openexchange.mail.transport.TransportProvider;
import com.openexchange.mail.transport.config.TransportProperties;
import com.openexchange.publish.Publication;
import com.openexchange.publish.PublicationService;
import com.openexchange.publish.PublicationTarget;
import com.openexchange.publish.PublicationTargetDiscoveryService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tx.TransactionException;
import com.openexchange.user.UserService;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.IDNA;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import org.apache.commons.logging.Log;

public final class PublishAttachmentHandler
extends AbstractAttachmentHandler {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(PublishAttachmentHandler.class));
    private final Session session;
    private final TransportProvider transportProvider;
    private final String protocol;
    private final String hostName;
    private final IDBasedFileAccessFactory fileAccessFactory;
    private boolean exceeded;
    private TextBodyMailPart textPart;
    private long consumed;
    private static final Pattern PATTERN_DATE = Pattern.compile(Pattern.quote("#DATE#"));

    public PublishAttachmentHandler(Session session, TransportProvider transportProvider, String protocol, String hostName) throws OXException {
        super(session);
        this.protocol = protocol;
        this.hostName = hostName;
        this.transportProvider = transportProvider;
        this.session = session;
        try {
            this.fileAccessFactory = ServerServiceRegistry.getInstance().getService(IDBasedFileAccessFactory.class, true);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }

    @Override
    public void setTextPart(TextBodyMailPart textPart) {
        this.textPart = textPart;
    }

    @Override
    public void addAttachment(MailPart attachment) throws OXException {
        if (this.doAction && !this.exceeded) {
            long size = attachment.getSize();
            if (size <= 0L && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Missing size: " + size), new Throwable());
            }
            if (this.uploadQuotaPerFile > 0L && size > this.uploadQuotaPerFile) {
                if (LOG.isDebugEnabled()) {
                    String fileName = attachment.getFileName();
                    OXException e = MailExceptionCode.UPLOAD_QUOTA_EXCEEDED_FOR_FILE.create(this.uploadQuotaPerFile, null == fileName ? "" : fileName, size);
                    LOG.debug((Object)new StringBuilder(64).append("Per-file quota (").append(UploadUtility.getSize(this.uploadQuotaPerFile, 2, false, true)).append(") exceeded. Message is going to be sent with links to publishing infostore folder.").toString(), (Throwable)e);
                }
                this.exceeded = true;
            } else {
                this.consumed += size;
                if (this.uploadQuota > 0L && this.consumed > this.uploadQuota) {
                    if (LOG.isDebugEnabled()) {
                        OXException e = MailExceptionCode.UPLOAD_QUOTA_EXCEEDED.create(this.uploadQuota);
                        LOG.debug((Object)new StringBuilder(64).append("Overall quota (").append(UploadUtility.getSize(this.uploadQuota, 2, false, true)).append(") exceeded. Message is going to be sent with links to publishing infostore folder.").toString(), (Throwable)e);
                    }
                    this.exceeded = true;
                }
            }
        }
        this.attachments.add(attachment);
    }

    @Override
    public ComposedMailMessage[] generateComposedMails(ComposedMailMessage source, List<OXException> warnings) throws OXException {
        if (!this.exceeded) {
            source.setBodyPart(this.textPart);
            for (MailPart attachment : this.attachments) {
                source.addEnclosedPart(attachment);
            }
            return new ComposedMailMessage[]{source};
        }
        ArrayList<PublicationAndInfostoreID> publications = new ArrayList<PublicationAndInfostoreID>(this.attachments.size());
        String key = MailSessionParameterNames.getParamPublishingInfostoreFolderID();
        if (!this.session.containsParameter(key)) {
            Throwable t = new Throwable("Missing folder ID of publishing infostore folder.");
            throw MailExceptionCode.SEND_FAILED_UNKNOWN.create(t, new Object[0]);
        }
        int folderId = (Integer)this.session.getParameter(key);
        Context ctx = this.getContext();
        PublicationTargetDiscoveryService discoveryService = ServerServiceRegistry.getInstance().getService(PublicationTargetDiscoveryService.class, true);
        PublicationTarget target = discoveryService.getTarget("com.openexchange.publish.online.infostore.document");
        if (null == target) {
            LOG.warn((Object)"Missing publication target for ID \"com.openexchange.publish.online.infostore.document\".\nThrowing quota-exceeded exception instead.");
            throw MailExceptionCode.UPLOAD_QUOTA_EXCEEDED.create(this.uploadQuota);
        }
        PublicationService publisher = target.getPublicationService();
        try {
            warnings.add(MailExceptionCode.USED_PUBLISHING_FEATURE.create());
            return this.generateComposedMails0(source, publications, folderId, target, publisher, ctx);
        }
        catch (OXException e) {
            this.rollbackPublications(publications, publisher);
            throw e;
        }
    }

    private ComposedMailMessage[] generateComposedMails0(ComposedMailMessage source, List<PublicationAndInfostoreID> publications, int folderId, PublicationTarget target, PublicationService publisher, Context ctx) throws OXException {
        ArrayList<LinkAndNamePair> links2 = new ArrayList<LinkAndNamePair>(this.attachments.size());
        StringBuilder linkBuilder = new StringBuilder(256);
        for (MailPart attachment : this.attachments) {
            String path = this.publishAttachmentAndGetPath(attachment, folderId, ctx, publications, target, publisher);
            linkBuilder.setLength(0);
            links2.add(new LinkAndNamePair(attachment.getFileName(), linkBuilder.append(this.protocol).append("://").append(this.hostName).append(path).toString()));
        }
        HashSet<InternetAddress> addresses = new HashSet<InternetAddress>();
        addresses.addAll(Arrays.asList(source.getTo()));
        addresses.addAll(Arrays.asList(source.getCc()));
        addresses.addAll(Arrays.asList(source.getBcc()));
        Date elapsedDate = null;
        if (TransportProperties.getInstance().publishedDocumentsExpire()) {
            elapsedDate = new Date(System.currentTimeMillis() + TransportProperties.getInstance().getPublishedDocumentTimeToLive());
        }
        UserService userService = ServerServiceRegistry.getInstance().getService(UserService.class);
        HashMap<Locale, ComposedMailMessage> internalMessages = new HashMap<Locale, ComposedMailMessage>(addresses.size());
        ComposedMailMessage externalMessage = null;
        for (InternetAddress address : addresses) {
            User user;
            block13: {
                user = null;
                try {
                    user = userService.searchUser(IDNA.toIDN((String)address.getAddress()), ctx);
                }
                catch (OXException e) {
                    if (!LdapExceptionCode.NO_USER_BY_MAIL.equals(e)) {
                        throw e;
                    }
                    try {
                        user = userService.searchUser(IDNA.toIDN((String)address.getAddress()), ctx);
                    }
                    catch (OXException inner) {
                        if (LdapExceptionCode.NO_USER_BY_MAIL.equals(inner)) break block13;
                        throw inner;
                    }
                }
            }
            if (null == user) {
                if (null == externalMessage) {
                    externalMessage = this.generateExternalVersion(source, ctx, links2, TransportProperties.getInstance().isProvideLinksInAttachment(), elapsedDate);
                }
                externalMessage.addRecipient(address);
                continue;
            }
            Locale locale = user.getLocale();
            ComposedMailMessage localedMessage = (ComposedMailMessage)internalMessages.get(locale);
            if (null == localedMessage) {
                localedMessage = this.generateInternalVersion(source, ctx, links2, TransportProperties.getInstance().isProvideLinksInAttachment(), elapsedDate, locale);
                internalMessages.put(locale, localedMessage);
            }
            localedMessage.addRecipient(address);
        }
        ArrayList<Object> mails = new ArrayList<Object>(internalMessages.size() + 1);
        mails.addAll(internalMessages.values());
        if (null != externalMessage) {
            mails.add(externalMessage);
        }
        if (mails.isEmpty()) {
            mails.add(this.generateInternalVersion(source, ctx, links2, TransportProperties.getInstance().isProvideLinksInAttachment(), elapsedDate, this.getSessionUser().getLocale()));
        }
        return mails.toArray(new ComposedMailMessage[mails.size()]);
    }

    private Context getContext() throws OXException {
        if (this.session instanceof ServerSession) {
            return ((ServerSession)this.session).getContext();
        }
        try {
            return ContextStorage.getStorageContext(this.session.getContextId());
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }

    private User getSessionUser() throws OXException {
        if (this.session instanceof ServerSession) {
            return ((ServerSession)this.session).getUser();
        }
        try {
            return UserStorage.getInstance().getUser(this.session.getUserId(), this.getContext());
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }

    private ComposedMailMessage generateInternalVersion(ComposedMailMessage source, Context ctx, List<LinkAndNamePair> links2, boolean appendLinksAsAttachment, Date elapsedDate, Locale locale) throws OXException {
        ComposedMailMessage internalVersion = this.copyOf(source, ctx);
        TextBodyMailPart textPart = this.textPart.copy();
        StringHelper stringHelper = StringHelper.valueOf(locale);
        if (appendLinksAsAttachment) {
            internalVersion.setBodyPart(textPart);
            StringBuilder textBuilder = new StringBuilder(256 * links2.size());
            textBuilder.append(HtmlProcessing.htmlFormat(stringHelper.getString("The available attachments for this E-Mail can be accessed via the links:"))).append("<br />");
            PublishAttachmentHandler.appendLinks(links2, textBuilder);
            internalVersion.addEnclosedPart(this.createLinksAttachment(textBuilder.toString()));
        } else {
            String text = (String)textPart.getContent();
            StringBuilder textBuilder = new StringBuilder(text.length() + 512);
            textBuilder.append(HtmlProcessing.htmlFormat(stringHelper.getString("The available attachments for this E-Mail can be accessed via the links:"))).append("<br />");
            PublishAttachmentHandler.appendLinks(links2, textBuilder);
            if (elapsedDate != null) {
                textBuilder.append(HtmlProcessing.htmlFormat(PATTERN_DATE.matcher(stringHelper.getString("The links will be deleted by #DATE#")).replaceFirst(DateFormat.getDateInstance(1, locale).format(elapsedDate)))).append("<br /><br />");
            }
            textBuilder.append(text);
            textPart.setText(textBuilder.toString());
            internalVersion.setBodyPart(textPart);
        }
        return internalVersion;
    }

    private ComposedMailMessage generateExternalVersion(ComposedMailMessage source, Context ctx, List<LinkAndNamePair> links2, boolean appendLinksAsAttachment, Date elapsedDate) throws OXException {
        ComposedMailMessage externalVersion = this.copyOf(source, ctx);
        TextBodyMailPart textPart = this.textPart.copy();
        if (TransportProperties.getInstance().isSendAttachmentToExternalRecipients()) {
            externalVersion.setBodyPart(textPart);
            for (MailPart attachment : this.attachments) {
                externalVersion.addEnclosedPart(attachment);
            }
        } else {
            Locale locale = TransportProperties.getInstance().getExternalRecipientsLocale();
            if (null == locale) {
                locale = this.getSessionUserLocale();
            }
            StringHelper stringHelper = StringHelper.valueOf(locale);
            if (appendLinksAsAttachment) {
                externalVersion.setBodyPart(textPart);
                StringBuilder textBuilder = new StringBuilder(256 * links2.size());
                textBuilder.append(HtmlProcessing.htmlFormat(stringHelper.getString("The available attachments for this E-Mail can be accessed via the links:"))).append("<br />");
                PublishAttachmentHandler.appendLinks(links2, textBuilder);
                externalVersion.addEnclosedPart(this.createLinksAttachment(textBuilder.toString()));
            } else {
                String text = (String)textPart.getContent();
                StringBuilder textBuilder = new StringBuilder(text.length() + 512);
                textBuilder.append(HtmlProcessing.htmlFormat(stringHelper.getString("The available attachments for this E-Mail can be accessed via the links:"))).append("<br />");
                PublishAttachmentHandler.appendLinks(links2, textBuilder);
                if (elapsedDate != null) {
                    textBuilder.append(HtmlProcessing.htmlFormat(PATTERN_DATE.matcher(stringHelper.getString("The links will be deleted by #DATE#")).replaceFirst(DateFormat.getDateInstance(1, locale).format(elapsedDate)))).append("<br /><br />");
                }
                textBuilder.append(text);
                textPart.setText(textBuilder.toString());
                externalVersion.setBodyPart(textPart);
            }
        }
        return externalVersion;
    }

    private Locale getSessionUserLocale() throws OXException {
        if (this.session instanceof ServerSession) {
            return ((ServerSession)this.session).getUser().getLocale();
        }
        Context context = ContextStorage.getStorageContext(this.session.getContextId());
        return UserStorage.getStorageUser(this.session.getUserId(), context).getLocale();
    }

    private ComposedMailMessage copyOf(ComposedMailMessage source, Context ctx) throws OXException {
        ComposedMailMessage composedMail = this.transportProvider.getNewComposedMailMessage(this.session, ctx);
        if (source.containsFlags()) {
            composedMail.setFlags(source.getFlags());
        }
        if (source.containsThreadLevel()) {
            composedMail.setThreadLevel(source.getThreadLevel());
        }
        if (source.containsUserFlags()) {
            composedMail.addUserFlags(source.getUserFlags());
        }
        if (source.containsUserFlags()) {
            composedMail.addUserFlags(source.getUserFlags());
        }
        if (source.containsHeaders()) {
            composedMail.addHeaders(source.getHeaders());
        }
        if (source.containsFrom()) {
            composedMail.addFrom(source.getFrom());
        }
        if (source.containsTo()) {
            composedMail.addTo(source.getTo());
        }
        if (source.containsCc()) {
            composedMail.addCc(source.getCc());
        }
        if (source.containsBcc()) {
            composedMail.addBcc(source.getBcc());
        }
        if (source.containsDispositionNotification()) {
            composedMail.setDispositionNotification(source.getDispositionNotification());
        }
        if (source.containsDispositionNotification()) {
            composedMail.setDispositionNotification(source.getDispositionNotification());
        }
        if (source.containsPriority()) {
            composedMail.setPriority(source.getPriority());
        }
        if (source.containsColorLabel()) {
            composedMail.setColorLabel(source.getColorLabel());
        }
        if (source.containsAppendVCard()) {
            composedMail.setAppendVCard(source.isAppendVCard());
        }
        if (source.containsMsgref()) {
            composedMail.setMsgref(source.getMsgref());
        }
        if (source.containsSubject()) {
            composedMail.setSubject(source.getSubject());
        }
        if (source.containsSize()) {
            composedMail.setSize(source.getSize());
        }
        if (source.containsSentDate()) {
            composedMail.setSentDate(source.getSentDate());
        }
        if (source.containsReceivedDate()) {
            composedMail.setReceivedDate(source.getReceivedDate());
        }
        if (source.containsContentType()) {
            composedMail.setContentType(source.getContentType());
        }
        return composedMail;
    }

    private MailPart createLinksAttachment(String text) throws OXException, OXException {
        try {
            MimeBodyPart bodyPart = new MimeBodyPart();
            bodyPart.setText(HtmlProcessing.getConformHTML(text, "UTF-8"), "UTF-8", "html");
            bodyPart.setHeader("MIME-Version", "1.0");
            bodyPart.setHeader("Content-Type", MimeMessageUtility.foldContentType("text/html; charset=UTF-8; name=links.html"));
            bodyPart.setHeader("Content-Transfer-Encoding", "base64");
            bodyPart.setHeader("Content-Disposition", MimeMessageUtility.foldContentDisposition("attachment; filename=links.html"));
            return MimeMessageConverter.convertPart((Part)bodyPart, false);
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String publishAttachmentAndGetPath(MailPart attachment, int folderId, Context ctx, List<PublicationAndInfostoreID> publications, PublicationTarget target, PublicationService publisher) throws OXException, TransactionException, OXException {
        String name = attachment.getFileName();
        if (name == null) {
            name = "attachment";
        }
        DefaultFile file = new DefaultFile();
        file.setId(FileStorageFileAccess.NEW);
        file.setFolderId(String.valueOf(folderId));
        file.setFileName(name);
        file.setFileMIMEType(attachment.getContentType().toString());
        file.setTitle(name);
        IDBasedFileAccess fileAccess = this.fileAccessFactory.createAccess(this.session);
        boolean retry = true;
        int count = 1;
        StringBuilder hlp = new StringBuilder(16);
        while (retry) {
            InputStream in = attachment.getInputStream();
            try {
                fileAccess.startTransaction();
                try {
                    fileAccess.saveDocument((File)file, in, Long.MAX_VALUE);
                    fileAccess.commit();
                    retry = false;
                }
                catch (OXException x) {
                    fileAccess.rollback();
                    if (!x.isPrefix("IFO")) {
                        throw x;
                    }
                    if (441 != x.getCode()) {
                        throw new OXException(x);
                    }
                    hlp.setLength(0);
                    int pos = name.lastIndexOf(46);
                    String newName = pos >= 0 ? hlp.append(name.substring(0, pos)).append("_(").append(++count).append(')').append(name.substring(pos)).toString() : hlp.append(name).append("_(").append(++count).append(')').toString();
                    file.setFileName(newName);
                    file.setTitle(newName);
                }
                catch (RuntimeException e) {
                    fileAccess.rollback();
                    throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
                }
                finally {
                    fileAccess.finish();
                }
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        Publication publication = new Publication();
        publication.setModule("infostore/object");
        publication.setEntityId(String.valueOf(file.getId()));
        publication.setContext(ctx);
        publication.setUserId(this.session.getUserId());
        publication.setTarget(target);
        publisher.create(publication);
        publications.add(new PublicationAndInfostoreID(publication, file.getId()));
        return (String)publication.getConfiguration().get("url");
    }

    private void rollbackPublications(List<PublicationAndInfostoreID> publications, PublicationService publisher) {
        IDBasedFileAccess fileAccess = this.fileAccessFactory.createAccess(this.session);
        long timestamp = System.currentTimeMillis();
        ArrayList<String> arr = new ArrayList<String>(1);
        for (PublicationAndInfostoreID publication : publications) {
            try {
                publisher.delete(publication.publication);
            }
            catch (OXException e) {
                LOG.error((Object)("Publication with ID \"" + publication.publication.getId() + " could not be roll-backed."), (Throwable)e);
            }
            try {
                fileAccess.startTransaction();
                try {
                    arr.set(0, publication.infostoreId);
                    fileAccess.removeDocument(arr, timestamp);
                    fileAccess.commit();
                }
                catch (OXException x) {
                    fileAccess.rollback();
                    throw x;
                }
                finally {
                    fileAccess.finish();
                }
            }
            catch (OXException e) {
                LOG.error((Object)("Transaction error while deleting infostore document with ID \"" + publication.infostoreId + "\" failed."), (Throwable)e);
            }
        }
    }

    private static void appendLinks(List<LinkAndNamePair> links2, StringBuilder textBuilder) {
        for (LinkAndNamePair pair : links2) {
            String link = pair.link;
            char quot = link.indexOf(34) < 0 ? (char)'\"' : '\'';
            textBuilder.append("<a href=").append(quot).append(link).append(quot).append('>');
            String name = pair.name;
            if (null != name && name.length() > 0) {
                textBuilder.append(name).append("</a><br />");
                continue;
            }
            textBuilder.append(link).append("</a><br />");
        }
    }

    private static final class PublicationAndInfostoreID {
        final Publication publication;
        final String infostoreId;

        public PublicationAndInfostoreID(Publication publication, String infostoreId) {
            this.publication = publication;
            this.infostoreId = infostoreId;
        }
    }

    private static final class LinkAndNamePair {
        final String name;
        final String link;

        public LinkAndNamePair(String name, String link) {
            this.name = name;
            this.link = link;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.link == null ? 0 : this.link.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof LinkAndNamePair)) {
                return false;
            }
            LinkAndNamePair other = (LinkAndNamePair)obj;
            if (this.link == null ? other.link != null : !this.link.equals(other.link)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

