/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.api;

import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.api.IMailProperties;
import com.openexchange.mail.api.MailCapabilities;
import com.openexchange.mail.config.MailConfigException;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.partmodifier.DummyPartModifier;
import com.openexchange.mail.partmodifier.PartModifier;
import com.openexchange.mail.utils.MailPasswordUtil;
import com.openexchange.mail.utils.ProviderUtility;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import javax.mail.internet.AddressException;
import javax.mail.internet.IDNA;
import org.apache.commons.logging.Log;

public abstract class MailConfig {
    private static volatile Boolean usePartModifier;
    protected static final Class<?>[] CONSTRUCTOR_ARGS;
    protected static final Object[] INIT_ARGS;
    protected int accountId;
    protected Session session;
    protected String login;
    protected String password;

    public static final <C extends MailConfig> C getConfig(C mailConfig, Session session, int accountId) throws OXException {
        int userId = session.getUserId();
        int contextId = session.getContextId();
        MailAccountStorageService storage = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        MailAccount mailAccount = accountId == 0 ? storage.getDefaultMailAccount(userId, contextId) : storage.getMailAccount(accountId, userId, contextId);
        mailConfig.accountId = accountId;
        mailConfig.session = session;
        MailConfig.fillLoginAndPassword(mailConfig, session, UserStorage.getStorageUser(userId, contextId).getLoginInfo(), mailAccount);
        String serverURL = MailConfig.getMailServerURL(mailAccount);
        if (serverURL == null) {
            if (ServerSource.GLOBAL.equals((Object)MailProperties.getInstance().getMailServerSource())) {
                throw MailConfigException.create(new StringBuilder(64).append("Property \"").append("com.openexchange.mail.mailServer").append("\" not set in mail properties").toString());
            }
            throw MailConfigException.create(new StringBuilder(64).append("Cannot determine mail server URL for user ").append(userId).append(" in context ").append(contextId).toString());
        }
        int lastPos = serverURL.length() - 1;
        if (serverURL.charAt(lastPos) == '/') {
            serverURL = serverURL.substring(0, lastPos);
        }
        mailConfig.parseServerURL(serverURL);
        return mailConfig;
    }

    public static final String getMailLogin(MailAccount mailAccount, String userLoginInfo) {
        return MailConfig.saneLogin(MailConfig.getMailLogin0(mailAccount, userLoginInfo));
    }

    private static final String getMailLogin0(MailAccount mailAccount, String userLoginInfo) {
        if (!mailAccount.isDefaultAccount()) {
            return mailAccount.getLogin();
        }
        LoginSource loginSource = MailProperties.getInstance().getLoginSource();
        if (LoginSource.USER_IMAPLOGIN.equals((Object)loginSource)) {
            return mailAccount.getLogin();
        }
        if (LoginSource.PRIMARY_EMAIL.equals((Object)loginSource)) {
            try {
                return QuotedInternetAddress.toACE(mailAccount.getPrimaryAddress());
            }
            catch (AddressException e) {
                String primaryAddress = mailAccount.getPrimaryAddress();
                com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MailConfig.class)).warn((Object)("Login source primary email address \"" + primaryAddress + "\" could not be converted to ASCII. Using unicode representation."), (Throwable)e);
                return primaryAddress;
            }
        }
        return userLoginInfo;
    }

    public static final String getMailServerURL(MailAccount mailAccount) {
        if (!mailAccount.isDefaultAccount()) {
            return mailAccount.generateMailServerURL();
        }
        if (ServerSource.GLOBAL.equals((Object)MailProperties.getInstance().getMailServerSource())) {
            return IDNA.toASCII((String)MailProperties.getInstance().getMailServer());
        }
        return mailAccount.generateMailServerURL();
    }

    public static final String getMailServerURL(Session session, int accountId) throws OXException {
        if (0 == accountId && ServerSource.GLOBAL.equals((Object)MailProperties.getInstance().getMailServerSource())) {
            return IDNA.toASCII((String)MailProperties.getInstance().getMailServer());
        }
        MailAccountStorageService storage = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        return storage.getMailAccount(accountId, session.getUserId(), session.getContextId()).generateMailServerURL();
    }

    public static final PartModifier getPartModifier() {
        return PartModifier.getInstance();
    }

    public static int[] getUserIDsByMailLogin(String pattern, boolean isDefaultAccount, InetSocketAddress server, Context ctx) throws OXException {
        MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        if (isDefaultAccount) {
            switch (MailProperties.getInstance().getLoginSource()) {
                case USER_IMAPLOGIN: 
                case PRIMARY_EMAIL: {
                    MailAccount[] accounts;
                    switch (MailProperties.getInstance().getLoginSource()) {
                        case USER_IMAPLOGIN: {
                            accounts = storageService.resolveLogin(pattern, ctx.getContextId());
                            break;
                        }
                        case PRIMARY_EMAIL: {
                            accounts = storageService.resolvePrimaryAddr(pattern, ctx.getContextId());
                            break;
                        }
                        default: {
                            throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create("Unimplemented mail login source.");
                        }
                    }
                    HashSet<Integer> userIds = new HashSet<Integer>();
                    if (accounts.length == 1) {
                        userIds.add(Autoboxing.I((int)accounts[0].getUserId()));
                    } else {
                        for (MailAccount candidate : accounts) {
                            InetSocketAddress shouldMatch;
                            switch (MailProperties.getInstance().getMailServerSource()) {
                                case USER: {
                                    shouldMatch = ProviderUtility.toSocketAddr(candidate.generateMailServerURL(), 143);
                                    break;
                                }
                                case GLOBAL: {
                                    shouldMatch = ProviderUtility.toSocketAddr(MailProperties.getInstance().getMailServer(), 143);
                                    break;
                                }
                                default: {
                                    throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create("Unimplemented mail server source.");
                                }
                            }
                            if (!server.equals(shouldMatch)) continue;
                            userIds.add(Autoboxing.I((int)candidate.getUserId()));
                        }
                    }
                    HashSet<Integer> notDefaultAccount = new HashSet<Integer>();
                    if (userIds.size() > 1) {
                        Iterator iter = userIds.iterator();
                        while (iter.hasNext()) {
                            int userId = Autoboxing.i((Integer)((Integer)iter.next()));
                            for (MailAccount candidate : accounts) {
                                if (candidate.getUserId() != userId || candidate.isDefaultAccount()) continue;
                                notDefaultAccount.add(Autoboxing.I((int)userId));
                            }
                        }
                    }
                    if (notDefaultAccount.size() < userIds.size()) {
                        userIds.removeAll(notDefaultAccount);
                    }
                    return Autoboxing.I2i(userIds);
                }
                case USER_NAME: {
                    return new int[]{UserStorage.getInstance().getUserId(pattern, ctx)};
                }
            }
        }
        MailAccount[] accounts = storageService.resolveLogin(pattern, server, ctx.getContextId());
        int[] retval = new int[accounts.length];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = accounts[i].getUserId();
        }
        return retval;
    }

    public static final String[] parseProtocol(String server) {
        int len = server.length();
        char c = '\u0000';
        for (int i = 0; i < len && (c = server.charAt(i)) != '/'; ++i) {
            if (c != ':' || (c = server.charAt(i + 1)) != '/' || (c = server.charAt(i + 2)) != '/') continue;
            String s = server.substring(0, i).toLowerCase(Locale.ENGLISH);
            if (!MailConfig.isValidProtocol(s)) break;
            int start = i + 1;
            while (server.charAt(start) == '/') {
                ++start;
            }
            return new String[]{s, server.substring(start)};
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean usePartModifier() {
        Boolean tmp = usePartModifier;
        if (tmp != null) return tmp;
        Class<MailConfig> clazz = MailConfig.class;
        synchronized (MailConfig.class) {
            tmp = usePartModifier;
            if (tmp != null) return tmp;
            PartModifier pm = PartModifier.getInstance();
            tmp = usePartModifier = Boolean.valueOf(pm != null && !DummyPartModifier.class.isInstance(pm));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    private static final boolean isValidProtocol(String protocol) {
        int len = protocol.length();
        if (len < 1) {
            return false;
        }
        char c = protocol.charAt(0);
        if (!Character.isLetter(c)) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            c = protocol.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '+' || c == '-') continue;
            return false;
        }
        return true;
    }

    private static final String saneLogin(String login) {
        ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        if (null != service && !service.getBoolProperty("com.openexchange.mail.saneLogin", true)) {
            return login;
        }
        try {
            return IDNA.toACE((String)login);
        }
        catch (Exception e) {
            return login;
        }
    }

    protected static final void fillLoginAndPassword(MailConfig mailConfig, Session session, String userLoginInfo, MailAccount mailAccount) throws OXException {
        String proxyDelimiter = MailProperties.getInstance().getAuthProxyDelimiter();
        String slogin = session.getLoginName();
        mailConfig.login = proxyDelimiter != null && slogin.contains(proxyDelimiter) ? MailConfig.saneLogin(slogin) : MailConfig.getMailLogin(mailAccount, userLoginInfo);
        if (mailAccount.isDefaultAccount()) {
            PasswordSource cur = MailProperties.getInstance().getPasswordSource();
            if (PasswordSource.GLOBAL.equals((Object)cur)) {
                String masterPw = MailProperties.getInstance().getMasterPassword();
                if (masterPw == null) {
                    throw MailConfigException.create("Property \"masterPassword\" not set");
                }
                mailConfig.password = masterPw;
            } else {
                mailConfig.password = session.getPassword();
            }
        } else {
            String mailAccountPassword = mailAccount.getPassword();
            mailConfig.password = null == mailAccountPassword || mailAccountPassword.length() == 0 ? "" : MailPasswordUtil.decrypt(mailAccountPassword, session, mailAccount.getId(), mailAccount.getLogin(), mailAccount.getMailServer());
        }
    }

    protected MailConfig() {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MailConfig other = (MailConfig)obj;
        if (this.login == null ? other.login != null : !this.login.equals(other.login)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        return !(this.getServer() == null ? other.getServer() != null : !this.getServer().equals(other.getServer()));
    }

    public int getAccountId() {
        return this.accountId;
    }

    public Session getSession() {
        return this.session;
    }

    public abstract MailCapabilities getCapabilities();

    public final String getLogin() {
        return this.login;
    }

    public final String getPassword() {
        return this.password;
    }

    public abstract int getPort();

    public abstract String getServer();

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ MailConfig [accountId=").append(this.accountId).append(", ");
        if (this.login != null) {
            builder.append("login=").append(this.login).append(", ");
        }
        if (this.password != null) {
            // empty if block
        }
        builder.append("getPort()=").append(this.getPort()).append(", ");
        if (this.getServer() != null) {
            builder.append("getServer()=").append(this.getServer()).append(", ");
        }
        builder.append("isSecure()=").append(this.isSecure()).append("] }");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.login == null ? 0 : this.login.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + this.getPort();
        String server = this.getServer();
        result = 31 * result + (server == null ? 0 : server.hashCode());
        return result;
    }

    public abstract boolean isSecure();

    public void setAccountId(int accountId) {
        this.accountId = accountId;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void setLogin(String login) {
        this.login = MailConfig.saneLogin(login);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public abstract void setPort(int var1);

    public abstract void setSecure(boolean var1);

    public abstract void setServer(String var1);

    public abstract IMailProperties getMailProperties();

    public abstract void setMailProperties(IMailProperties var1);

    protected abstract void parseServerURL(String var1) throws OXException;

    static {
        CONSTRUCTOR_ARGS = new Class[0];
        INIT_ARGS = new Object[0];
    }

    public static enum ServerSource {
        GLOBAL("global"),
        USER("user");

        private final String str;

        public static final ServerSource parse(String serverSourceStr) {
            ServerSource[] values;
            for (ServerSource serverSource : values = ServerSource.values()) {
                if (!serverSource.str.equalsIgnoreCase(serverSourceStr)) continue;
                return serverSource;
            }
            return null;
        }

        private ServerSource(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }

    public static enum PasswordSource {
        GLOBAL("global"),
        SESSION("session");

        private final String str;

        public static final PasswordSource parse(String passwordSourceStr) {
            PasswordSource[] values;
            for (PasswordSource passwordSource : values = PasswordSource.values()) {
                if (!passwordSource.str.equalsIgnoreCase(passwordSourceStr)) continue;
                return passwordSource;
            }
            return null;
        }

        private PasswordSource(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }

    public static enum LoginSource {
        PRIMARY_EMAIL("mail"),
        USER_IMAPLOGIN("login"),
        USER_NAME("name");

        private final String str;

        public static final LoginSource parse(String loginSourceStr) {
            LoginSource[] values;
            for (LoginSource loginSource : values = LoginSource.values()) {
                if (!loginSource.str.equalsIgnoreCase(loginSourceStr)) continue;
                return loginSource;
            }
            return null;
        }

        private LoginSource(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }

    public static enum BoolCapVal {
        AUTO("auto"),
        FALSE("false"),
        TRUE("true");

        private final String str;

        public static final BoolCapVal parseBoolCapVal(String capVal) {
            if (BoolCapVal.TRUE.str.equalsIgnoreCase(capVal)) {
                return TRUE;
            }
            if (BoolCapVal.AUTO.str.equalsIgnoreCase(capVal)) {
                return AUTO;
            }
            return FALSE;
        }

        private BoolCapVal(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }
}

