/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.Component;
import com.openexchange.mail.MailExceptionCode;
import java.io.Serializable;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Protocol
implements Component,
Serializable {
    public static final String ALL = "*";
    public static final Protocol PROTOCOL_ALL = new Protocol("*"){
        private static final long serialVersionUID = 388987764125558623L;

        @Override
        public boolean isSupported(String protocolName) {
            return true;
        }
    };
    private static final long serialVersionUID = -4384010555880806765L;
    private static final Pattern PAT_PROT = Pattern.compile("([a-z0-9]+)(?:((?:_[a-z0-9]+)*))?");
    private final String[] aliases;
    private final int hashCode;
    private final String name;
    private String abbr;

    public static Protocol parseProtocol(String protocol) throws OXException {
        String[] aliases;
        if (ALL.equals(protocol)) {
            return PROTOCOL_ALL;
        }
        Matcher m = PAT_PROT.matcher(protocol);
        if (!m.matches()) {
            throw MailExceptionCode.PROTOCOL_PARSE_ERROR.create(protocol);
        }
        String s = m.group(2);
        if (null != s) {
            String[] sa = s.split("_");
            aliases = new String[sa.length - 1];
            System.arraycopy(sa, 1, aliases, 0, aliases.length);
        } else {
            aliases = null;
        }
        return new Protocol(m.group(1), aliases);
    }

    public Protocol(String name) {
        if (null == name) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name.toLowerCase(Locale.ENGLISH);
        this.aliases = null;
        this.hashCode = 31 + name.hashCode();
    }

    public Protocol(String name, String secureName) {
        if (null == name) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name.toLowerCase(Locale.ENGLISH);
        this.aliases = secureName == null ? null : new String[]{secureName.toLowerCase(Locale.ENGLISH)};
        this.hashCode = 31 + name.hashCode();
    }

    public Protocol(String name, String[] aliases) {
        if (null == name) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name.toLowerCase(Locale.ENGLISH);
        if (null == aliases) {
            this.aliases = null;
        } else {
            this.aliases = new String[aliases.length];
            System.arraycopy(aliases, 0, this.aliases, 0, aliases.length);
            for (int i = 0; i < this.aliases.length; ++i) {
                this.aliases[i] = this.aliases[i].toLowerCase(Locale.ENGLISH);
            }
        }
        this.hashCode = 31 + name.hashCode();
    }

    public int getMaxCount(String host, boolean primary) throws OXException {
        return -1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Protocol)) {
            return false;
        }
        Protocol other = (Protocol)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String[] getAliases() {
        if (null == this.aliases) {
            return null;
        }
        String[] retval = new String[this.aliases.length];
        System.arraycopy(this.aliases, 0, retval, 0, this.aliases.length);
        return retval;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean isSupported(String protocolName) {
        String oName = protocolName.toLowerCase(Locale.ENGLISH);
        if (this.name.equals(oName)) {
            return true;
        }
        if (null != this.aliases) {
            for (int i = 0; i < this.aliases.length; ++i) {
                if (!this.aliases[i].equals(oName)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        if (null != this.aliases) {
            for (int i = 0; i < this.aliases.length; ++i) {
                sb.append('_').append(this.aliases[i]);
            }
        }
        return sb.toString();
    }

    public String getAbbreviation() {
        if (null == this.abbr) {
            this.abbr = this.name.toUpperCase(Locale.ENGLISH);
        }
        return this.abbr;
    }
}

