/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.login.internal;

import com.openexchange.authentication.Authenticated;
import com.openexchange.authentication.Cookie;
import com.openexchange.authentication.LoginExceptionCodes;
import com.openexchange.authentication.ResponseEnhancement;
import com.openexchange.authentication.ResultCode;
import com.openexchange.authentication.SessionEnhancement;
import com.openexchange.authentication.service.Authentication;
import com.openexchange.authorization.Authorization;
import com.openexchange.authorization.AuthorizationService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextExceptionCodes;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.notify.hostname.internal.HostDataImpl;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.Strings;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.login.LoginHandlerService;
import com.openexchange.login.LoginRequest;
import com.openexchange.login.LoginResult;
import com.openexchange.login.internal.AddSessionParameterImpl;
import com.openexchange.login.internal.LoginHandlerRegistry;
import com.openexchange.login.internal.LoginPerformerTask;
import com.openexchange.login.internal.LoginResultImpl;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.AddSessionParameter;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.threadpool.behavior.CallerRunsBehavior;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public final class LoginPerformer {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(LoginPerformer.class));
    private static final LoginPerformer SINGLETON = new LoginPerformer();
    private static final Pattern SPLIT = Pattern.compile(" *, *");
    private static final String PARAM_SESSION = "__session";
    private static final String PARAM_VOLATILE = "__volatile";
    private static final int MAX_RETRY = 1;

    private LoginPerformer() {
    }

    public static LoginPerformer getInstance() {
        return SINGLETON;
    }

    public LoginResult doLogin(LoginRequest request) throws OXException {
        return this.doLogin(request, new HashMap<String, Object>());
    }

    public LoginResult doLogin(final LoginRequest request, final Map<String, Object> properties) throws OXException {
        return this.doLogin(request, properties, new LoginPerformerClosure(){

            @Override
            public Authenticated doAuthentication(LoginResultImpl retval) throws OXException {
                return Authentication.login(request.getLogin(), request.getPassword(), properties);
            }
        });
    }

    public LoginResult doAutoLogin(final LoginRequest request) throws OXException {
        final HashMap<String, Object> properties = new HashMap<String, Object>();
        return this.doLogin(request, properties, new LoginPerformerClosure(){

            @Override
            public Authenticated doAuthentication(LoginResultImpl retval) throws OXException {
                try {
                    return Authentication.autologin(request.getLogin(), request.getPassword(), properties);
                }
                catch (OXException e) {
                    if (LoginExceptionCodes.NOT_SUPPORTED.equals(e)) {
                        return null;
                    }
                    throw e;
                }
            }
        });
    }

    private LoginResult doLogin(LoginRequest request, Map<String, Object> properties, LoginPerformerClosure loginPerfClosure) throws OXException {
        LoginResultImpl retval = new LoginResultImpl();
        retval.setRequest(request);
        try {
            String capabilities;
            Authenticated authed;
            Cookie[] cookies;
            Map<String, List<String>> headers = request.getHeaders();
            if (headers != null) {
                properties.put("headers", headers);
            }
            if (null != (cookies = request.getCookies())) {
                properties.put("cookies", cookies);
            }
            if (null == (authed = loginPerfClosure.doAuthentication(retval))) {
                LoginResult loginResult = null;
                return loginResult;
            }
            if (authed instanceof ResponseEnhancement) {
                ResponseEnhancement responseEnhancement = (ResponseEnhancement)authed;
                retval.setHeaders(responseEnhancement.getHeaders());
                retval.setCookies(responseEnhancement.getCookies());
                retval.setRedirect(responseEnhancement.getRedirect());
                ResultCode code = responseEnhancement.getCode();
                retval.setCode(code);
                if (ResultCode.REDIRECT.equals((Object)code) || ResultCode.FAILED.equals((Object)code)) {
                    LoginResultImpl loginResultImpl = retval;
                    return loginResultImpl;
                }
            }
            Context ctx = this.findContext(authed.getContextInfo());
            retval.setContext(ctx);
            String username = authed.getUserInfo();
            User user = this.findUser(ctx, username);
            retval.setUser(user);
            AuthorizationService authService = Authorization.getService();
            if (null == authService) {
                OXException e = ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{AuthorizationService.class.getName()});
                LOG.error((Object)"unable to find AuthorizationService", (Throwable)e);
                throw e;
            }
            authService.authorizeUser(ctx, user);
            this.checkClient(request, user, ctx);
            SessiondService sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class, true);
            Session session = null;
            int cnt = 0;
            while (null == session && cnt++ < 1) {
                AddSessionParameterImpl parameterObject = new AddSessionParameterImpl(username, request, user, ctx);
                parameterObject.setParameter(PARAM_VOLATILE, request.isVolatile());
                String sessionId = sessiondService.addSession((AddSessionParameter)parameterObject);
                session = sessiondService.getSession(sessionId);
            }
            if (null == session) {
                throw LoginExceptionCodes.UNKNOWN.create(new Object[]{"Session could not be created."});
            }
            HttpServletRequest req = (HttpServletRequest)properties.get("http.request");
            if (null != req) {
                session.setParameter("com.openexchange.groupware.hostdata", (Object)new HostDataImpl(req, user.getId(), ctx.getContextId()));
            }
            if (null == (capabilities = (String)properties.get("client.capabilities"))) {
                session.setParameter(Session.PARAM_CAPABILITIES, Collections.emptyList());
            } else {
                String[] sa = SPLIT.split(capabilities, 0);
                int length = sa.length;
                if (0 == length) {
                    session.setParameter(Session.PARAM_CAPABILITIES, Collections.emptyList());
                } else {
                    session.setParameter(Session.PARAM_CAPABILITIES, Collections.unmodifiableList(Arrays.asList(sa)));
                }
            }
            if (SessionEnhancement.class.isInstance(authed)) {
                ((SessionEnhancement)authed).enhanceSession(session);
            }
            retval.setSession(session);
            LoginPerformer.triggerLoginHandlers(retval);
            LoginResultImpl loginResultImpl = retval;
            return loginResultImpl;
        }
        catch (OXException e) {
            if ("DBP".equals(e.getPrefix())) {
                LOG.error((Object)e.getLogMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            throw LoginExceptionCodes.UNKNOWN.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            LoginPerformer.logLoginRequest(request, retval);
        }
    }

    private void checkClient(LoginRequest request, User user, Context ctx) throws OXException {
        UserConfigurationStorage ucs;
        UserConfiguration userConfiguration;
        String client = request.getClient();
        if ("USM-JSON".equalsIgnoreCase(client) && !(userConfiguration = (ucs = UserConfigurationStorage.getInstance()).getUserConfiguration(user.getId(), user.getGroups(), ctx)).hasOLOX20()) {
            throw LoginExceptionCodes.CLIENT_DENIED.create(new Object[]{client});
        }
    }

    private Context findContext(String contextInfo) throws OXException {
        ContextStorage contextStor = ContextStorage.getInstance();
        int contextId = contextStor.getContextId(contextInfo);
        if (-1 == contextId) {
            throw ContextExceptionCodes.NO_MAPPING.create(contextInfo);
        }
        Context context = contextStor.getContext(contextId);
        if (null == context) {
            throw ContextExceptionCodes.NOT_FOUND.create(Autoboxing.I((int)contextId));
        }
        return context;
    }

    private User findUser(Context ctx, String userInfo) throws OXException {
        User u;
        String proxyDelimiter = MailProperties.getInstance().getAuthProxyDelimiter();
        UserStorage us = UserStorage.getInstance();
        try {
            int userId = 0;
            userId = null != proxyDelimiter && userInfo.contains(proxyDelimiter) ? us.getUserId(userInfo.substring(userInfo.indexOf(proxyDelimiter) + proxyDelimiter.length(), userInfo.length()), ctx) : us.getUserId(userInfo, ctx);
            u = us.getUser(userId, ctx);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
        return u;
    }

    public Session doLogout(String sessionId) throws OXException {
        SessiondService sessiondService;
        try {
            sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class, true);
        }
        catch (OXException e) {
            throw LoginExceptionCodes.COMMUNICATION.create((Throwable)e, new Object[0]);
        }
        Session session = sessiondService.getSession(sessionId);
        if (null == session) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No session found for ID: " + sessionId));
            }
            return null;
        }
        ContextStorage contextStor = ContextStorage.getInstance();
        Context context = contextStor.getContext(session.getContextId());
        if (null == context) {
            throw ContextExceptionCodes.NOT_FOUND.create(session.getContextId());
        }
        UserStorage us = UserStorage.getInstance();
        User u = us.getUser(session.getUserId(), context);
        LoginResultImpl logout = new LoginResultImpl(session, context, u);
        sessiondService.removeSession(sessionId);
        LoginPerformer.logLogout(logout);
        LoginPerformer.triggerLogoutHandlers(logout);
        return session;
    }

    private static void triggerLoginHandlers(final LoginResult login) {
        ThreadPoolService executor = ThreadPools.getThreadPool();
        if (null == executor) {
            Iterator<LoginHandlerService> it = LoginHandlerRegistry.getInstance().getLoginHandlers();
            while (it.hasNext()) {
                try {
                    it.next().handleLogin(login);
                }
                catch (OXException e) {
                    LoginPerformer.logError(e);
                }
            }
        } else {
            Iterator<LoginHandlerService> it = LoginHandlerRegistry.getInstance().getLoginHandlers();
            while (it.hasNext()) {
                final LoginHandlerService handler = it.next();
                executor.submit((Task)new LoginPerformerTask(){

                    public Object call() {
                        try {
                            handler.handleLogin(login);
                        }
                        catch (OXException e) {
                            LoginPerformer.logError(e);
                        }
                        return null;
                    }
                }, CallerRunsBehavior.getInstance());
            }
        }
    }

    private static void triggerLogoutHandlers(final LoginResult logout) {
        ThreadPoolService executor = ThreadPools.getThreadPool();
        if (null == executor) {
            Iterator<LoginHandlerService> it = LoginHandlerRegistry.getInstance().getLoginHandlers();
            while (it.hasNext()) {
                try {
                    it.next().handleLogout(logout);
                }
                catch (OXException e) {
                    LoginPerformer.logError(e);
                }
            }
        } else {
            Iterator<LoginHandlerService> it = LoginHandlerRegistry.getInstance().getLoginHandlers();
            while (it.hasNext()) {
                final LoginHandlerService handler = it.next();
                executor.submit((Task)new LoginPerformerTask(){

                    public Object call() {
                        try {
                            handler.handleLogout(logout);
                        }
                        catch (OXException e) {
                            LoginPerformer.logError(e);
                        }
                        return null;
                    }
                }, CallerRunsBehavior.getInstance());
            }
        }
    }

    static void logError(OXException e) {
        e.log(LOG);
    }

    private static void logLoginRequest(LoginRequest request, LoginResult result) {
        Session session;
        User user;
        StringBuilder sb = new StringBuilder();
        sb.append("Login:");
        sb.append(request.getLogin());
        sb.append(" IP:");
        sb.append(request.getClientIP());
        sb.append(" AuthID:");
        sb.append(request.getAuthId());
        sb.append(" Agent:");
        sb.append(request.getUserAgent());
        sb.append(" Client:");
        sb.append(request.getClient());
        sb.append('(');
        sb.append(request.getVersion());
        sb.append(") Interface:");
        sb.append(request.getInterface().toString());
        Context ctx = result.getContext();
        if (null != ctx) {
            sb.append(" Context:");
            sb.append(ctx.getContextId());
            sb.append('(');
            sb.append(Strings.join((Object[])ctx.getLoginInfo(), (String)","));
            sb.append(')');
        }
        if (null != (user = result.getUser())) {
            sb.append(" User:");
            sb.append(user.getId());
            sb.append('(');
            sb.append(user.getLoginInfo());
            sb.append(')');
        }
        if (null != (session = result.getSession())) {
            sb.append(" Session:");
            sb.append(session.getSessionID());
            sb.append(" Random:");
            sb.append(session.getRandomToken());
        } else {
            sb.append(" Failed.");
        }
        LOG.info((Object)sb.toString());
    }

    private static void logLogout(LoginResult result) {
        StringBuilder sb = new StringBuilder();
        sb.append("Logout ");
        Context ctx = result.getContext();
        sb.append(" Context:");
        sb.append(ctx.getContextId());
        sb.append('(');
        sb.append(Strings.join((Object[])ctx.getLoginInfo(), (String)","));
        sb.append(')');
        User user = result.getUser();
        sb.append(" User:");
        sb.append(user.getId());
        sb.append('(');
        sb.append(user.getLoginInfo());
        sb.append(')');
        Session session = result.getSession();
        sb.append(" Session:");
        sb.append(session.getSessionID());
        LOG.info((Object)sb.toString());
    }

    public Session lookupSession(String sessionId) throws OXException {
        return ServerServiceRegistry.getInstance().getService(SessiondService.class, true).getSession(sessionId);
    }

    private static interface LoginPerformerClosure {
        public Authenticated doAuthentication(LoginResultImpl var1) throws OXException;
    }
}

