/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n.tools.replacement;

import com.openexchange.i18n.tools.TemplateToken;
import com.openexchange.i18n.tools.replacement.FormatLocalizedStringReplacement;

public final class TaskPriorityReplacement
extends FormatLocalizedStringReplacement {
    private static final String[] PRIOS = new String[4];

    public static TaskPriorityReplacement emptyTaskPriorityReplacement() {
        return new TaskPriorityReplacement();
    }

    private TaskPriorityReplacement() {
        super(TemplateToken.TASK_PRIORITY, null, "");
    }

    public TaskPriorityReplacement(int taskPriority) {
        super(TemplateToken.TASK_PRIORITY, "Priority: %1$s", PRIOS[TaskPriorityReplacement.checkPriority(taskPriority)]);
    }

    private static int checkPriority(int taskPriority) {
        if (taskPriority < 1 || taskPriority >= PRIOS.length) {
            throw new IllegalArgumentException("Invalid task priority specified: " + taskPriority);
        }
        return taskPriority;
    }

    static {
        TaskPriorityReplacement.PRIOS[0] = "";
        TaskPriorityReplacement.PRIOS[1] = "Low";
        TaskPriorityReplacement.PRIOS[2] = "Normal";
        TaskPriorityReplacement.PRIOS[3] = "High";
    }
}

