/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n.tools.replacement;

import com.openexchange.i18n.tools.TemplateReplacement;
import com.openexchange.i18n.tools.TemplateToken;
import java.util.Locale;
import java.util.TimeZone;

public final class ModuleReplacement
implements TemplateReplacement {
    private static final String[] MODULES = new String[]{"calendar", "task"};
    public static final int MODULE_UNKNOWN = -1;
    public static final int MODULE_CALENDAR = 0;
    public static final int MODULE_TASK = 1;
    private String repl;
    private boolean changed;

    public ModuleReplacement(int module) {
        this.repl = module < 0 || module >= MODULES.length ? "unknown" : MODULES[module];
    }

    @Override
    public String getReplacement() {
        return this.repl;
    }

    @Override
    public TemplateToken getToken() {
        return TemplateToken.MODULE;
    }

    @Override
    public boolean changed() {
        return this.changed;
    }

    @Override
    public boolean relevantChange() {
        return this.changed();
    }

    @Override
    public TemplateReplacement setChanged(boolean changed) {
        this.changed = changed;
        return this;
    }

    @Override
    public TemplateReplacement setLocale(Locale locale) {
        return this;
    }

    @Override
    public TemplateReplacement setTimeZone(TimeZone timeZone) {
        return this;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public TemplateReplacement getClone() throws CloneNotSupportedException {
        return (TemplateReplacement)this.clone();
    }

    @Override
    public boolean merge(TemplateReplacement other) {
        if (!ModuleReplacement.class.isInstance(other)) {
            return false;
        }
        if (!this.getToken().equals((Object)other.getToken())) {
            return false;
        }
        if (!other.changed()) {
            return false;
        }
        ModuleReplacement o = (ModuleReplacement)other;
        this.repl = o.repl;
        this.changed = true;
        return true;
    }
}

