/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n.tools.replacement;

import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.i18n.tools.TemplateToken;
import com.openexchange.i18n.tools.replacement.AbstractDateReplacement;
import com.openexchange.server.services.ServerServiceRegistry;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class CreationDateReplacement
extends AbstractDateReplacement {
    public CreationDateReplacement(Date creationDate, Locale locale) {
        this(creationDate, locale, null);
    }

    public CreationDateReplacement(Date creationDate, Locale locale, TimeZone timeZone) {
        super(CreationDateReplacement.trimDateToMinutesOnly(creationDate), true, locale, timeZone);
    }

    @Override
    public TemplateToken getToken() {
        return TemplateToken.CREATION_DATETIME;
    }

    private static Date trimDateToMinutesOnly(Date d) {
        if (d == null) {
            return d;
        }
        Calendar helper = Calendar.getInstance(ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class).getTimeZone("UTC"), Locale.ENGLISH);
        helper.setTime(d);
        helper.set(13, 0);
        helper.set(14, 0);
        return helper.getTime();
    }
}

