/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.upload.impl;

import com.openexchange.exception.Category;
import com.openexchange.exception.LogLevel;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public class UploadException
extends OXException {
    private static final long serialVersionUID = 8590042770250274015L;
    private String action;

    protected UploadException(int code, String displayMessage, Throwable cause, Object ... displayArgs) {
        super(code, displayMessage, cause, displayArgs);
    }

    public UploadException setAction(String action) {
        this.action = action;
        return this;
    }

    public String getAction() {
        return this.action;
    }

    public static enum UploadCode implements OXExceptionCode
    {
        UPLOAD_FAILED("File upload failed: %1$s", CATEGORY_ERROR, 1),
        MISSING_AFFILIATION_ID("Missing affiliation id", CATEGORY_ERROR, 2),
        UNKNOWN_ACTION_VALUE("Unknown action value: %1$s", CATEGORY_ERROR, 3),
        NO_MULTIPART_CONTENT("Header \"content-type\" does not indicate multipart content", CATEGORY_ERROR, 4),
        MAX_UPLOAD_SIZE_EXCEEDED("Request rejected because its size (%1$s) exceeds the maximum configured size of %2$s", CATEGORY_USER_INPUT, 5),
        MISSING_PARAM("Missing parameter %1$s", CATEGORY_ERROR, 6),
        UNKNOWN_MODULE("Unknown module: %1$d", CATEGORY_ERROR, 7),
        UPLOAD_FILE_NOT_FOUND("An uploaded file referenced by %1$s could not be found", CATEGORY_USER_INPUT, 8),
        INVALID_ACTION_VALUE("Invalid action value: %1$s", CATEGORY_ERROR, 9),
        FILE_NOT_FOUND("Upload file with id %1$s could not be found", CATEGORY_ERROR, 10),
        INVALID_FILE_TYPE("Upload file's content type \"%1$s\" does not match given file filter \"%2$s\"", CATEGORY_ERROR, 11),
        UNEXPECTED_ERROR("An error occurred: %1$s", CATEGORY_ERROR, 12);

        private final String message;
        private final Category category;
        private final int detailNumber;

        private UploadCode(String message, Category category, int detailNumber) {
            this.message = message;
            this.category = category;
            this.detailNumber = detailNumber;
        }

        public String getPrefix() {
            return "UPL";
        }

        public final Category getCategory() {
            return this.category;
        }

        public final int getNumber() {
            return this.detailNumber;
        }

        public final String getMessage() {
            return this.message;
        }

        public boolean equals(OXException e) {
            return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
        }

        public UploadException create() {
            return this.create(new Object[0]);
        }

        public UploadException create(Object ... args) {
            return this.create(null, args);
        }

        public UploadException create(Throwable cause, Object ... args) {
            UploadException ret;
            Category category = this.getCategory();
            if (category.getLogLevel().implies(LogLevel.DEBUG)) {
                ret = new UploadException(this.getNumber(), this.getMessage(), cause, args);
            } else {
                ret = new UploadException(this.getNumber(), Category.EnumType.TRY_AGAIN.equals((Object)category.getType()) ? "An error occurred. Please try again later." : "A severe error occurred.", cause, new Object[0]);
                ret.setLogMessage(this.getMessage(), args);
            }
            ret.addCategory(category);
            ret.setPrefix(this.getPrefix());
            return ret;
        }
    }
}

