/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tools.console;

import com.openexchange.groupware.update.tools.Constants;
import com.openexchange.management.console.JMXAuthenticatorImpl;
import com.openexchange.tools.console.TableWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class ListExecutedTasksCLT {
    private static final Options toolkitOptions = new Options();
    private static final TableWriter.ColumnFormat[] FORMATS;
    private static final String[] COLUMNS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        JMXServiceURL url;
        HashMap<String, JMXAuthenticatorImpl> environment;
        CommandLine cmd;
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(toolkitOptions, args);
        }
        catch (MissingOptionException e) {
            ListExecutedTasksCLT.printHelp();
            System.err.println("Option " + e.getMessage() + " must be defined.");
            System.exit(1);
            return;
        }
        catch (MissingArgumentException e) {
            ListExecutedTasksCLT.printHelp();
            System.err.println(e.getMessage());
            System.exit(1);
            return;
        }
        catch (ParseException e) {
            e.printStackTrace();
            System.err.println("Unable to parse command line: " + e.getMessage());
            ListExecutedTasksCLT.printHelp();
            System.exit(1);
            return;
        }
        if (cmd.hasOption('h')) {
            ListExecutedTasksCLT.printHelp();
            System.exit(0);
        }
        String schemaName = cmd.getOptionValue('n');
        int port = 9999;
        String val = cmd.getOptionValue('p');
        if (null != val) {
            try {
                port = Integer.parseInt(val.trim());
            }
            catch (NumberFormatException e) {
                System.err.println("Port parameter value \"" + val + "\" is not a number.");
                ListExecutedTasksCLT.printHelp();
                System.exit(1);
            }
            if (port < 1 || port > 65535) {
                System.err.println("Port parameter value " + port + " is out of range. Valid range is from 1 to 65535.");
                ListExecutedTasksCLT.printHelp();
                System.exit(1);
            }
        }
        String jmxLogin = cmd.getOptionValue('l');
        String jmxPassword = cmd.getOptionValue('s');
        if (jmxLogin == null || jmxPassword == null) {
            environment = null;
        } else {
            environment = new HashMap<String, JMXAuthenticatorImpl>(1);
            environment.put("jmx.remote.authenticator", new JMXAuthenticatorImpl(jmxLogin, jmxPassword));
        }
        try {
            url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + port + "/server");
        }
        catch (MalformedURLException e) {
            System.err.println("URL to connect to server is invalid: " + e.getMessage());
            System.exit(1);
            return;
        }
        try {
            JMXConnector jmxConnector = JMXConnectorFactory.connect(url, environment);
            try {
                MBeanServerConnection mbsc = jmxConnector.getMBeanServerConnection();
                TabularData taskList = (TabularData)mbsc.invoke(Constants.OBJECT_NAME, "listExecutedTasks", new Object[]{schemaName}, null);
                ListExecutedTasksCLT.writeTasks(taskList);
            }
            finally {
                jmxConnector.close();
            }
        }
        catch (InstanceNotFoundException e) {
            System.err.println("Instance is not available: " + e.getMessage());
            System.exit(1);
        }
        catch (MBeanException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (ReflectionException e) {
            System.err.println("Problem with reflective type handling: " + e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Unable to communicate with the server: " + e.getMessage());
            System.exit(1);
        }
    }

    private static void writeTasks(TabularData taskList) {
        ArrayList<List<Object>> data = new ArrayList<List<Object>>();
        ArrayList<Object> valuesList = new ArrayList<Object>(COLUMNS.length);
        for (String column : COLUMNS) {
            valuesList.add(column);
        }
        data.add(valuesList);
        for (Object tmp : taskList.values()) {
            CompositeData composite = (CompositeData)tmp;
            valuesList = new ArrayList(COLUMNS.length);
            for (String column : COLUMNS) {
                valuesList.add(composite.get(column));
            }
            data.add(valuesList);
        }
        new TableWriter(System.out, FORMATS, data).write();
    }

    private static void printHelp() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("listExecutedTasks", toolkitOptions);
    }

    static {
        toolkitOptions.addOption(new Option("h", "help", false, "Prints a help text."));
        Option schemaOption = new Option("n", "name", true, "A valid schema name.");
        schemaOption.setRequired(true);
        schemaOption.setType(String.class);
        toolkitOptions.addOption(schemaOption);
        Option portOption = new Option("p", "port", true, "The optional JMX port (default:9999)");
        portOption.setType(Integer.TYPE);
        toolkitOptions.addOption(portOption);
        Option loginOption = new Option("l", "login", true, "The optional JMX login (if JMX has authentication enabled)");
        loginOption.setType(String.class);
        toolkitOptions.addOption(loginOption);
        Option passwdOption = new Option("s", "password", true, "The optional JMX password (if JMX has authentication enabled)");
        passwdOption.setType(String.class);
        toolkitOptions.addOption(passwdOption);
        FORMATS = new TableWriter.ColumnFormat[]{new TableWriter.ColumnFormat(TableWriter.ColumnFormat.Align.LEFT), new TableWriter.ColumnFormat(TableWriter.ColumnFormat.Align.LEFT), new TableWriter.ColumnFormat(TableWriter.ColumnFormat.Align.LEFT)};
        COLUMNS = new String[]{"taskName", "successful", "lastModified"};
    }
}

