/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.sql.DBUtils;
import java.sql.SQLException;

public class CalendarExtendDNColumnTask
implements UpdateTask {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(CalendarExtendDNColumnTask.class));
    private static final int DESIRED_SIZE = 320;
    private static final String SQL_MODIFY = "ALTER TABLE #TABLE# MODIFY dn varchar(320) collate utf8_unicode_ci default NULL";

    @Override
    public int addedWithVersion() {
        return 33;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.HIGHEST.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Starting " + CalendarExtendDNColumnTask.class.getSimpleName()));
        }
        this.modifyColumnInTable("prg_date_rights", contextId);
        this.modifyColumnInTable("del_date_rights", contextId);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)(CalendarExtendDNColumnTask.class.getSimpleName() + " finished."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void modifyColumnInTable(String tableName, int contextId) throws OXException {
        block15: {
            if (CalendarExtendDNColumnTask.LOG.isInfoEnabled()) {
                CalendarExtendDNColumnTask.LOG.info((Object)(CalendarExtendDNColumnTask.class.getSimpleName() + ": Going to extend size of column `dn` in table `" + tableName + "`."));
            }
            con = Database.getNoTimeout(contextId, true);
            rs = null;
            try {
                metadata = con.getMetaData();
                rs = metadata.getColumns(null, null, tableName, null);
                columnName = "dn";
lbl10:
                // 2 sources

                while (rs.next()) {
                    name = rs.getString("COLUMN_NAME");
                    if (!"dn".equals(name) || (size = rs.getInt("COLUMN_SIZE")) < 320) break block15;
                    CalendarExtendDNColumnTask.LOG.info((Object)(CalendarExtendDNColumnTask.class.getSimpleName() + ": Column " + tableName + '.' + name + " with size " + size + " is already equal to/greater than " + 320));
                    break;
                }
            }
            finally {
                Database.backNoTimeout(contextId, true, con);
            }
            DBUtils.closeSQLStuff(rs);
            rs = null;
            return;
        }
        ** GOTO lbl10
        DBUtils.closeSQLStuff(rs);
        rs = null;
        stmt = null;
        try {
            stmt = con.prepareStatement("ALTER TABLE #TABLE# MODIFY dn varchar(320) collate utf8_unicode_ci default NULL".replaceFirst("#TABLE#", tableName));
            stmt.executeUpdate();
            ** GOTO lbl47
        }
        catch (SQLException e) {
            try {
                throw CalendarExtendDNColumnTask.wrapSQLException(e);
            }
            catch (Throwable var10_12) {
                DBUtils.closeSQLStuff(stmt);
                throw var10_12;
                catch (SQLException e) {
                    try {
                        throw CalendarExtendDNColumnTask.wrapSQLException(e);
                    }
                    catch (Throwable var9_11) {
                        DBUtils.closeSQLStuff(rs);
                        rs = null;
                        throw var9_11;
                    }
                }
lbl47:
                // 1 sources

                DBUtils.closeSQLStuff(stmt);
            }
        }
        if (CalendarExtendDNColumnTask.LOG.isInfoEnabled() == false) return;
        CalendarExtendDNColumnTask.LOG.info((Object)(CalendarExtendDNColumnTask.class.getSimpleName() + ": Size of column `dn` in table `" + tableName + "` successfully extended."));
    }

    private static OXException wrapSQLException(SQLException e) {
        return UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
    }
}

