/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.tasks.Folder;
import com.openexchange.groupware.tasks.FolderStorage;
import com.openexchange.groupware.tasks.GetTask;
import com.openexchange.groupware.tasks.InternalParticipant;
import com.openexchange.groupware.tasks.ParticipantStorage;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskLogic;
import com.openexchange.groupware.tasks.TaskParticipant;
import com.openexchange.groupware.tasks.TaskStorage;
import com.openexchange.groupware.tasks.Tasks;
import com.openexchange.groupware.tasks.Tools;
import com.openexchange.session.Session;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

final class TasksImpl
extends Tasks {
    private static final int[] UPDATE_FIELDS = new int[]{5, 3};

    @Override
    public boolean containsNotSelfCreatedTasks(Session session, Connection con, int folderId) throws OXException {
        Context ctx = Tools.getContext(session.getContextId());
        return TaskStorage.getInstance().containsNotSelfCreatedTasks(ctx, con, session.getUserId(), folderId);
    }

    @Override
    public void deleteTasksInFolder(Session session, Connection con, int folderId) throws OXException {
        int[] taskIds;
        ParticipantStorage partStor = ParticipantStorage.getInstance();
        FolderStorage foldStor = FolderStorage.getInstance();
        int userId = session.getUserId();
        ArrayList<Integer> deleteTask = new ArrayList<Integer>();
        ArrayList<UpdateData> removeParticipant = new ArrayList<UpdateData>();
        Context ctx = Tools.getContext(session.getContextId());
        for (int taskId : taskIds = foldStor.getTasksInFolder(ctx, con, folderId, StorageType.ACTIVE)) {
            UpdateData data = new UpdateData();
            data.taskId = taskId;
            removeParticipant.add(data);
        }
        for (UpdateData data : removeParticipant) {
            Folder folder;
            Set<Folder> folders2 = foldStor.selectFolder(ctx, con, data.taskId, StorageType.ACTIVE);
            if (folders2.size() == 1) {
                deleteTask.add(data.taskId);
                continue;
            }
            Set<InternalParticipant> participants = ParticipantStorage.extractInternal(partStor.selectParticipants(ctx, con, data.taskId, StorageType.ACTIVE));
            InternalParticipant participant = ParticipantStorage.getParticipant(participants, (folder = FolderStorage.getFolder(folders2, folderId)).getUser());
            if (null == participant) {
                deleteTask.add(data.taskId);
                continue;
            }
            data.task = new Task();
            data.task.setObjectID(data.taskId);
            data.task.setLastModified(new Date());
            data.task.setModifiedBy(userId);
            UpdateData.access$302(data, UPDATE_FIELDS);
            data.add = TaskParticipant.EMPTY;
            data.remove = new HashSet(1, 1.0f);
            data.remove.add(participant);
            data.addFolder = Folder.EMPTY;
            data.removeFolder = new HashSet(1, 1.0f);
            data.removeFolder.add(folder);
        }
        removeParticipant.removeAll(deleteTask);
        Iterator i$ = deleteTask.iterator();
        while (i$.hasNext()) {
            int taskId = (Integer)i$.next();
            Task task = GetTask.load(ctx, con, folderId, taskId, StorageType.ACTIVE);
            TaskLogic.deleteTask(ctx, con, userId, task, task.getLastModified());
            TaskLogic.informDelete(session, ctx, con, task);
        }
        for (UpdateData data : removeParticipant) {
            if (deleteTask.contains(data.taskId)) continue;
            com.openexchange.groupware.tasks.UpdateData.updateTask(ctx, con, data.task, new Date(), data.modified, data.add, data.remove, data.addFolder, data.removeFolder);
        }
    }

    @Override
    public boolean isFolderEmpty(Context ctx, int folderId) throws OXException {
        TaskStorage storage = TaskStorage.getInstance();
        return storage.countTasks(ctx, -1, folderId, false, false) == 0;
    }

    @Override
    public boolean isFolderEmpty(Context ctx, Connection con, int folderId) throws OXException {
        return this.isFolderEmpty(ctx, folderId);
    }

    private static class UpdateData {
        private int taskId;
        private Task task;
        private int[] modified;
        private Set<TaskParticipant> add;
        private Set<TaskParticipant> remove;
        private Set<Folder> addFolder;
        private Set<Folder> removeFolder;

        private UpdateData() {
        }

        static /* synthetic */ int[] access$302(UpdateData x0, int[] x1) {
            x0.modified = x1;
            return x1;
        }
    }
}

