/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.impl;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.settings.SettingExceptionCodes;
import com.openexchange.groupware.settings.impl.AbstractSetting;
import java.util.ArrayList;

public class ValueSetting
extends AbstractSetting<ValueSetting> {
    private Object singleValue;
    private ArrayList<Object> multiValue;

    public ValueSetting(Setting toCopy) {
        super(toCopy.getName(), toCopy.getId(), toCopy.getShared());
        Setting[] toCopyElements = toCopy.getElements();
        if (null != toCopyElements) {
            for (Setting element : toCopyElements) {
                ValueSetting child = new ValueSetting(element);
                this.addElement(child);
                child.setParent(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getMultiValue() {
        Object[] retval;
        ValueSetting valueSetting = this;
        synchronized (valueSetting) {
            retval = null == this.multiValue || 0 == this.multiValue.size() ? null : this.multiValue.toArray(new Object[this.multiValue.size()]);
        }
        return retval;
    }

    @Override
    public boolean isEmptyMultivalue() {
        return this.multiValue != null && this.multiValue.isEmpty();
    }

    @Override
    public Object getSingleValue() {
        return this.singleValue;
    }

    @Override
    public void setSingleValue(Object value) {
        this.singleValue = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMultiValue(Object value) {
        if (null != value) {
            ValueSetting valueSetting = this;
            synchronized (valueSetting) {
                if (null == this.multiValue) {
                    this.multiValue = new ArrayList();
                }
                this.multiValue.add(value);
            }
        }
    }

    @Override
    public void setEmptyMultiValue() {
        this.multiValue = new ArrayList();
    }

    @Override
    public void removeElement(Setting child) throws OXException {
        if (!(child instanceof ValueSetting)) {
            throw SettingExceptionCodes.NOT_ALLOWED.create();
        }
        super.removeElementInternal((ValueSetting)child);
    }

    @Override
    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append(this.getName());
        out.append('=');
        if (null == this.getElements()) {
            if (null != this.multiValue && this.multiValue.size() > 0) {
                out.append(this.multiValue);
            } else {
                out.append(this.singleValue);
            }
        } else {
            ValueSetting[] elements;
            out.append('(');
            for (ValueSetting element : elements = (ValueSetting[])this.getElements()) {
                out.append(element.toString());
                out.append(',');
            }
            if (elements.length != 0) {
                out.setLength(out.length() - 1);
            }
            out.append(')');
        }
        return out.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ValueSetting)) {
            return false;
        }
        ValueSetting other = (ValueSetting)obj;
        if (this.singleValue != null && !this.singleValue.equals(other.getSingleValue())) {
            return false;
        }
        return this.multiValue == null || this.multiValue.equals(other.getMultiValue());
    }

    @Override
    public int hashCode() {
        int retval = super.hashCode();
        if (this.singleValue != null) {
            retval ^= this.singleValue.hashCode();
        }
        if (this.multiValue != null) {
            retval ^= this.multiValue.hashCode();
        }
        return retval;
    }
}

