/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.reminder.json.actions;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.AppointmentSqlFactoryService;
import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.OXCalendarExceptionCodes;
import com.openexchange.groupware.calendar.RecurringResultInterface;
import com.openexchange.groupware.calendar.RecurringResultsInterface;
import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.groupware.reminder.json.ReminderAJAXRequest;
import com.openexchange.log.LogFactory;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractReminderAction
implements AJAXActionService {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(AbstractReminderAction.class));
    private static final AJAXRequestResult RESULT_JSON_NULL = new AJAXRequestResult(JSONObject.NULL, "json");
    private final ServiceLookup services;

    protected AbstractReminderAction(ServiceLookup services) {
        this.services = services;
    }

    protected AppointmentSqlFactoryService getService() {
        return (AppointmentSqlFactoryService)this.services.getService(AppointmentSqlFactoryService.class);
    }

    protected <S> S getService(Class<? extends S> clazz) {
        return (S)this.services.getService(clazz);
    }

    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        try {
            ReminderAJAXRequest reminderRequest = new ReminderAJAXRequest(requestData, session);
            String sTimeZone = requestData.getParameter("timezone");
            if (null != sTimeZone) {
                reminderRequest.setTimeZone(TimeZoneUtils.getTimeZone(sTimeZone));
            }
            return this.perform(reminderRequest);
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create(e, e.getMessage());
        }
    }

    protected abstract AJAXRequestResult perform(ReminderAJAXRequest var1) throws OXException, JSONException;

    protected static AJAXRequestResult getJSONNullResult() {
        return RESULT_JSON_NULL;
    }

    protected static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        char[] chars = string.toCharArray();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < chars.length; ++i) {
            isWhitespace = Character.isWhitespace(chars[i]);
        }
        return isWhitespace;
    }

    protected boolean getLatestRecurringReminder(Session sessionObj, TimeZone tz, Date endRange, ReminderObject reminder) throws OXException {
        CalendarDataObject calendarDataObject;
        AppointmentSQLInterface calendarSql = this.getService().createAppointmentSql(sessionObj);
        CalendarCollectionService recColl = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
        try {
            calendarDataObject = calendarSql.getObjectById(reminder.getTargetId(), reminder.getFolder());
        }
        catch (SQLException e) {
            throw OXCalendarExceptionCodes.CALENDAR_SQL_ERROR.create(e, new Object[0]);
        }
        Calendar calendar2 = Calendar.getInstance(tz);
        calendar2.add(2, -3);
        RecurringResultsInterface recurringResults = recColl.calculateRecurring(calendarDataObject, calendar2.getTimeInMillis(), endRange.getTime(), 0);
        boolean retval = false;
        if (recurringResults != null && recurringResults.size() > 0) {
            RecurringResultInterface recurringResult = recurringResults.getRecurringResult(recurringResults.size() - 1);
            calendar2.setTimeInMillis(recurringResult.getStart());
            calendar2.add(12, -calendarDataObject.getAlarm());
            if (calendar2.getTimeInMillis() >= reminder.getDate().getTime()) {
                reminder.setDate(calendar2.getTime());
                reminder.setRecurrencePosition(recurringResult.getPosition());
                retval = true;
            }
        } else if (calendarDataObject.getRecurrenceID() != calendarDataObject.getObjectID()) {
            retval = true;
        }
        return retval;
    }

    protected static boolean hasModulePermission(ReminderObject reminderObj, ServerSession session) {
        switch (reminderObj.getModule()) {
            case 1: {
                return session.getUserConfiguration().hasCalendar();
            }
            case 4: {
                return session.getUserConfiguration().hasTask();
            }
        }
        return true;
    }

    protected static final ReminderObject getNextRecurringReminder(Session sessionObj, TimeZone tz, ReminderObject reminder) throws OXException {
        RecurringResultsInterface recurringResults;
        CalendarDataObject calendarDataObject;
        AppointmentSQLInterface calendarSql = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class).createAppointmentSql(sessionObj);
        CalendarCollectionService recColl = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
        try {
            calendarDataObject = calendarSql.getObjectById(reminder.getTargetId(), reminder.getFolder());
        }
        catch (SQLException e) {
            throw OXCalendarExceptionCodes.CALENDAR_SQL_ERROR.create(e, new Object[0]);
        }
        try {
            long end_mod = calendarDataObject.getEndDate().getTime() % 86400000L;
            Date until = null;
            until = new Date(((CalendarObject)calendarDataObject).getUntil().getTime() + end_mod + (long)tz.getOffset(((CalendarObject)calendarDataObject).getUntil().getTime()));
            recurringResults = recColl.calculateRecurring(calendarDataObject, reminder.getDate().getTime(), until.getTime(), 0);
        }
        catch (OXException e) {
            LOG.error((Object)("Can't calculate next recurrence for appointment " + reminder.getTargetId() + " in context " + sessionObj.getContextId()), (Throwable)e);
            return null;
        }
        if (null == recurringResults || recurringResults.size() == 0) {
            return null;
        }
        ReminderObject nextReminder = null;
        Date now = new Date();
        for (int i = 0; i < recurringResults.size(); ++i) {
            RecurringResultInterface recurringResult = recurringResults.getRecurringResult(i);
            Calendar calendar2 = Calendar.getInstance(tz);
            calendar2.setTimeInMillis(recurringResult.getStart());
            calendar2.add(12, -calendarDataObject.getAlarm());
            if (!calendar2.getTime().after(reminder.getDate()) || !calendar2.getTime().after(now)) continue;
            nextReminder = reminder.clone();
            nextReminder.setRecurrenceAppointment(true);
            nextReminder.setRecurrencePosition(recurringResult.getPosition());
            nextReminder.setDate(calendar2.getTime());
            break;
        }
        return nextReminder;
    }
}

