/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.reminder.json;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.exception.OXException;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Pattern;

public final class ReminderAJAXRequest {
    public static final int NOT_FOUND = -9999;
    private final ServerSession session;
    private final AJAXRequestData request;
    private TimeZone timeZone;
    private static final Pattern SPLIT = Pattern.compile(" *, *");

    public ReminderAJAXRequest(AJAXRequestData request, ServerSession session) {
        this.request = request;
        this.session = session;
        this.timeZone = TimeZoneUtils.getTimeZone(session.getUser().getTimeZone());
    }

    public int checkInt(String name) throws OXException {
        String parameter = this.request.getParameter(name);
        if (null == parameter) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        try {
            return Integer.parseInt(parameter.trim());
        }
        catch (NumberFormatException e) {
            throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(name, parameter);
        }
    }

    public <V> V getData() {
        return (V)this.request.getData();
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public Date getDate(String name) throws OXException {
        String parameter = this.request.getParameter(name);
        if (null == parameter) {
            return null;
        }
        try {
            return new Date(Long.parseLong(parameter.trim()));
        }
        catch (NumberFormatException e) {
            throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(name, parameter);
        }
    }

    public Date checkDate(String name) throws OXException {
        String parameter = this.request.getParameter(name);
        if (null == parameter) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        try {
            return new Date(Long.parseLong(parameter.trim()));
        }
        catch (NumberFormatException e) {
            throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(name, parameter);
        }
    }

    public String checkParameter(String name) throws OXException {
        return this.request.checkParameter(name);
    }

    public String getParameter(String name) {
        return this.request.getParameter(name);
    }

    public int optInt(String name) throws OXException {
        String parameter = this.request.getParameter(name);
        if (null == parameter) {
            return -9999;
        }
        try {
            return Integer.parseInt(parameter.trim());
        }
        catch (NumberFormatException e) {
            throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(name, parameter);
        }
    }

    public int[] checkIntArray(String name) throws OXException {
        String parameter = this.request.getParameter(name);
        if (null == parameter) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        String[] sa = SPLIT.split(parameter, 0);
        int[] ret = new int[sa.length];
        for (int i = 0; i < sa.length; ++i) {
            try {
                ret[i] = Integer.parseInt(sa[i].trim());
                continue;
            }
            catch (NumberFormatException e) {
                throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(name, parameter);
            }
        }
        return ret;
    }

    public String[] checkStringArray(String name) throws OXException {
        String parameter = this.request.getParameter(name);
        if (null == parameter) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        return SPLIT.split(parameter, 0);
    }

    public String[] optStringArray(String name) {
        String parameter = this.request.getParameter(name);
        if (null == parameter) {
            return null;
        }
        return SPLIT.split(parameter, 0);
    }

    public AJAXRequestData getRequest() {
        return this.request;
    }

    public ServerSession getSession() {
        return this.session;
    }
}

