/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.ldap;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.cache.CacheFolderStorage;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.CachingUserStorage;
import com.openexchange.groupware.ldap.RdbUserStorage;
import com.openexchange.groupware.ldap.UnixCrypt;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserTools;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.sql.Connection;
import java.util.Date;

public abstract class UserStorage {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(UserStorage.class));
    private static volatile UserStorage instance;
    public static final int SEARCH_LOGIN_NAME = 1;
    public static final int SEARCH_DISPLAY_NAME = 2;

    protected UserStorage() {
    }

    public abstract int getUserId(String var1, Context var2) throws OXException;

    public abstract User getUser(int var1, Context var2) throws OXException;

    public abstract User getUser(Context var1, int var2, Connection var3) throws OXException;

    public abstract User[] getUser(Context var1, int[] var2) throws OXException;

    public abstract User[] getUser(Context var1) throws OXException;

    public final void updateUser(User user, Context context) throws OXException {
        this.updateUserInternal(user, context);
        CacheFolderStorage.dropUserEntries(user.getId(), context.getContextId());
    }

    protected abstract void updateUserInternal(User var1, Context var2) throws OXException;

    public abstract String getUserAttribute(String var1, int var2, Context var3) throws OXException;

    public abstract void setUserAttribute(String var1, String var2, int var3, Context var4) throws OXException;

    public abstract void setAttribute(String var1, String var2, int var3, Context var4) throws OXException;

    public abstract User searchUser(String var1, Context var2) throws OXException;

    public abstract User[] searchUserByMailLogin(String var1, Context var2) throws OXException;

    public abstract User[] searchUserByName(String var1, Context var2, int var3) throws OXException;

    public abstract int[] listAllUser(Context var1) throws OXException;

    public abstract int[] resolveIMAPLogin(String var1, Context var2) throws OXException;

    protected abstract void startInternal() throws OXException;

    protected abstract void stopInternal() throws OXException;

    public abstract int[] listModifiedUser(Date var1, Context var2) throws OXException;

    public abstract void invalidateUser(Context var1, int var2) throws OXException;

    public abstract int createUser(Context var1, User var2) throws OXException;

    public abstract int createUser(Connection var1, Context var2, User var3) throws OXException;

    public final void invalidateUser(Context ctx, int[] userIds) throws OXException {
        for (int member : userIds) {
            this.invalidateUser(ctx, member);
        }
    }

    public static final boolean authenticate(User user, String password) throws OXException {
        boolean retval = false;
        if ("{CRYPT}".equals(user.getPasswordMech())) {
            retval = UnixCrypt.matches(user.getUserPassword(), password);
        } else if ("{SHA}".equals(user.getPasswordMech())) {
            retval = UserTools.hashPassword(password).equals(user.getUserPassword());
        }
        return retval;
    }

    public static void start() throws OXException {
        if (null != instance) {
            LOG.error((Object)"Duplicate initialization of UserStorage.");
            return;
        }
        instance = new CachingUserStorage(new RdbUserStorage());
        instance.startInternal();
    }

    public static void stop() throws OXException {
        if (null == instance) {
            LOG.error((Object)"Duplicate shutdown of UserStorage.");
            return;
        }
        instance.stopInternal();
        instance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UserStorage getInstance() {
        UserStorage tmp = instance;
        if (null != tmp) return tmp;
        Class<UserStorage> clazz = UserStorage.class;
        synchronized (UserStorage.class) {
            tmp = instance;
            if (null != tmp) return tmp;
            try {
                tmp = new CachingUserStorage(new RdbUserStorage());
                tmp.startInternal();
                instance = tmp;
            }
            catch (OXException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
            return tmp;
        }
    }

    public static User getStorageUser(int uid, Context context) {
        try {
            return UserStorage.getInstance().getUser(uid, context);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static User getStorageUser(int uid, int contextId) {
        try {
            return UserStorage.getInstance().getUser(uid, ContextStorage.getStorageContext(contextId));
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

