/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.utils;

import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.impl.GetSwitch;
import com.openexchange.groupware.infostore.utils.Metadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class MetadataSorter {
    private String field = Metadata.TITLE_LITERAL.getName();
    private int direction = 1;
    private DocumentMetadata[] metadata;
    private List<DocumentMetadata> metadataList;

    public MetadataSorter(DocumentMetadata[] metadata) {
        this.metadata = metadata;
    }

    public MetadataSorter(DocumentMetadata[] metadata, String field) {
        this(metadata);
        this.field = field;
    }

    public MetadataSorter(DocumentMetadata[] metadata, String field, int direction) {
        this(metadata, field);
        this.direction = direction;
    }

    public MetadataSorter(List<DocumentMetadata> metadata) {
        this.metadataList = metadata;
    }

    public MetadataSorter(List<DocumentMetadata> metadata, String field) {
        this(metadata);
        this.field = field;
    }

    public MetadataSorter(List<DocumentMetadata> metadata, String field, int direction) {
        this(metadata, field);
        this.direction = direction;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public DocumentMetadata[] getSorted() {
        if (null == this.metadata && this.metadataList != null) {
            List<DocumentMetadata> sortedMetadata = this.getSortedAsList();
            return sortedMetadata.toArray(new DocumentMetadata[sortedMetadata.size()]);
        }
        if (this.metadata != null) {
            Arrays.sort(this.metadata, new MetadataComparator(this.field, this.direction));
        }
        return this.metadata;
    }

    public List<DocumentMetadata> getSortedAsList() {
        if (null == this.metadataList && null != this.metadata) {
            return Arrays.asList(this.getSorted());
        }
        if (null != this.metadataList) {
            ArrayList<DocumentMetadata> copy = new ArrayList<DocumentMetadata>(this.metadataList);
            Collections.sort(copy, new MetadataComparator(this.field, this.direction));
            return copy;
        }
        return Collections.emptyList();
    }

    private static final class MetadataComparator
    implements Comparator<DocumentMetadata> {
        private final String field;
        private final int direction;
        private final Metadata metadataField;

        public MetadataComparator(String field, int direction) {
            this.field = field;
            this.metadataField = Metadata.get(field);
            this.direction = direction;
        }

        @Override
        public int compare(DocumentMetadata arg0, DocumentMetadata arg1) {
            Comparable v1 = this.getValue(arg0);
            Comparable v2 = this.getValue(arg1);
            if (v2 == null && v1 == null) {
                return 0;
            }
            if (v2 == null) {
                return 1;
            }
            if (v1 == null) {
                return -1;
            }
            switch (this.direction) {
                case -1: {
                    return v2.compareTo(v1);
                }
            }
            return v1.compareTo(v2);
        }

        private Comparable getValue(DocumentMetadata arg0) {
            DocumentMetadata metadata = arg0;
            GetSwitch get = new GetSwitch(metadata);
            if (this.metadataField != null) {
                return (Comparable)this.metadataField.doSwitch(get);
            }
            return metadata.getProperty(this.field);
        }
    }
}

