/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.database.tx.DBService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfoDatabase;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.groupware.infostore.database.impl.GetSwitch;
import com.openexchange.groupware.infostore.database.impl.SetSwitch;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.infostore.utils.MetadataSwitcher;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class InfoDatabaseImpl
extends DBService
implements InfoDatabase {
    private static final Metadata[] INFOSTORE_FIELDS = new Metadata[]{Metadata.ID_LITERAL, Metadata.FOLDER_ID_LITERAL, Metadata.VERSION_LITERAL, Metadata.COLOR_LABEL_LITERAL, Metadata.CREATION_DATE_LITERAL, Metadata.LAST_MODIFIED_LITERAL, Metadata.CREATED_BY_LITERAL, Metadata.MODIFIED_BY_LITERAL, Metadata.LAST_MODIFIED_UTC_LITERAL};
    private static final Set<Metadata> INFOSTORE_FIELDS_SET = Collections.unmodifiableSet(new HashSet<Metadata>(Arrays.asList(INFOSTORE_FIELDS)));
    private static final Metadata[] INFOSTORE_DOCUMENT_FIELDS = new Metadata[]{Metadata.ID_LITERAL, Metadata.VERSION_LITERAL, Metadata.CREATION_DATE_LITERAL, Metadata.LAST_MODIFIED_LITERAL, Metadata.CREATED_BY_LITERAL, Metadata.MODIFIED_BY_LITERAL, Metadata.TITLE_LITERAL, Metadata.URL_LITERAL, Metadata.DESCRIPTION_LITERAL, Metadata.CATEGORIES_LITERAL, Metadata.FILENAME_LITERAL, Metadata.FILE_SIZE_LITERAL, Metadata.FILE_MIMETYPE_LITERAL, Metadata.FILE_MD5SUM_LITERAL, Metadata.VERSION_COMMENT_LITERAL, Metadata.LAST_MODIFIED_UTC_LITERAL};
    private static final Set<Metadata> INFOSTORE_DOCUMENT_FIELDS_SET = Collections.unmodifiableSet(new HashSet<Metadata>(Arrays.asList(INFOSTORE_DOCUMENT_FIELDS)));
    private static final String INSERT_INFOSTORE = InfoDatabaseImpl.buildInsert(Table.INFOSTORE, "ctx");
    private static final String INSERT_INFOSTORE_DOCUMENT = InfoDatabaseImpl.buildInsert(Table.INFOSTORE_DOCUMENT, "ctx");
    private static final String INSERT_INFOSTORE_DOCUMENT_WITH_FILESTORE_LOC = InfoDatabaseImpl.buildInsert(Table.INFOSTORE_DOCUMENT, "ctx", "filestore_location");

    private static String buildInsert(String tablename, Metadata[] metadata, MetadataSwitcher columnNames, String ... additionalFields) {
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ").append(tablename).append(" (");
        StringBuilder questionMarks = new StringBuilder();
        for (Metadata m : metadata) {
            String col = (String)m.doSwitch(columnNames);
            if (col == null) continue;
            builder.append(col);
            builder.append(',');
            questionMarks.append("?,");
        }
        for (String s : additionalFields) {
            builder.append(s);
            builder.append(',');
            questionMarks.append("?,");
        }
        builder.setLength(builder.length() - 1);
        questionMarks.setLength(questionMarks.length() - 1);
        builder.append(") VALUES (").append(questionMarks.toString()).append(')');
        return builder.toString();
    }

    private static String buildInsert(Table t, String ... additionalFields) {
        return InfoDatabaseImpl.buildInsert(t.getTablename(), t.getFields(), t.getFieldSwitcher(), additionalFields);
    }

    private static String buildUpdateWithoutWhere(String tablename, Metadata[] metadata, MetadataSwitcher columnNames, String ... additionalFields) {
        StringBuilder builder = new StringBuilder();
        builder.append("UPDATE ").append(tablename).append(" SET ");
        for (Metadata m : metadata) {
            String col = (String)m.doSwitch(columnNames);
            if (col == null) continue;
            builder.append(col);
            builder.append(" = ?,");
        }
        for (String s : additionalFields) {
            builder.append(s);
            builder.append(" = ?,");
        }
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }

    private static String buildUpdateWithoutWhere(Table t, String ... additionalFields) {
        return InfoDatabaseImpl.buildUpdateWithoutWhere(t.getTablename(), t.getFields(), t.getFieldSwitcher(), additionalFields);
    }

    private static final void fillStatement(PreparedStatement stmt, Metadata[] fields, DocumentMetadata doc, Object ... additional) throws SQLException {
        GetSwitch get = new GetSwitch(doc);
        int i = 1;
        for (Metadata m : fields) {
            stmt.setObject(i++, m.doSwitch(get));
        }
        for (Object o : additional) {
            stmt.setObject(i++, o);
        }
    }

    public InfoDatabaseImpl() {
    }

    public InfoDatabaseImpl(DBProvider provider) {
        super(provider);
    }

    @Override
    public void delete(int[] ids, Context ctx) throws OXException {
        StringBuilder del = new StringBuilder("DELETE FROM infostore WHERE id IN (");
        StringBuilder delVers = new StringBuilder("DELETE FROM infostore_document WHERE infostore_id IN (");
        for (int id : ids) {
            del.append(id).append(',');
            delVers.append(id).append(',');
        }
        del.setLength(del.length() - 1);
        delVers.setLength(delVers.length() - 1);
        del.append(')');
        delVers.append(')');
        this.executeUpdate(del.toString(), new Metadata[0], null, ctx, new Object[0]);
        this.executeUpdate(delVers.toString(), new Metadata[0], null, ctx, new Object[0]);
    }

    @Override
    public void insertDocument(DocumentMetadata document, Context ctx) throws OXException {
        this.executeUpdate(INSERT_INFOSTORE, Table.INFOSTORE.getFields(), document, ctx, ctx.getContextId());
    }

    @Override
    public void insertVersion(DocumentMetadata document, Context ctx) throws OXException {
        this.executeUpdate(INSERT_INFOSTORE_DOCUMENT, Table.INFOSTORE.getFields(), document, ctx, ctx.getContextId());
    }

    @Override
    public void insertVersion(DocumentMetadata document, Context ctx, String filestoreLocation) throws OXException {
        this.executeUpdate(INSERT_INFOSTORE_DOCUMENT_WITH_FILESTORE_LOC, Table.INFOSTORE.getFields(), document, ctx, ctx.getContextId(), filestoreLocation);
    }

    public void updateDocument(DocumentMetadata document, Context ctx) throws OXException {
        StringBuilder update = new StringBuilder(InfoDatabaseImpl.buildUpdateWithoutWhere(Table.INFOSTORE, new String[0]));
        update.append(" WHERE id = ? and cid = ?");
        this.executeUpdate(update.toString(), Table.INFOSTORE.getFields(), document, ctx, document.getId(), ctx.getContextId());
    }

    public void updateVersion(DocumentMetadata document, Context ctx) throws OXException {
        StringBuilder update = new StringBuilder(InfoDatabaseImpl.buildUpdateWithoutWhere(Table.INFOSTORE_DOCUMENT, new String[0]));
        update.append(" WHERE id = ? and cid = ?");
        this.executeUpdate(update.toString(), Table.INFOSTORE_DOCUMENT.getFields(), document, ctx, document.getId(), ctx.getContextId());
    }

    public void updateVersion(DocumentMetadata document, String filestoreLoc, Context ctx) throws OXException {
        StringBuilder update = new StringBuilder(InfoDatabaseImpl.buildUpdateWithoutWhere(Table.INFOSTORE_DOCUMENT, "filestore_location"));
        update.append(" WHERE id = ? and cid = ?");
        this.executeUpdate(update.toString(), Table.INFOSTORE_DOCUMENT.getFields(), document, ctx, filestoreLoc, document.getId(), ctx.getContextId());
    }

    public DocumentMetadata[] findModifiedSince(long mod, Metadata[] fields, Metadata orderBy, boolean asc, Context ctx) throws OXException {
        DocumentWins chooser = new DocumentWins();
        StringBuilder where = new StringBuilder(this.getFieldName(chooser, Metadata.LAST_MODIFIED_LITERAL));
        where.append(" > ?");
        return this.select(fields, where.toString(), orderBy, asc, (FieldChooser)chooser, ctx, mod);
    }

    public DocumentMetadata[] findByFolderId(long folderId, Metadata[] fields, Context ctx) throws OXException {
        return this.findByFolderId(folderId, fields, null, false, ctx);
    }

    public DocumentMetadata[] findByFolderId(long folderId, Metadata[] fields, Metadata orderBy, boolean asc, Context ctx) throws OXException {
        DocumentWins chooser = new DocumentWins();
        StringBuilder where = new StringBuilder(this.getFieldName(chooser, Metadata.FOLDER_ID_LITERAL));
        where.append(" = ?");
        return this.select(fields, where.toString(), orderBy, asc, (FieldChooser)chooser, ctx, folderId);
    }

    private DocumentMetadata[] select(Metadata[] fields, String where, Metadata orderBy, boolean asc, FieldChooser chooser, Context ctx, Object ... queryArgs) throws OXException {
        return this.select(fields, where, this.getFieldName(chooser, orderBy), asc, chooser, ctx, queryArgs);
    }

    private final String getFieldName(FieldChooser chooser, Metadata m) {
        Table t = chooser.choose(m);
        return t.getTablename() + '.' + m.doSwitch(t.getFieldSwitcher());
    }

    private DocumentMetadata[] select(Metadata[] fields, String where, String orderBy, boolean asc, FieldChooser chooser, Context ctx, Object ... queryArgs) throws OXException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        this.appendFields(fields, query, chooser);
        query.append("WHERE ").append(where);
        if (orderBy != null) {
            query.append(" ORDER BY ").append(orderBy);
            if (asc) {
                query.append(" ASC");
            } else {
                query.append(" DESC");
            }
        }
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<DocumentMetadataImpl> results = new ArrayList<DocumentMetadataImpl>();
        try {
            con = this.getReadConnection(ctx);
            stmt = con.prepareStatement(query.toString());
            int i = 1;
            for (Object queryArg : queryArgs) {
                stmt.setObject(i++, queryArg);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                DocumentMetadataImpl m = new DocumentMetadataImpl();
                this.fillDocumentMetadata(rs, m, fields, chooser);
                results.add(m);
            }
        }
        catch (SQLException e) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
            }
            catch (Throwable throwable) {
                this.close(stmt, rs);
                this.releaseReadConnection(ctx, con);
                throw throwable;
            }
        }
        this.close(stmt, rs);
        this.releaseReadConnection(ctx, con);
        return results.toArray(new DocumentMetadata[results.size()]);
    }

    private void fillDocumentMetadata(ResultSet rs, DocumentMetadata m, Metadata[] fields, FieldChooser chooser) throws SQLException {
        SetSwitch set = new SetSwitch(m);
        for (Metadata field : fields) {
            Table t = chooser.choose(field);
            String fieldName = t.getTablename() + '.' + field.doSwitch(t.getFieldSwitcher());
            set.setValue(rs.getObject(fieldName));
        }
    }

    private void appendFields(Metadata[] fields, StringBuilder query, FieldChooser chooser) {
        HashSet<Table> tables = new HashSet<Table>();
        for (Metadata m : fields) {
            Table t = chooser.choose(m);
            tables.add(t);
            query.append(t.getTablename()).append('.').append(m.doSwitch(t.getFieldSwitcher())).append(',');
        }
        query.setLength(query.length() - 1);
        query.append(" FROM ");
        if (tables.size() > 1) {
            query.append(Table.INFOSTORE.getTablename()).append(" JOIN ").append(Table.INFOSTORE_DOCUMENT.getTablename()).append(" ON (").append(Table.INFOSTORE.getTablename()).append('.').append(Metadata.ID_LITERAL.doSwitch(Table.INFOSTORE.getFieldSwitcher())).append(" = ").append(Table.INFOSTORE_DOCUMENT.getTablename()).append('.').append(Metadata.ID_LITERAL.doSwitch(Table.INFOSTORE_DOCUMENT.getFieldSwitcher()));
        } else {
            Table t = (Table)((Object)tables.iterator().next());
            query.append(t.getTablename());
        }
    }

    private final void executeUpdate(String statement, Metadata[] fields, DocumentMetadata document, Context ctx, Object ... additionals) throws OXException {
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getWriteConnection(ctx);
            stmt = con.prepareStatement(statement);
            InfoDatabaseImpl.fillStatement(stmt, fields, document, additionals);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, DBUtils.getStatement(stmt));
            }
            catch (Throwable throwable) {
                this.close(stmt, null);
                this.releaseWriteConnection(ctx, con);
                throw throwable;
            }
        }
        this.close(stmt, null);
        this.releaseWriteConnection(ctx, con);
    }

    static /* synthetic */ Metadata[] access$000() {
        return INFOSTORE_FIELDS;
    }

    static /* synthetic */ Set access$100() {
        return INFOSTORE_FIELDS_SET;
    }

    static /* synthetic */ Metadata[] access$200() {
        return INFOSTORE_DOCUMENT_FIELDS;
    }

    static /* synthetic */ Set access$300() {
        return INFOSTORE_DOCUMENT_FIELDS_SET;
    }

    static class DocumentWins
    implements FieldChooser {
        DocumentWins() {
        }

        @Override
        public Table choose(Metadata m) {
            if (Table.INFOSTORE.getFieldSet().contains(m)) {
                return Table.INFOSTORE;
            }
            return Table.INFOSTORE_DOCUMENT;
        }
    }

    private static class VersionWins
    implements FieldChooser {
        private VersionWins() {
        }

        @Override
        public Table choose(Metadata m) {
            if (Table.INFOSTORE_DOCUMENT.getFieldSet().contains(m)) {
                return Table.INFOSTORE_DOCUMENT;
            }
            return Table.INFOSTORE;
        }
    }

    private static interface FieldChooser {
        public Table choose(Metadata var1);
    }

    static final class InfostoreDocumentColumnsSwitch
    implements MetadataSwitcher {
        InfostoreDocumentColumnsSwitch() {
        }

        @Override
        public Object categories() {
            return "categories";
        }

        @Override
        public Object colorLabel() {
            return null;
        }

        @Override
        public Object content() {
            return null;
        }

        @Override
        public Object createdBy() {
            return "created_by";
        }

        @Override
        public Object creationDate() {
            return "creating_date";
        }

        @Override
        public Object currentVersion() {
            return null;
        }

        @Override
        public Object description() {
            return "description";
        }

        @Override
        public Object fileMD5Sum() {
            return "file_md5sum";
        }

        @Override
        public Object fileMIMEType() {
            return "file_mimetype";
        }

        @Override
        public Object fileName() {
            return "filename";
        }

        @Override
        public Object fileSize() {
            return "file_size";
        }

        @Override
        public Object folderId() {
            return null;
        }

        @Override
        public Object id() {
            return "infostore_id";
        }

        @Override
        public Object lastModified() {
            return "last_modified";
        }

        @Override
        public Object lockedUntil() {
            return null;
        }

        @Override
        public Object modifiedBy() {
            return "changed_by";
        }

        @Override
        public Object sequenceNumber() {
            return null;
        }

        @Override
        public Object title() {
            return "title";
        }

        @Override
        public Object url() {
            return "url";
        }

        @Override
        public Object version() {
            return "version_number";
        }

        @Override
        public Object versionComment() {
            return "file_version_comment";
        }

        @Override
        public Object filestoreLocation() {
            return null;
        }

        @Override
        public Object lastModifiedUTC() {
            return this.lastModified();
        }

        @Override
        public Object numberOfVersions() {
            return null;
        }
    }

    static final class InfostoreColumnsSwitch
    implements MetadataSwitcher {
        InfostoreColumnsSwitch() {
        }

        @Override
        public Object categories() {
            return null;
        }

        @Override
        public Object colorLabel() {
            return "color_label";
        }

        @Override
        public Object content() {
            return null;
        }

        @Override
        public Object createdBy() {
            return "created_by";
        }

        @Override
        public Object creationDate() {
            return "creating_date";
        }

        @Override
        public Object currentVersion() {
            return null;
        }

        @Override
        public Object description() {
            return null;
        }

        @Override
        public Object fileMD5Sum() {
            return null;
        }

        @Override
        public Object fileMIMEType() {
            return null;
        }

        @Override
        public Object fileName() {
            return null;
        }

        @Override
        public Object fileSize() {
            return null;
        }

        @Override
        public Object folderId() {
            return "folder_id";
        }

        @Override
        public Object id() {
            return "id";
        }

        @Override
        public Object lastModified() {
            return "last_modified";
        }

        @Override
        public Object lockedUntil() {
            return null;
        }

        @Override
        public Object modifiedBy() {
            return "changed_by";
        }

        @Override
        public Object sequenceNumber() {
            return null;
        }

        @Override
        public Object title() {
            return null;
        }

        @Override
        public Object url() {
            return null;
        }

        @Override
        public Object version() {
            return "version";
        }

        @Override
        public Object versionComment() {
            return null;
        }

        @Override
        public Object filestoreLocation() {
            return null;
        }

        @Override
        public Object lastModifiedUTC() {
            return this.lastModified();
        }

        @Override
        public Object numberOfVersions() {
            return null;
        }
    }

    private static enum Table {
        INFOSTORE(InfoDatabaseImpl.access$000(), InfoDatabaseImpl.access$100(), "infostore"),
        INFOSTORE_DOCUMENT(InfoDatabaseImpl.access$200(), InfoDatabaseImpl.access$300(), "infostore_document"),
        DEL_INFOSTORE(InfoDatabaseImpl.access$000(), InfoDatabaseImpl.access$100(), "infostore"),
        DEL_INFOSTORE_DOCUMENT(InfoDatabaseImpl.access$200(), InfoDatabaseImpl.access$300(), "infostore_document");

        private String tablename;
        private Set<Metadata> fieldSet;
        private Metadata[] fields;

        private Table(Metadata[] fields, Set<Metadata> fieldSet, String tablename) {
            this.fields = fields;
            this.fieldSet = fieldSet;
            this.tablename = tablename;
        }

        public Metadata[] getFields() {
            return this.fields;
        }

        public Set<Metadata> getFieldSet() {
            return this.fieldSet;
        }

        public String getTablename() {
            return this.tablename;
        }

        public MetadataSwitcher getFieldSwitcher() {
            switch (this) {
                case INFOSTORE: 
                case DEL_INFOSTORE: {
                    return new InfostoreColumnsSwitch();
                }
                case INFOSTORE_DOCUMENT: 
                case DEL_INFOSTORE_DOCUMENT: {
                    return new InfostoreDocumentColumnsSwitch();
                }
            }
            throw new IllegalArgumentException("Will not happen");
        }
    }
}

