/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl;

import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.impl.GetSwitch;
import com.openexchange.groupware.infostore.database.impl.SetSwitch;
import com.openexchange.groupware.infostore.utils.Metadata;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DocumentMetadataImpl
implements DocumentMetadata {
    private static final long serialVersionUID = 954199261404066624L;
    private Date lastModified;
    private Date creationDate;
    private int modifiedBy;
    private long folderId;
    private String name;
    private int version;
    private int relevance;
    private String content;
    private int id = -1;
    private long contentLength;
    private String description;
    private String url;
    private int createdBy;
    private String contentType;
    private String filename;
    private Date lockedUntil;
    private String categories;
    private String md5;
    private String versionComment;
    private boolean currentVersion;
    private int colorLabel;
    private String filespoolPath;
    private int numberOfVersions;
    private Map<String, String> properties = new HashMap<String, String>();
    private static final String DEFAULT_TYPE = "application/octet-stream";

    public DocumentMetadataImpl() {
    }

    public DocumentMetadataImpl(int id) {
        this.id = id;
    }

    public DocumentMetadataImpl(DocumentMetadata dm) {
        SetSwitch setSwitch = new SetSwitch(this);
        GetSwitch getSwitch = new GetSwitch(dm);
        for (Metadata attr : Metadata.VALUES) {
            setSwitch.setValue(attr.doSwitch(getSwitch));
            attr.doSwitch(setSwitch);
        }
    }

    @Override
    public String getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public long getFolderId() {
        return this.folderId;
    }

    @Override
    public Date getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getTitle() {
        return this.name;
    }

    public int getRelevance() {
        return this.relevance;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public int hashCode() {
        return this.getId();
    }

    public boolean equals(Object o) {
        if (o instanceof DocumentMetadata) {
            DocumentMetadata other = (DocumentMetadata)o;
            return this.id == other.getId();
        }
        return false;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public void setFolderId(long folderId) {
        this.folderId = folderId;
    }

    @Override
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    @Override
    public void setTitle(String name) {
        this.name = name;
    }

    @Override
    public void setVersion(int version2) {
        this.version = version2;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public long getFileSize() {
        return this.contentLength;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public void setURL(String url) {
        this.url = url;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public void setFileSize(long contentLength) {
        this.contentLength = contentLength;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getFileMIMEType() {
        if (this.contentType == null) {
            return DEFAULT_TYPE;
        }
        return this.contentType;
    }

    @Override
    public void setFileMIMEType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public int getCreatedBy() {
        return this.createdBy;
    }

    @Override
    public void setCreatedBy(int createdBy) {
        this.createdBy = createdBy;
    }

    @Override
    public String getFileName() {
        return this.filename;
    }

    @Override
    public void setFileName(String filename) {
        this.filename = filename;
    }

    @Override
    public int getModifiedBy() {
        return this.modifiedBy;
    }

    @Override
    public void setModifiedBy(int modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    @Override
    public long getSequenceNumber() {
        if (this.lastModified == null) {
            return 0L;
        }
        return this.lastModified.getTime();
    }

    public void setSequenceNumber(long sequenceNumber) {
    }

    @Override
    public void setCategories(String categories) {
        this.categories = categories;
    }

    @Override
    public String getCategories() {
        return this.categories;
    }

    @Override
    public Date getLockedUntil() {
        return this.lockedUntil;
    }

    @Override
    public void setLockedUntil(Date lockedUntil) {
        this.lockedUntil = lockedUntil;
    }

    @Override
    public void setFileMD5Sum(String sum) {
        this.md5 = sum;
    }

    @Override
    public String getFileMD5Sum() {
        return this.md5;
    }

    protected void setFileSpoolPath(String filespoolPath) {
        this.filespoolPath = filespoolPath;
    }

    protected String getFileSpoolPath() {
        return this.filespoolPath;
    }

    @Override
    public int getColorLabel() {
        return this.colorLabel;
    }

    @Override
    public void setColorLabel(int color) {
        this.colorLabel = color;
    }

    @Override
    public boolean isCurrentVersion() {
        return this.currentVersion;
    }

    @Override
    public void setIsCurrentVersion(boolean bool) {
        this.currentVersion = bool;
    }

    @Override
    public String getVersionComment() {
        return this.versionComment;
    }

    @Override
    public void setVersionComment(String comment) {
        this.versionComment = comment;
    }

    @Override
    public String getFilestoreLocation() {
        return this.getFileSpoolPath();
    }

    @Override
    public void setFilestoreLocation(String string) {
        this.setFileSpoolPath(string);
    }

    @Override
    public int getNumberOfVersions() {
        return this.numberOfVersions;
    }

    @Override
    public void setNumberOfVersions(int numberOfVersions) {
        this.numberOfVersions = numberOfVersions;
    }
}

