/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contexts.impl;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.impl.ContextExtended;
import com.openexchange.groupware.contexts.impl.ContextExtendedFactory;
import com.openexchange.groupware.contexts.impl.ContextReloader;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CachingContextStorage
extends ContextStorage {
    static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(CachingContextStorage.class));
    private static final String REGION_NAME = "Context";
    private final Lock cacheLock = new ReentrantLock();
    private final ContextStorage persistantImpl;
    private boolean started;

    public CachingContextStorage(ContextStorage persistantImpl) {
        this.persistantImpl = persistantImpl;
    }

    @Override
    public int getContextId(String loginInfo) throws OXException {
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null == cacheService) {
            return this.persistantImpl.getContextId(loginInfo);
        }
        Cache cache = cacheService.getCache(REGION_NAME);
        Integer contextId = (Integer)cache.get((Serializable)((Object)loginInfo));
        if (null == contextId) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Cache MISS. Login info: " + loginInfo));
            }
            if (-1 != (contextId = Autoboxing.I((int)this.persistantImpl.getContextId(loginInfo)))) {
                try {
                    cache.put((Serializable)((Object)loginInfo), (Serializable)contextId);
                }
                catch (OXException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Cache HIT. Login info: " + loginInfo));
        }
        return contextId;
    }

    @Override
    public ContextExtended loadContext(int contextId) throws OXException {
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        ContextExtendedFactory factory = new ContextExtendedFactory(contextId);
        if (cacheService == null) {
            return (ContextExtended)factory.load();
        }
        return new ContextReloader(factory, REGION_NAME);
    }

    @Override
    public List<Integer> getAllContextIds() throws OXException {
        return this.persistantImpl.getAllContextIds();
    }

    @Override
    protected void startUp() throws OXException {
        if (this.started) {
            LOG.error((Object)"Duplicate initialization of CachingContextStorage.");
            return;
        }
        this.persistantImpl.startUp();
        this.started = true;
    }

    @Override
    protected void shutDown() throws OXException {
        if (!this.started) {
            LOG.error((Object)"Duplicate shutdown of CachingContextStorage.");
            return;
        }
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (cacheService != null) {
            try {
                cacheService.freeCache(REGION_NAME);
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.persistantImpl.shutDown();
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateContext(int contextId) throws OXException {
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (cacheService == null) {
            return;
        }
        Cache cache = cacheService.getCache(REGION_NAME);
        this.cacheLock.lock();
        try {
            cache.remove((Serializable)Autoboxing.I((int)contextId));
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateLoginInfo(String loginContextInfo) throws OXException {
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null == cacheService) {
            return;
        }
        Cache cache = cacheService.getCache(REGION_NAME);
        this.cacheLock.lock();
        try {
            cache.remove((Serializable)((Object)loginContextInfo));
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    Lock getCacheLock() {
        return this.cacheLock;
    }

    ContextStorage getPersistantImpl() {
        return this.persistantImpl;
    }
}

