/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact.helpers;

import com.openexchange.groupware.container.Contact;
import com.openexchange.java.Autoboxing;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class ContactSimilarity {
    public static final int THRESHHOLD = 9;
    private static final int[] MATCH_COLUMNS = Autoboxing.I2i((Integer[])((Integer[])com.openexchange.tools.arrays.Arrays.remove((Object[])Autoboxing.i2I((int[])Contact.CONTENT_COLUMNS), (Object[])new Integer[]{Autoboxing.I((int)590)})));

    public static boolean areSimilar(Contact original, Contact candidate) {
        return 9 < ContactSimilarity.calculateSimilarityScore(original, candidate);
    }

    public static int calculateSimilarityScore(Contact original, Contact candidate) {
        String displayName;
        int score = 0;
        if ((ContactSimilarity.isset(original.getGivenName()) || ContactSimilarity.isset(candidate.getGivenName())) && ContactSimilarity.eq(original.getGivenName(), candidate.getGivenName())) {
            score += 5;
        }
        if ((ContactSimilarity.isset(original.getSurName()) || ContactSimilarity.isset(candidate.getSurName())) && ContactSimilarity.eq(original.getSurName(), candidate.getSurName())) {
            score += 5;
        }
        if ((ContactSimilarity.isset(original.getDisplayName()) || ContactSimilarity.isset(candidate.getDisplayName())) && ContactSimilarity.compareDisplayNames(original.getDisplayName(), candidate.getDisplayName())) {
            score += 10;
        }
        if (ContactSimilarity.isset(original.getDisplayName()) && ContactSimilarity.isset(candidate.getSurName()) && ContactSimilarity.isset(candidate.getGivenName()) && (displayName = original.getDisplayName()).contains(candidate.getGivenName()) && displayName.contains(candidate.getSurName())) {
            score += 10;
        }
        if (ContactSimilarity.isset(candidate.getDisplayName()) && ContactSimilarity.isset(original.getSurName()) && ContactSimilarity.isset(original.getGivenName()) && (displayName = candidate.getDisplayName()).contains(original.getGivenName()) && displayName.contains(original.getSurName())) {
            score += 10;
        }
        HashSet<String> mails = new HashSet<String>();
        List<String> mails1 = Arrays.asList(original.getEmail1(), original.getEmail2(), original.getEmail3());
        for (String mail : mails1) {
            if (mail == null) continue;
            mails.add(mail);
        }
        List<String> mails2 = Arrays.asList(candidate.getEmail1(), candidate.getEmail2(), candidate.getEmail3());
        for (String mail : mails2) {
            if (mail == null || !mails.contains(mail)) continue;
            score += 10;
        }
        List<String> purged = ContactSimilarity.getPurgedDisplayNameComponents(original.getDisplayName());
        for (String mail : mails2) {
            if (mail == null) continue;
            if (ContactSimilarity.isset(original.getGivenName()) && ContactSimilarity.isset(original.getSurName()) && mail.contains(original.getGivenName().toLowerCase()) && mail.contains(original.getSurName().toLowerCase())) {
                score += 10;
            }
            if (purged.size() < 2) continue;
            int count = 0;
            for (String comp : purged) {
                if (!mail.contains(comp.toLowerCase())) continue;
                ++count;
            }
            if (count != purged.size()) continue;
            score += 10;
        }
        List<String> purged2 = ContactSimilarity.getPurgedDisplayNameComponents(candidate.getDisplayName());
        for (String mail : mails) {
            if (mail == null) continue;
            if (ContactSimilarity.isset(candidate.getGivenName()) && ContactSimilarity.isset(candidate.getSurName()) && mail.contains(candidate.getGivenName().toLowerCase()) && mail.contains(candidate.getSurName().toLowerCase())) {
                score += 10;
            }
            if (purged2.size() < 2) continue;
            int count = 0;
            for (String comp : purged2) {
                if (!mail.contains(comp.toLowerCase())) continue;
                ++count;
            }
            if (count != purged2.size()) continue;
            score += 10;
        }
        if (original.containsBirthday() && candidate.containsBirthday() && ContactSimilarity.eq(original.getBirthday(), candidate.getBirthday())) {
            score += 5;
        }
        if (score < 9 && original.matches(candidate, MATCH_COLUMNS)) {
            score = 10;
        }
        return score;
    }

    public static List<String> getPurgedDisplayNameComponents(String displayName) {
        if (displayName == null) {
            return Collections.emptyList();
        }
        List<String> d1 = Arrays.asList(displayName.split("\\s+"));
        ArrayList<String> p1 = new ArrayList<String>();
        for (String string : d1) {
            String purged = ContactSimilarity.purge(string);
            if (purged == null) continue;
            p1.add(purged);
        }
        return p1;
    }

    public static boolean compareDisplayNames(String displayName, String displayName2) {
        if (ContactSimilarity.eq(displayName, displayName2)) {
            return true;
        }
        if (displayName == null || displayName2 == null) {
            return false;
        }
        List<String> p1 = ContactSimilarity.getPurgedDisplayNameComponents(displayName);
        List<String> p2 = ContactSimilarity.getPurgedDisplayNameComponents(displayName2);
        int count = 0;
        for (String string : p2) {
            if (!p1.contains(string)) continue;
            ++count;
        }
        return count == Math.min(p1.size(), p2.size()) && count >= 2;
    }

    public static String purge(String component) {
        StringBuilder b = new StringBuilder(component.length());
        for (char c : component.toCharArray()) {
            if (!Character.isLetter(c)) continue;
            b.append(c);
        }
        if (b.length() > 2) {
            return b.toString();
        }
        return null;
    }

    public static boolean isset(String s) {
        return s != null && s.length() > 0;
    }

    public static boolean eq(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }
}

