/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact;

import com.openexchange.groupware.contact.ContactInterfaceProvider;
import com.openexchange.groupware.contact.ContactInterfaceProviderRegistration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ContactInterfaceProviderRegistry {
    private static final ContactInterfaceProviderRegistry instance = new ContactInterfaceProviderRegistry();
    private final ConcurrentMap<Key, ContactInterfaceProvider> services = new ConcurrentHashMap<Key, ContactInterfaceProvider>();

    public static ContactInterfaceProviderRegistry getInstance() {
        return instance;
    }

    private ContactInterfaceProviderRegistry() {
    }

    public boolean addService(int folderId, int contextId, ContactInterfaceProvider contactInterface) {
        return null == this.services.putIfAbsent(new Key(folderId, contextId), contactInterface);
    }

    public boolean containsService(int folderId, int contextId) {
        return this.services.containsKey(new Key(folderId, contextId));
    }

    public boolean removeService(int folderId, int contextId, ContactInterfaceProvider contactInterface) {
        return this.services.remove(new Key(folderId, contextId), contactInterface);
    }

    public int getNumberOfServices() {
        return this.services.size();
    }

    public ContactInterfaceProvider getService(int folderId, int contextId) {
        return (ContactInterfaceProvider)this.services.get(new Key(folderId, contextId));
    }

    public List<ContactInterfaceProviderRegistration> getRegistrations(int contextId) {
        Set entrySet = this.services.entrySet();
        LinkedList<ContactInterfaceProviderRegistration> registrations = new LinkedList<ContactInterfaceProviderRegistration>();
        for (Map.Entry entry : entrySet) {
            if (((Key)entry.getKey()).contextId != contextId) continue;
            registrations.add(new ContactInterfaceProviderRegistration(((Key)entry.getKey()).folderId, (ContactInterfaceProvider)entry.getValue()));
        }
        return registrations;
    }

    private static final class Key {
        private final int folderId;
        private final int contextId;
        private final int hash;

        public Key(int folderId, int contextId) {
            this.folderId = folderId;
            this.contextId = contextId;
            int prime = 31;
            int result = 1;
            result = 31 * result + contextId;
            this.hash = result = 31 * result + folderId;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            if (this.contextId != other.contextId) {
                return false;
            }
            return this.folderId == other.folderId;
        }
    }
}

