/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.update;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.groupware.calendar.OXCalendarExceptionCodes;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.server.services.ServerServiceRegistry;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class AlterMailAddressLength
implements UpdateTask {
    private static final String UPDATE_DEL_DATE_RIGHTS = "alter table del_date_rights change column ma ma VARCHAR(286)";
    private static final String UPDATE_PRG_DATE_RIGHTS = "alter table prg_date_rights change column ma ma VARCHAR(286)";

    @Override
    public int addedWithVersion() {
        return 2;
    }

    @Override
    public int getPriority() {
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        block11: {
            Connection writecon = null;
            Statement stmt = null;
            try {
                writecon = Database.get(contextId, true);
                try {
                    stmt = writecon.createStatement();
                }
                catch (SQLException ex) {
                    throw OXCalendarExceptionCodes.UPDATE_EXCEPTION.create(ex.getMessage());
                }
                if (stmt == null) break block11;
                try {
                    stmt.executeUpdate(UPDATE_PRG_DATE_RIGHTS);
                }
                catch (SQLException ex) {
                    throw OXCalendarExceptionCodes.UPDATE_EXCEPTION.create(ex.getMessage());
                }
                try {
                    stmt.executeUpdate(UPDATE_DEL_DATE_RIGHTS);
                }
                catch (SQLException ex) {
                    throw OXCalendarExceptionCodes.UPDATE_EXCEPTION.create(ex.getMessage());
                }
            }
            finally {
                if (stmt != null) {
                    ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class).closeStatement(stmt);
                }
                if (writecon != null) {
                    Database.back(contextId, true, writecon);
                }
            }
        }
    }
}

