/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar;

import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class CalendarFolderObject
implements Serializable {
    private static final Set<Integer> EMPTY = Collections.emptySet();
    private static final long serialVersionUID = -2356348744702379243L;
    private final int uid;
    private final int cid;
    private Set<Integer> privatefolder = EMPTY;
    private Set<Integer> publicfolder = EMPTY;
    private Set<Integer> sharedfolder = EMPTY;
    private final boolean fill_shared;
    private static final transient org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(CalendarFolderObject.class));
    public static final String IDENTIFIER = "CalendarFolderObject@";
    private Set<Integer> publicReadableAllSet = EMPTY;
    private Set<Integer> publicReadableOwnSet = EMPTY;
    private Set<Integer> privateReadableAllSet = EMPTY;
    private Set<Integer> privateReadableOwnSet = EMPTY;
    private Set<Integer> sharedReadableAllSet = EMPTY;
    private Set<Integer> sharedReadableOwnSet = EMPTY;

    public CalendarFolderObject(int uid, int cid, boolean fill_shared) {
        this.uid = uid;
        this.cid = cid;
        this.fill_shared = fill_shared;
    }

    public void addFolder(boolean readall, boolean readown, boolean shared, int folderid, int type) {
        Integer folderID = folderid;
        if (!shared) {
            if (type == 1) {
                if (this.privatefolder == EMPTY) {
                    this.privatefolder = new HashSet<Integer>(4);
                }
                this.privatefolder.add(folderID);
                if (readall) {
                    if (this.privateReadableAllSet == EMPTY) {
                        this.privateReadableAllSet = new HashSet<Integer>(4);
                    }
                    this.privateReadableAllSet.add(folderID);
                } else if (readown) {
                    if (this.privateReadableOwnSet == EMPTY) {
                        this.privateReadableOwnSet = new HashSet<Integer>(4);
                    }
                    this.privateReadableOwnSet.add(folderID);
                }
            } else if (type == 2) {
                if (this.publicfolder == EMPTY) {
                    this.publicfolder = new HashSet<Integer>(4);
                }
                if (readall) {
                    if (this.publicReadableAllSet == EMPTY) {
                        this.publicReadableAllSet = new HashSet<Integer>(4);
                    }
                    this.publicReadableAllSet.add(folderID);
                } else if (readown) {
                    if (this.publicReadableOwnSet == EMPTY) {
                        this.publicReadableOwnSet = new HashSet<Integer>(4);
                    }
                    this.publicReadableOwnSet.add(folderID);
                }
            } else if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Got an unknown folder type :" + type + " for folderid " + folderid));
            }
        } else if (this.fill_shared) {
            if (this.sharedfolder == EMPTY) {
                this.sharedfolder = new HashSet<Integer>(4);
            }
            this.sharedfolder.add(folderID);
            if (readall) {
                if (this.sharedReadableAllSet == EMPTY) {
                    this.sharedReadableAllSet = new HashSet<Integer>(4);
                }
                this.sharedReadableAllSet.add(folderID);
            } else if (readown) {
                if (this.sharedReadableOwnSet == EMPTY) {
                    this.sharedReadableOwnSet = new HashSet<Integer>(4);
                }
                this.sharedReadableOwnSet.add(folderID);
            }
        }
    }

    public final Set<Integer> getPrivateFolders() {
        return this.privatefolder;
    }

    public final Set<Integer> getPublicFolders() {
        return this.publicfolder;
    }

    public final Set<Integer> getSharedFolderList() {
        return this.sharedfolder;
    }

    public final Set<Integer> getPrivateReadableAll() {
        return this.privateReadableAllSet;
    }

    public final Set<Integer> getPrivateReadableOwn() {
        return this.privateReadableOwnSet;
    }

    public final Set<Integer> getPublicReadableAll() {
        return this.publicReadableAllSet;
    }

    public final Set<Integer> getPublicReadableOwn() {
        return this.publicReadableOwnSet;
    }

    public final Set<Integer> getSharedReadableAll() {
        return this.sharedReadableAllSet;
    }

    public final Set<Integer> getSharedReadableOwn() {
        return this.sharedReadableOwnSet;
    }

    public int hashCode() {
        return this.uid ^ this.cid ^ (this.fill_shared ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalendarFolderObject)) {
            return false;
        }
        CalendarFolderObject oo = (CalendarFolderObject)o;
        return this.uid == oo.uid && this.cid == oo.cid && this.fill_shared == oo.fill_shared;
    }

    public String getObjectKey() {
        StringBuilder key = new StringBuilder(IDENTIFIER);
        key.append('.');
        key.append(this.uid);
        key.append('.');
        key.append(this.cid);
        key.append('.');
        key.append(this.fill_shared);
        return key.toString();
    }

    public String getGroupKey() {
        StringBuilder key = new StringBuilder(IDENTIFIER);
        key.append('.');
        key.append(this.cid);
        return key.toString();
    }

    public static final String createGroupKeyFromContextID(int cid) {
        StringBuilder key = new StringBuilder(IDENTIFIER);
        key.append('.');
        key.append(cid);
        return key.toString();
    }

    public boolean canReadAllInPublicFolder(int fid) {
        return this.publicReadableAllSet.contains(fid);
    }

    public boolean canReadOwnInPublicFolder(int fid) {
        return this.publicReadableOwnSet.contains(fid);
    }

    public boolean canReadAllInPrivateFolder(int fid) {
        return this.privateReadableAllSet.contains(fid);
    }

    public boolean canReadOwnInPrivateFolder(int fid) {
        return this.privateReadableOwnSet.contains(fid);
    }

    public boolean canReadAllInSharedFolder(int fid) {
        return this.sharedReadableAllSet.contains(fid);
    }

    public boolean canReadOwnInSharedFolder(int fid) {
        return this.sharedReadableOwnSet.contains(fid);
    }
}

