/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar;

import com.openexchange.config.ConfigurationService;
import com.openexchange.configuration.ConfigurationExceptionCodes;
import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.Initialization;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.conf.AbstractConfig;
import java.io.File;

public class CalendarConfig
extends AbstractConfig
implements Initialization {
    private static final CalendarConfig singleton = new CalendarConfig();
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(CalendarConfig.class));
    private static volatile boolean solo_reminder_trigger_event = true;
    private static volatile boolean check_and_remove_past_reminders = true;
    private static volatile int max_operations_in_recurrence_calculations;
    private static volatile boolean CACHED_ITERATOR_FAST_FETCH;
    private static volatile boolean seriesconflictlimit;
    private static volatile boolean undefinedstatusconflict;
    private static int MAX_PRE_FETCH;

    public static boolean isCACHED_ITERATOR_FAST_FETCH() {
        return CACHED_ITERATOR_FAST_FETCH;
    }

    public static int getMAX_PRE_FETCH() {
        return MAX_PRE_FETCH;
    }

    private CalendarConfig() {
    }

    @Override
    protected String getPropertyFileName() throws OXException {
        String filename;
        File file = ServerServiceRegistry.getInstance().getService(ConfigurationService.class).getFileByName("calendar.properties");
        String string = filename = null == file ? null : file.getPath();
        if (null == filename) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create("calendar.properties");
        }
        return filename;
    }

    public static String getProperty(String key) {
        return singleton.getPropertyInternal(key);
    }

    public static final CalendarConfig getInstance() {
        return singleton;
    }

    public void start() throws OXException {
        if (this.isPropertiesLoadInternal()) {
            LOG.error((Object)"Duplicate initialization of CalendarConfig.");
            return;
        }
        CalendarConfig.reinit();
    }

    public void stop() throws OXException {
        if (!this.isPropertiesLoadInternal()) {
            LOG.error((Object)"Duplicate shutdown of CalendarConfig.");
            return;
        }
        this.clearProperties();
    }

    @Deprecated
    public static void init() throws OXException {
        if (null == singleton) {
            CalendarConfig.reinit();
        }
    }

    public static void reinit() throws OXException {
        String undefined_status_conflict_string;
        String max_operations_in_recurrence_calculations_string;
        String solo_reminder_trigger_event_string;
        String check_and_remove_past_reminders_string;
        String check_max_pre_fetch_size;
        singleton.loadPropertiesInternal();
        String check_cached_iterator_fast_fetch = CalendarConfig.getProperty("CACHED_ITERATOR_FAST_FETCH");
        if (check_cached_iterator_fast_fetch != null && ((check_cached_iterator_fast_fetch = check_cached_iterator_fast_fetch.trim()).equalsIgnoreCase("FALSE") || check_cached_iterator_fast_fetch.equalsIgnoreCase("0"))) {
            CACHED_ITERATOR_FAST_FETCH = false;
        }
        if ((check_max_pre_fetch_size = CalendarConfig.getProperty("MAX_PRE_FETCH")) != null) {
            check_max_pre_fetch_size = check_max_pre_fetch_size.trim();
            try {
                int mfs = Integer.parseInt(check_max_pre_fetch_size);
                if (mfs > 1 && mfs < 1000) {
                    MAX_PRE_FETCH = mfs;
                }
            }
            catch (NumberFormatException nfe) {
                LOG.error((Object)("Unable to parse config parameter MAX_PRE_FETCH: " + check_max_pre_fetch_size));
            }
        }
        if ((check_and_remove_past_reminders_string = CalendarConfig.getProperty("CHECK_AND_REMOVE_PAST_REMINDERS")) != null && (check_and_remove_past_reminders_string = check_and_remove_past_reminders_string.trim()).equalsIgnoreCase("FALSE")) {
            check_and_remove_past_reminders = false;
        }
        if ((solo_reminder_trigger_event_string = CalendarConfig.getProperty("CHECK_AND_AVOID_SOLO_REMINDER_TRIGGER_EVENTS")) != null && (solo_reminder_trigger_event_string = solo_reminder_trigger_event_string.trim()).equalsIgnoreCase("FALSE")) {
            solo_reminder_trigger_event = false;
        }
        if ((max_operations_in_recurrence_calculations_string = CalendarConfig.getProperty("MAX_OPERATIONS_IN_RECURRENCE_CALCULATIONS")) == null) {
            max_operations_in_recurrence_calculations = 49950;
        } else {
            max_operations_in_recurrence_calculations_string = max_operations_in_recurrence_calculations_string.trim();
            try {
                max_operations_in_recurrence_calculations = Integer.parseInt(max_operations_in_recurrence_calculations_string);
            }
            catch (NumberFormatException e) {
                LOG.error((Object)("Unable to parse config parameter MAX_OPERATIONS_IN_RECURRENCE_CALCULATIONS: " + max_operations_in_recurrence_calculations_string));
                max_operations_in_recurrence_calculations = 49950;
            }
        }
        String series_conflict_limit_string = CalendarConfig.getProperty("com.openexchange.calendar.seriesconflictlimit");
        if (series_conflict_limit_string != null && (series_conflict_limit_string = series_conflict_limit_string.trim()).equalsIgnoreCase("FALSE")) {
            seriesconflictlimit = false;
        }
        if ((undefined_status_conflict_string = CalendarConfig.getProperty("com.openexchange.calendar.undefinedstatusconflict")) != null && (undefined_status_conflict_string = undefined_status_conflict_string.trim()).equalsIgnoreCase("FALSE")) {
            undefinedstatusconflict = false;
        }
    }

    public static boolean getCheckAndRemovePastReminders() {
        return check_and_remove_past_reminders;
    }

    public static boolean getSoloReminderTriggerEvent() {
        return solo_reminder_trigger_event;
    }

    public static int getMaxOperationsInRecurrenceCalculations() {
        return max_operations_in_recurrence_calculations;
    }

    public static boolean getSeriesConflictLimit() {
        return seriesconflictlimit;
    }

    public static boolean getUndefinedStatusConflict() {
        return undefinedstatusconflict;
    }

    static void setCheckAndRemovePastReminders(boolean value) {
        check_and_remove_past_reminders = value;
    }

    static void setSoloReminderTriggerEvent(boolean value) {
        solo_reminder_trigger_event = value;
    }

    static void setMaxOperationsInRecurrenceCalculations(int value) {
        max_operations_in_recurrence_calculations = value;
    }

    static void setSeriesConflictLimit(boolean value) {
        seriesconflictlimit = value;
    }

    static void setUndefinedStatusConflict(boolean value) {
        undefinedstatusconflict = value;
    }

    static {
        CACHED_ITERATOR_FAST_FETCH = true;
        seriesconflictlimit = true;
        undefinedstatusconflict = true;
        MAX_PRE_FETCH = 20;
    }
}

