/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach.json.actions;

import com.openexchange.ajax.Attachment;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.conversion.ConversionService;
import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataArguments;
import com.openexchange.conversion.DataSource;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentField;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.json.actions.AbstractAttachmentAction;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.upload.UploadFile;
import com.openexchange.groupware.upload.impl.UploadEvent;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.log.LogFactory;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.POST, name="attach", description="Create an attachment.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="json_[index]", description="The JSON representation of an attachment object as described in Common object data (with only id, created_by and creation_date available) and Attachment object."), @Parameter(name="file_[index]", description="The file metadata as per <input type=file /> upload. Note: The JSON Object and file fields describe the corresponding attachment. For ex.: json_0 contains metadata for file_0, json_1 for file_1 and so on. Indexes start with 0.")}, requestBody="multipart/form-data or multipart/mixed containing the file data of the attached file and the above fields.", responseDescription="HTML page with javascript callback as per introduction. Contains a JSON-Array of ids of the newly created attachments. The order of the ids corresponds to the indexes in the request.")
public final class AttachAction
extends AbstractAttachmentAction {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(AttachAction.class));
    private static final String DATASOURCE = "datasource";
    private static final String IDENTIFIER = "identifier";
    public static final transient AttachmentField[] REQUIRED = Attachment.REQUIRED;

    public AttachAction(ServiceLookup serviceLookup) {
        super(serviceLookup);
    }

    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        try {
            long ts;
            InputStream is;
            String contentTypeS;
            Data data;
            if (requestData.hasUploads()) {
                UploadEvent upload = requestData.getUploadEvent();
                ArrayList<AttachmentMetadata> attachments2 = new ArrayList<AttachmentMetadata>();
                ArrayList<UploadFile> uploadFiles = new ArrayList<UploadFile>();
                long sum = 0L;
                JSONObject json = new JSONObject();
                List<UploadFile> l = upload.getUploadFiles();
                int size = l.size();
                Iterator<UploadFile> iter = l.iterator();
                for (int a = 0; a < size; ++a) {
                    UploadFile uploadFile = iter.next();
                    String fileField = uploadFile.getFieldName();
                    int index = Integer.parseInt(fileField.substring(5));
                    String obj = upload.getFormField("json_" + index);
                    if (obj == null || obj.length() == 0) continue;
                    json.reset();
                    json.parseJSONString(obj);
                    for (AttachmentField required : REQUIRED) {
                        if (json.has(required.getName())) continue;
                        throw AjaxExceptionCodes.MISSING_PARAMETER.create(required.getName());
                    }
                    AttachmentMetadata attachment = PARSER.getAttachmentMetadata(json.toString());
                    this.assureSize(index, attachments2, uploadFiles);
                    attachments2.set(index, attachment);
                    uploadFiles.set(index, uploadFile);
                    this.checkSize(sum += uploadFile.getSize());
                }
                return this.attach(attachments2, uploadFiles, session, session.getContext(), session.getUser(), session.getUserConfiguration());
            }
            JSONObject object = (JSONObject)requestData.getData();
            if (object == null) {
                return new AJAXRequestResult(0, new Date(System.currentTimeMillis()), "int");
            }
            for (AttachmentField required : Attachment.REQUIRED) {
                if (object.has(required.getName())) continue;
                throw AjaxExceptionCodes.MISSING_PARAMETER.create(required.getName());
            }
            if (!object.has(DATASOURCE)) {
                throw AjaxExceptionCodes.MISSING_PARAMETER.create(DATASOURCE);
            }
            AttachmentMetadata attachment = PARSER.getAttachmentMetadata(object.toString());
            ConversionService conversionService = ServerServiceRegistry.getInstance().getService(ConversionService.class);
            if (conversionService == null) {
                throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{ConversionService.class.getName()});
            }
            JSONObject datasourceDef = object.getJSONObject(DATASOURCE);
            String datasourceIdentifier = datasourceDef.getString(IDENTIFIER);
            DataSource source = conversionService.getDataSource(datasourceIdentifier);
            if (source == null) {
                throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(DATASOURCE, datasourceIdentifier);
            }
            List<Class> types = Arrays.asList(source.getTypes());
            HashMap<String, String> arguments = new HashMap<String, String>();
            for (String key : datasourceDef.keySet()) {
                arguments.put(key, datasourceDef.getString(key));
            }
            if (types.contains(InputStream.class)) {
                String name;
                data = source.getData(InputStream.class, new DataArguments(arguments), (Session)session);
                String sizeS = data.getDataProperties().get("com.openexchange.conversion.size");
                contentTypeS = data.getDataProperties().get("com.openexchange.conversion.content-type");
                if (sizeS != null) {
                    attachment.setFilesize(Long.parseLong(sizeS));
                }
                if (contentTypeS != null) {
                    attachment.setFileMIMEType(contentTypeS);
                }
                if ((name = data.getDataProperties().get("com.openexchange.conversion.name")) != null && null == attachment.getFilename()) {
                    attachment.setFilename(name);
                }
                is = (InputStream)data.getData();
            } else if (types.contains(byte[].class)) {
                String name;
                data = source.getData(byte[].class, new DataArguments(arguments), (Session)session);
                byte[] bytes = (byte[])data.getData();
                is = new ByteArrayInputStream(bytes);
                attachment.setFilesize(bytes.length);
                contentTypeS = data.getDataProperties().get("com.openexchange.conversion.content-type");
                if (contentTypeS != null) {
                    attachment.setFileMIMEType(contentTypeS);
                }
                if ((name = data.getDataProperties().get("com.openexchange.conversion.name")) != null && null == attachment.getFilename()) {
                    attachment.setFilename(name);
                }
            } else {
                throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(DATASOURCE, datasourceIdentifier);
            }
            if (attachment.getFilename() == null) {
                attachment.setFilename("unknown" + System.currentTimeMillis());
            }
            attachment.setId(0);
            ATTACHMENT_BASE.startTransaction();
            try {
                ts = ATTACHMENT_BASE.attachToObject(attachment, is, session, session.getContext(), session.getUser(), session.getUserConfiguration());
                ATTACHMENT_BASE.commit();
            }
            catch (OXException x) {
                ATTACHMENT_BASE.rollback();
                throw x;
            }
            finally {
                ATTACHMENT_BASE.finish();
            }
            return new AJAXRequestResult(attachment.getId(), new Date(ts), "int");
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private AJAXRequestResult attach(List<AttachmentMetadata> attachments2, List<UploadFile> uploadFiles, ServerSession session, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        this.initAttachments(attachments2, uploadFiles);
        try {
            ATTACHMENT_BASE.startTransaction();
            Iterator<UploadFile> ufIter = uploadFiles.iterator();
            JSONArray arr = new JSONArray();
            long timestamp = 0L;
            for (AttachmentMetadata attachment : attachments2) {
                UploadFile uploadFile = ufIter.next();
                attachment.setId(0);
                long modified = ATTACHMENT_BASE.attachToObject(attachment, new BufferedInputStream(new FileInputStream(uploadFile.getTmpFile())), session, ctx, user, userConfig);
                if (modified > timestamp) {
                    timestamp = modified;
                }
                arr.put(attachment.getId());
            }
            ATTACHMENT_BASE.commit();
            AJAXRequestResult aJAXRequestResult = new AJAXRequestResult(arr, new Date(timestamp), "json");
            return aJAXRequestResult;
        }
        catch (OXException t) {
            this.rollback();
            throw t;
        }
        catch (IOException e) {
            this.rollback();
            throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
        }
        finally {
            try {
                ATTACHMENT_BASE.finish();
            }
            catch (OXException e) {
                LOG.debug((Object)"", (Throwable)e);
            }
        }
    }

    private void initAttachments(List<AttachmentMetadata> attachments2, List<UploadFile> uploads) {
        ArrayList<AttachmentMetadata> attList = new ArrayList<AttachmentMetadata>(attachments2);
        Iterator<UploadFile> ufIter = new ArrayList<UploadFile>(uploads).iterator();
        int index = 0;
        for (AttachmentMetadata attachment : attList) {
            if (attachment == null) {
                attachments2.remove(index);
                ufIter.next();
                uploads.remove(index);
                continue;
            }
            UploadFile upload = ufIter.next();
            if (upload == null) {
                attachments2.remove(index);
                uploads.remove(index);
                continue;
            }
            if (attachment.getFilename() == null || "".equals(attachment.getFilename())) {
                attachment.setFilename(upload.getPreparedFileName());
            }
            if (attachment.getFilesize() <= 0L) {
                attachment.setFilesize(upload.getSize());
            }
            if (attachment.getFileMIMEType() == null || "".equals(attachment.getFileMIMEType())) {
                attachment.setFileMIMEType(upload.getContentType());
            }
            ++index;
        }
    }

    private void assureSize(int index, List<AttachmentMetadata> attachments2, List<UploadFile> uploadFiles) {
        int i;
        int enlarge = index - (attachments2.size() - 1);
        for (i = 0; i < enlarge; ++i) {
            attachments2.add(null);
        }
        enlarge = index - (uploadFiles.size() - 1);
        for (i = 0; i < enlarge; ++i) {
            uploadFiles.add(null);
        }
    }
}

