/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach.impl;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.attach.AttachmentEvent;
import com.openexchange.groupware.attach.AttachmentListener;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.session.Session;
import com.openexchange.tx.AbstractUndoable;
import com.openexchange.tx.UndoableAction;
import java.io.InputStream;
import java.sql.Connection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AttachmentEventAction
extends AbstractUndoable
implements UndoableAction {
    private List<AttachmentMetadata> attachments;
    private Session session;
    private Context ctx;
    private User user;
    private UserConfiguration userConfig;
    private List<AttachmentListener> listeners;
    private AttachmentBase source;
    private DBProvider provider;
    private long ts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireAttached(List<AttachmentMetadata> attachments2, List<AttachmentMetadata> processed, User user, UserConfiguration userConfig, Session session, Context ctx, DBProvider provider) throws Exception {
        long ts = 0L;
        for (AttachmentMetadata att : attachments2) {
            AttachmentEventImpl event = new AttachmentEventImpl(att, att.getFolderId(), att.getAttachedId(), att.getModuleId(), user, userConfig, session, ctx, provider, this.source);
            try {
                for (AttachmentListener listener : this.listeners) {
                    long mod = listener.attached(event);
                    if (mod <= ts) continue;
                    ts = mod;
                }
            }
            finally {
                event.close();
            }
            processed.add(att);
        }
        this.ts = ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDetached(List<AttachmentMetadata> m, User user, UserConfiguration userConfig, Session session, Context ctx, DBProvider provider) throws Exception {
        HashMap<AttachmentAddress, HashSet<Integer>> collector = new HashMap<AttachmentAddress, HashSet<Integer>>();
        for (AttachmentMetadata attachmentMetadata : m) {
            AttachmentAddress addr = new AttachmentAddress(attachmentMetadata.getModuleId(), attachmentMetadata.getFolderId(), attachmentMetadata.getAttachedId());
            HashSet<Integer> ids = (HashSet<Integer>)collector.get(addr);
            if (ids == null) {
                ids = new HashSet<Integer>();
                collector.put(addr, ids);
            }
            ids.add(attachmentMetadata.getId());
        }
        for (Map.Entry entry : collector.entrySet()) {
            long ts = 0L;
            AttachmentAddress addr = (AttachmentAddress)entry.getKey();
            Set ids = (Set)entry.getValue();
            int[] idsArr = new int[ids.size()];
            int i = 0;
            for (Integer id : ids) {
                idsArr[i++] = id;
            }
            AttachmentEventImpl event = new AttachmentEventImpl(idsArr, addr.folder, addr.attached, addr.module, user, userConfig, session, ctx, provider, this.source);
            try {
                for (AttachmentListener listener : this.listeners) {
                    long mod = listener.detached(event);
                    if (mod <= ts) continue;
                    ts = mod;
                }
            }
            finally {
                event.close();
            }
            this.ts = ts;
        }
    }

    public void setAttachments(List<AttachmentMetadata> attachments2) {
        this.attachments = attachments2;
    }

    public List<AttachmentMetadata> getAttachments() {
        return this.attachments;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public void setContext(Context context) {
        this.ctx = context;
    }

    public Context getContext() {
        return this.ctx;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public User getUser() {
        return this.user;
    }

    public void setUserConfiguration(UserConfiguration userConfig) {
        this.userConfig = userConfig;
    }

    public UserConfiguration getUserConfiguration() {
        return this.userConfig;
    }

    public void setProvider(DBProvider provider) {
        this.provider = provider;
    }

    public DBProvider getProvider() {
        return this.provider;
    }

    public void setAttachmentListeners(List<AttachmentListener> listeners) {
        this.listeners = listeners;
    }

    public void setSource(AttachmentBase attachmentBase) {
        this.source = attachmentBase;
    }

    public long getTimestamp() {
        return this.ts;
    }

    protected static final class AttachmentAddress {
        public int attached;
        public int folder;
        public int module;

        public AttachmentAddress(int module, int folder, int attached) {
            this.module = module;
            this.folder = folder;
            this.attached = attached;
        }

        public int hashCode() {
            return this.module + this.folder + this.attached;
        }

        public boolean equals(Object o) {
            if (o instanceof AttachmentAddress) {
                AttachmentAddress attAddr = (AttachmentAddress)o;
                return this.module == attAddr.module && this.folder == attAddr.folder && this.attached == attAddr.attached;
            }
            return false;
        }
    }

    protected static final class AttachmentEventImpl
    implements AttachmentEvent {
        private AttachmentMetadata attachment;
        private final int folderId;
        private final int attachedId;
        private final int moduleId;
        private final User user;
        private final Session session;
        private final Context ctx;
        private final DBProvider provider;
        private Connection writeCon;
        private final AttachmentBase base;
        private int[] detached = new int[0];
        private final UserConfiguration userConfig;

        public AttachmentEventImpl(AttachmentMetadata m, int folderId, int attachedId, int moduleId, User user, UserConfiguration userConfig, Session session, Context ctx, DBProvider provider, AttachmentBase base) {
            this(folderId, attachedId, moduleId, user, userConfig, session, ctx, provider, base);
            this.attachment = m;
        }

        public void close() {
            if (this.writeCon != null) {
                this.provider.releaseWriteConnection(this.ctx, this.writeCon);
            }
            this.writeCon = null;
        }

        public AttachmentEventImpl(int folderId, int attachedId, int moduleId, User user, UserConfiguration userConfig, Session session, Context ctx, DBProvider provider, AttachmentBase base) {
            this.folderId = folderId;
            this.attachedId = attachedId;
            this.moduleId = moduleId;
            this.user = user;
            this.session = session;
            this.ctx = ctx;
            this.provider = provider;
            this.base = base;
            this.userConfig = userConfig;
        }

        public AttachmentEventImpl(int[] ids, int folderId, int attachedId, int moduleId, User user, UserConfiguration userConfig, Session session, Context ctx, DBProvider provider, AttachmentBase base) {
            this(folderId, attachedId, moduleId, user, userConfig, session, ctx, provider, base);
            this.detached = (int[])ids.clone();
        }

        @Override
        public int[] getDetached() {
            return (int[])this.detached.clone();
        }

        @Override
        public AttachmentMetadata getAttachment() {
            return this.attachment;
        }

        @Override
        public InputStream getAttachedFile() throws OXException {
            if (this.attachment != null) {
                return this.base.getAttachedFile(this.folderId, this.attachedId, this.moduleId, this.attachment.getId(), this.ctx, this.user, this.userConfig);
            }
            return null;
        }

        @Override
        public AttachmentBase getSource() {
            return this.base;
        }

        @Override
        public Connection getWriteConnection() throws OXException {
            if (this.writeCon == null) {
                this.writeCon = this.provider.getWriteConnection(this.ctx);
            }
            return this.writeCon;
        }

        @Override
        public Context getContext() {
            return this.ctx;
        }

        @Override
        public User getUser() {
            return this.user;
        }

        @Override
        public UserConfiguration getUserConfig() {
            return this.userConfig;
        }

        @Override
        public int getFolderId() {
            return this.folderId;
        }

        @Override
        public int getAttachedId() {
            return this.attachedId;
        }

        @Override
        public int getModuleId() {
            return this.moduleId;
        }

        @Override
        public Session getSession() {
            return this.session;
        }
    }
}

