/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal.performers;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderServiceDecorator;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.UserizedFolder;
import com.openexchange.folderstorage.internal.CalculatePermission;
import com.openexchange.folderstorage.internal.performers.AbstractUserizedFolderPerformer;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;

public final class GetPerformer
extends AbstractUserizedFolderPerformer {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(GetPerformer.class));
    private static final boolean DEBUG_ENABLED = LOG.isDebugEnabled();

    public GetPerformer(ServerSession session, FolderServiceDecorator decorator) {
        super(session, decorator);
    }

    public GetPerformer(User user, Context context, FolderServiceDecorator decorator) {
        super(user, context, decorator);
    }

    public GetPerformer(ServerSession session, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(session, decorator, folderStorageDiscoverer);
    }

    public GetPerformer(User user, Context context, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(user, context, decorator, folderStorageDiscoverer);
    }

    public UserizedFolder doGet(String treeId, String folderId) throws OXException {
        FolderStorage folderStorage = this.folderStorageDiscoverer.getFolderStorage(treeId, folderId);
        if (null == folderStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, folderId);
        }
        long start = DEBUG_ENABLED ? System.currentTimeMillis() : 0L;
        ArrayList<FolderStorage> openedStorages = new ArrayList<FolderStorage>(4);
        if (folderStorage.startTransaction(this.storageParameters, false)) {
            openedStorages.add(folderStorage);
        }
        try {
            Folder folder = folderStorage.getFolder(treeId, folderId, this.storageParameters);
            Permission ownPermission = null == this.getSession() ? CalculatePermission.calculate(folder, this.getUser(), this.getContext(), this.getAllowedContentTypes()) : CalculatePermission.calculate(folder, this.getSession(), this.getAllowedContentTypes());
            if (!ownPermission.isVisible()) {
                throw FolderExceptionErrorMessage.FOLDER_NOT_VISIBLE.create(this.getFolderInfo4Error(folder), this.getUserInfo4Error(), this.getContextInfo4Error());
            }
            UserizedFolder userizedFolder = this.getUserizedFolder(folder, ownPermission, treeId, true, true, this.storageParameters, openedStorages);
            if (DEBUG_ENABLED) {
                long duration = System.currentTimeMillis() - start;
                LOG.debug((Object)("Get.doGet() took " + duration + "msec for folder: " + folderId));
            }
            for (FolderStorage fs : openedStorages) {
                fs.commitTransaction(this.storageParameters);
            }
            return userizedFolder;
        }
        catch (OXException e) {
            for (FolderStorage fs : openedStorages) {
                fs.rollback(this.storageParameters);
            }
            throw e;
        }
        catch (Exception e) {
            for (FolderStorage fs : openedStorages) {
                fs.rollback(this.storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }
}

