/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal.performers;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.folderstorage.UserizedFolder;
import com.openexchange.folderstorage.internal.FolderI18nNamesServiceImpl;
import com.openexchange.folderstorage.internal.FolderStorageRegistry;
import com.openexchange.folderstorage.internal.StorageParametersImpl;
import com.openexchange.folderstorage.internal.performers.ListPerformer;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.tools.session.ServerSession;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractPerformer {
    private static final Object PRESENT = new Object();
    protected static final List<ContentType> ALL_ALLOWED = Collections.emptyList();
    protected static final Set<String> KNOWN_TREES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(FolderStorage.REAL_TREE_ID, "1")));
    protected final FolderStorageDiscoverer folderStorageDiscoverer;
    protected final ServerSession session;
    protected final User user;
    protected final Context context;
    protected StorageParameters storageParameters;
    private final Map<OXException, Object> warnings;
    protected boolean check4Duplicates;

    protected AbstractPerformer(ServerSession session) {
        this(session, FolderStorageRegistry.getInstance());
    }

    protected AbstractPerformer(ServerSession session, FolderStorageDiscoverer folderStorageDiscoverer) {
        this.folderStorageDiscoverer = folderStorageDiscoverer;
        this.session = session;
        UserConfiguration userConfiguration = session.getUserConfiguration();
        if (null != userConfiguration) {
            userConfiguration.isMultipleMailAccounts();
        }
        this.user = session.getUser();
        this.context = session.getContext();
        this.storageParameters = new StorageParametersImpl(session);
        this.warnings = new ConcurrentHashMap<OXException, Object>(2);
        this.check4Duplicates = true;
    }

    protected AbstractPerformer(User user, Context context) {
        this(user, context, FolderStorageRegistry.getInstance());
    }

    protected AbstractPerformer(User user, Context context, FolderStorageDiscoverer folderStorageDiscoverer) {
        this.folderStorageDiscoverer = folderStorageDiscoverer;
        this.session = null;
        this.user = user;
        this.context = context;
        this.storageParameters = new StorageParametersImpl(user, context);
        this.warnings = new ConcurrentHashMap<OXException, Object>(2);
        this.check4Duplicates = true;
    }

    public void setCheck4Duplicates(boolean check4Duplicates) {
        this.check4Duplicates = check4Duplicates;
    }

    protected void checkForDuplicate(String name, String treeId, String parentId, Collection<FolderStorage> openedStorages) throws OXException {
        CheckForDuplicateResult result = this.getCheckForDuplicateResult(name, treeId, parentId, openedStorages);
        if (null != result) {
            throw result.error;
        }
    }

    protected CheckForDuplicateResult getCheckForDuplicateResult(String name, String treeId, String parentId, Collection<FolderStorage> openedStorages) throws OXException {
        if (!this.check4Duplicates || null == name) {
            return null;
        }
        Locale locale = this.storageParameters.getUser().getLocale();
        String lcName = name.toLowerCase(locale);
        if (!FolderStorage.REAL_TREE_ID.equals(treeId)) {
            for (UserizedFolder userizedFolder : new ListPerformer(this.session, null, this.folderStorageDiscoverer).doList(treeId, parentId, true, true)) {
                String localizedName = userizedFolder.getLocalizedName(locale);
                if (!localizedName.toLowerCase(locale).equals(lcName)) continue;
                FolderStorage realStorage = this.folderStorageDiscoverer.getFolderStorage(FolderStorage.REAL_TREE_ID, parentId);
                this.checkOpenedStorage(realStorage, openedStorages);
                OXException e = FolderExceptionErrorMessage.EQUAL_NAME.create(name, realStorage.getFolder(FolderStorage.REAL_TREE_ID, parentId, this.storageParameters).getLocalizedName(locale), treeId);
                return new CheckForDuplicateResult(userizedFolder.getID(), e);
            }
        }
        FolderI18nNamesServiceImpl namesService = FolderI18nNamesServiceImpl.getInstance();
        Set<String> i18nNames = namesService.getI18nNamesFor(new int[0]);
        for (String reservedName : i18nNames) {
            if (!reservedName.toLowerCase(locale).equals(lcName)) continue;
            OXException e = FolderExceptionErrorMessage.RESERVED_NAME.create(name);
            return new CheckForDuplicateResult(null, e);
        }
        return null;
    }

    private void checkOpenedStorage(FolderStorage storage, Collection<FolderStorage> openedStorages) throws OXException {
        for (FolderStorage openedStorage : openedStorages) {
            if (!openedStorage.equals(storage)) continue;
            return;
        }
        if (storage.startTransaction(this.storageParameters, true)) {
            openedStorages.add(storage);
        }
    }

    protected String getContextInfo4Error() {
        Context context;
        Context context2 = context = this.context == null ? this.session.getContext() : this.context;
        if (null == context) {
            return "";
        }
        String name = context.getName();
        if (null == name || 0 == name.length()) {
            return String.valueOf(context.getContextId());
        }
        return new StringBuilder(16).append(name).append(" (").append(context.getContextId()).append(')').toString();
    }

    protected String getUserInfo4Error() {
        User user;
        User user2 = user = this.user == null ? this.session.getUser() : this.user;
        if (null == user) {
            return "";
        }
        String name = user.getDisplayName();
        if (null == name || 0 == name.length()) {
            return String.valueOf(user.getId());
        }
        return new StringBuilder(16).append(name).append(" (").append(user.getId()).append(')').toString();
    }

    protected String getFolderInfo4Error(Folder folder) {
        if (null == folder) {
            return "";
        }
        String name = folder.getLocalizedName(this.user == null ? this.session.getUser().getLocale() : this.user.getLocale());
        if (null == name || 0 == name.length()) {
            return folder.getID();
        }
        return new StringBuilder(16).append(name).append(" (").append(folder.getID()).append(')').toString();
    }

    protected void addWarning(OXException warning) {
        warning.addCategory(Category.CATEGORY_WARNING);
        this.warnings.put(warning, PRESENT);
    }

    public int getNumOfWarnings() {
        return this.warnings.size();
    }

    public Set<OXException> getWarnings() {
        return Collections.unmodifiableSet(this.warnings.keySet());
    }

    protected StorageParameters newStorageParameters() {
        if (null == this.session) {
            return new StorageParametersImpl(this.user, this.context);
        }
        return new StorageParametersImpl(this.session);
    }

    protected FolderStorage getOpenedStorage(String id, String treeId, StorageParameters storageParameters, Collection<FolderStorage> openedStorages) throws OXException {
        for (FolderStorage ps : openedStorages) {
            if (!ps.getFolderType().servesFolderId(id)) continue;
            return ps;
        }
        FolderStorage tmp = this.folderStorageDiscoverer.getFolderStorage(treeId, id);
        if (null == tmp) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, id);
        }
        if (tmp.startTransaction(storageParameters, false)) {
            openedStorages.add(tmp);
        }
        return tmp;
    }

    protected void checkOpenedStorage(FolderStorage checkMe, boolean modify, Collection<FolderStorage> openedStorages) throws OXException {
        if (openedStorages.contains(checkMe)) {
            return;
        }
        if (checkMe.startTransaction(this.storageParameters, modify)) {
            openedStorages.add(checkMe);
        }
    }

    public Context getContext() {
        return this.context;
    }

    public int getContextId() {
        return this.context.getContextId();
    }

    public void setStorageParameters(StorageParameters storageParameters) {
        this.storageParameters = storageParameters;
    }

    public StorageParameters getStorageParameters() {
        return this.storageParameters;
    }

    public User getUser() {
        return this.user;
    }

    public int getUserId() {
        return this.user.getId();
    }

    public ServerSession getSession() {
        return this.session;
    }

    public FolderStorageDiscoverer getFolderStorageDiscoverer() {
        return this.folderStorageDiscoverer;
    }

    protected static final class CheckForDuplicateResult {
        protected final OXException error;
        protected final String optFolderId;

        protected CheckForDuplicateResult(String optFolderId, OXException error) {
            this.optFolderId = optFolderId;
            this.error = error;
        }
    }
}

