/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderFilter;
import com.openexchange.folderstorage.FolderResponse;
import com.openexchange.folderstorage.FolderService;
import com.openexchange.folderstorage.FolderServiceDecorator;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.UserizedFolder;
import com.openexchange.folderstorage.internal.ContentTypeRegistry;
import com.openexchange.folderstorage.internal.FolderResponseImpl;
import com.openexchange.folderstorage.internal.FolderStorageRegistry;
import com.openexchange.folderstorage.internal.StorageParametersImpl;
import com.openexchange.folderstorage.internal.performers.AllVisibleFoldersPerformer;
import com.openexchange.folderstorage.internal.performers.ClearPerformer;
import com.openexchange.folderstorage.internal.performers.ConsistencyPerformer;
import com.openexchange.folderstorage.internal.performers.CreatePerformer;
import com.openexchange.folderstorage.internal.performers.DeletePerformer;
import com.openexchange.folderstorage.internal.performers.GetPerformer;
import com.openexchange.folderstorage.internal.performers.ListPerformer;
import com.openexchange.folderstorage.internal.performers.PathPerformer;
import com.openexchange.folderstorage.internal.performers.SubscribePerformer;
import com.openexchange.folderstorage.internal.performers.UnsubscribePerformer;
import com.openexchange.folderstorage.internal.performers.UpdatePerformer;
import com.openexchange.folderstorage.internal.performers.UpdatesPerformer;
import com.openexchange.folderstorage.internal.performers.VisibleFoldersPerformer;
import com.openexchange.folderstorage.type.PrivateType;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class FolderServiceImpl
implements FolderService {
    private static final Set<String> KNOWN_TREES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(FolderStorage.REAL_TREE_ID, "1")));

    @Override
    public void checkConsistency(String treeId, User user, Context context) throws OXException {
        new ConsistencyPerformer(user, context).doConsistencyCheck(treeId);
    }

    @Override
    public void checkConsistency(String treeId, Session session) throws OXException {
        new ConsistencyPerformer(ServerSessionAdapter.valueOf(session)).doConsistencyCheck(treeId);
    }

    @Override
    public void clearFolder(String treeId, String folderId, User user, Context contex) throws OXException {
        new ClearPerformer(user, contex).doClear(treeId, folderId);
    }

    @Override
    public void clearFolder(String treeId, String folderId, Session session) throws OXException {
        new ClearPerformer(ServerSessionAdapter.valueOf(session)).doClear(treeId, folderId);
    }

    @Override
    public FolderResponse<String> createFolder(Folder folder, User user, Context context) throws OXException {
        CreatePerformer createPerformer = new CreatePerformer(user, context);
        return FolderResponseImpl.newFolderResponse(createPerformer.doCreate(folder), createPerformer.getStorageParameters().getWarnings());
    }

    @Override
    public FolderResponse<String> createFolder(Folder folder, Session session) throws OXException {
        CreatePerformer createPerformer = new CreatePerformer(ServerSessionAdapter.valueOf(session));
        return FolderResponseImpl.newFolderResponse(createPerformer.doCreate(folder), createPerformer.getStorageParameters().getWarnings());
    }

    @Override
    public void deleteFolder(String treeId, String folderId, Date timeStamp, User user, Context context) throws OXException {
        new DeletePerformer(user, context).doDelete(treeId, folderId, timeStamp);
    }

    @Override
    public void deleteFolder(String treeId, String folderId, Date timeStamp, Session session) throws OXException {
        new DeletePerformer(ServerSessionAdapter.valueOf(session)).doDelete(treeId, folderId, timeStamp);
    }

    @Override
    public UserizedFolder getDefaultFolder(User user, String treeId, ContentType contentType, User ruser, Context context, FolderServiceDecorator decorator) throws OXException {
        String folderId = FolderStorageRegistry.getInstance().getFolderStorageByContentType(treeId, contentType).getDefaultFolderID(user, treeId, contentType, PrivateType.getInstance(), new StorageParametersImpl(user, context));
        return new GetPerformer(user, context, decorator).doGet(treeId, folderId);
    }

    @Override
    public UserizedFolder getDefaultFolder(User user, String treeId, ContentType contentType, Session session, FolderServiceDecorator decorator) throws OXException {
        ServerSession serverSession = ServerSessionAdapter.valueOf(session);
        String folderId = FolderStorageRegistry.getInstance().getFolderStorageByContentType(treeId, contentType).getDefaultFolderID(serverSession.getUser(), treeId, contentType, PrivateType.getInstance(), new StorageParametersImpl(serverSession));
        return new GetPerformer(serverSession, decorator).doGet(treeId, folderId);
    }

    @Override
    public UserizedFolder getFolder(String treeId, String folderId, User user, Context context, FolderServiceDecorator decorator) throws OXException {
        return new GetPerformer(user, context, decorator).doGet(treeId, folderId);
    }

    @Override
    public UserizedFolder getFolder(String treeId, String folderId, Session session, FolderServiceDecorator decorator) throws OXException {
        return new GetPerformer(ServerSessionAdapter.valueOf(session), decorator).doGet(treeId, folderId);
    }

    @Override
    public FolderResponse<UserizedFolder[]> getAllVisibleFolders(String treeId, FolderFilter filter, User user, Context context, FolderServiceDecorator decorator) throws OXException {
        AllVisibleFoldersPerformer performer = new AllVisibleFoldersPerformer(user, context, decorator);
        return FolderResponseImpl.newFolderResponse(performer.doAllVisibleFolders(treeId, filter), performer.getWarnings());
    }

    @Override
    public FolderResponse<UserizedFolder[]> getAllVisibleFolders(String treeId, FolderFilter filter, Session session, FolderServiceDecorator decorator) throws OXException {
        AllVisibleFoldersPerformer performer = new AllVisibleFoldersPerformer(ServerSessionAdapter.valueOf(session), decorator);
        return FolderResponseImpl.newFolderResponse(performer.doAllVisibleFolders(treeId, filter), performer.getWarnings());
    }

    @Override
    public FolderResponse<UserizedFolder[]> getPath(String treeId, String folderId, User user, Context context, FolderServiceDecorator decorator) throws OXException {
        PathPerformer performer = new PathPerformer(user, context, decorator);
        return FolderResponseImpl.newFolderResponse(performer.doPath(treeId, folderId, true), performer.getWarnings());
    }

    @Override
    public FolderResponse<UserizedFolder[]> getPath(String treeId, String folderId, Session session, FolderServiceDecorator decorator) throws OXException {
        PathPerformer performer = new PathPerformer(ServerSessionAdapter.valueOf(session), decorator);
        return FolderResponseImpl.newFolderResponse(performer.doPath(treeId, folderId, true), performer.getWarnings());
    }

    @Override
    public FolderResponse<UserizedFolder[]> getVisibleFolders(String treeId, ContentType contentType, Type type, boolean all, User user, Context context, FolderServiceDecorator decorator) throws OXException {
        VisibleFoldersPerformer performer = new VisibleFoldersPerformer(user, context, decorator);
        return FolderResponseImpl.newFolderResponse(performer.doVisibleFolders(treeId, contentType, type, all), performer.getWarnings());
    }

    @Override
    public FolderResponse<UserizedFolder[]> getVisibleFolders(String treeId, ContentType contentType, Type type, boolean all, Session session, FolderServiceDecorator decorator) throws OXException {
        VisibleFoldersPerformer performer = new VisibleFoldersPerformer(ServerSessionAdapter.valueOf(session), decorator);
        return FolderResponseImpl.newFolderResponse(performer.doVisibleFolders(treeId, contentType, type, all), performer.getWarnings());
    }

    @Override
    public FolderResponse<UserizedFolder[]> getSubfolders(String treeId, String parentId, boolean all, User user, Context context, FolderServiceDecorator decorator) throws OXException {
        ListPerformer listPerformer = new ListPerformer(user, context, decorator);
        return FolderResponseImpl.newFolderResponse(listPerformer.doList(treeId, parentId, all), listPerformer.getWarnings());
    }

    @Override
    public FolderResponse<UserizedFolder[]> getSubfolders(String treeId, String parentId, boolean all, Session session, FolderServiceDecorator decorator) throws OXException {
        ListPerformer listPerformer = new ListPerformer(ServerSessionAdapter.valueOf(session), decorator);
        return FolderResponseImpl.newFolderResponse(listPerformer.doList(treeId, parentId, all), listPerformer.getWarnings());
    }

    @Override
    public FolderResponse<UserizedFolder[][]> getUpdates(String treeId, Date timeStamp, boolean ignoreDeleted, ContentType[] includeContentTypes, User user, Context context, FolderServiceDecorator decorator) throws OXException {
        UpdatesPerformer performer = new UpdatesPerformer(user, context, decorator);
        return FolderResponseImpl.newFolderResponse(performer.doUpdates(treeId, timeStamp, ignoreDeleted, includeContentTypes), performer.getWarnings());
    }

    @Override
    public FolderResponse<UserizedFolder[][]> getUpdates(String treeId, Date timeStamp, boolean ignoreDeleted, ContentType[] includeContentTypes, Session session, FolderServiceDecorator decorator) throws OXException {
        UpdatesPerformer performer = new UpdatesPerformer(ServerSessionAdapter.valueOf(session), decorator);
        return FolderResponseImpl.newFolderResponse(performer.doUpdates(treeId, timeStamp, ignoreDeleted, includeContentTypes), performer.getWarnings());
    }

    @Override
    public void subscribeFolder(String sourceTreeId, String folderId, String targetTreeId, String optTargetParentId, User user, Context context) throws OXException {
        if (!FolderStorage.REAL_TREE_ID.equals(sourceTreeId)) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create("Subscribe only supported for real tree as source tree.");
        }
        if (KNOWN_TREES.contains(optTargetParentId)) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create("Subscribe not supported for known trees.");
        }
        new SubscribePerformer(user, context).doSubscribe(sourceTreeId, folderId, targetTreeId, optTargetParentId);
    }

    @Override
    public void subscribeFolder(String sourceTreeId, String folderId, String targetTreeId, String optTargetParentId, Session session) throws OXException {
        if (!FolderStorage.REAL_TREE_ID.equals(sourceTreeId)) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create("Subscribe only supported for real tree as source tree.");
        }
        if (KNOWN_TREES.contains(targetTreeId)) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create("Subscribe not supported for known trees.");
        }
        new SubscribePerformer(ServerSessionAdapter.valueOf(session)).doSubscribe(sourceTreeId, folderId, targetTreeId, optTargetParentId);
    }

    @Override
    public void unsubscribeFolder(String treeId, String folderId, User user, Context context) throws OXException {
        if (KNOWN_TREES.contains(treeId)) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create("Unsubscribe not supported for known trees.");
        }
        new UnsubscribePerformer(user, context).doUnsubscribe(treeId, folderId);
    }

    @Override
    public void unsubscribeFolder(String treeId, String folderId, Session session) throws OXException {
        if (KNOWN_TREES.contains(treeId)) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create("Unsubscribe not supported for known trees.");
        }
        new UnsubscribePerformer(ServerSessionAdapter.valueOf(session)).doUnsubscribe(treeId, folderId);
    }

    @Override
    public void updateFolder(Folder folder, Date timeStamp, User user, Context context) throws OXException {
        new UpdatePerformer(user, context).doUpdate(folder, timeStamp);
    }

    @Override
    public void updateFolder(Folder folder, Date timeStamp, Session session) throws OXException {
        new UpdatePerformer(ServerSessionAdapter.valueOf(session)).doUpdate(folder, timeStamp);
    }

    @Override
    public Map<Integer, ContentType> getAvailableContentTypes() {
        return ContentTypeRegistry.getInstance().getAvailableContentTypes();
    }
}

