/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.database;

import com.openexchange.folderstorage.database.DatabaseFolder;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.i18n.LocaleTools;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class LocalizedDatabaseFolder
extends DatabaseFolder {
    private static final long serialVersionUID = 3830248343115931304L;
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(LocalizedDatabaseFolder.class));
    private ConcurrentMap<Locale, Future<String>> localizedNames = new ConcurrentHashMap<Locale, Future<String>>();

    public LocalizedDatabaseFolder(FolderObject folderObject) {
        this(folderObject, true);
    }

    public LocalizedDatabaseFolder(FolderObject folderObject, boolean cacheable) {
        super(folderObject, cacheable);
    }

    @Override
    public Object clone() {
        LocalizedDatabaseFolder clone = (LocalizedDatabaseFolder)super.clone();
        ConcurrentMap<Locale, Future<String>> thisMap = this.localizedNames;
        if (null == this.localizedNames) {
            clone.localizedNames = null;
        } else {
            ConcurrentHashMap<Locale, Future<String>> cloneMap = new ConcurrentHashMap<Locale, Future<String>>(thisMap.size());
            for (Map.Entry entry : thisMap.entrySet()) {
                cloneMap.put((Locale)entry.getKey(), (Future<String>)entry.getValue());
            }
            clone.localizedNames = cloneMap;
        }
        return clone;
    }

    @Override
    public String getLocalizedName(Locale locale) {
        final Locale loc = null == locale ? LocaleTools.DEFAULT_LOCALE : locale;
        Future<String> future = (FutureTask<String>)this.localizedNames.get(loc);
        if (null == future) {
            final String fname = this.getName();
            if (null == fname) {
                return null;
            }
            FutureTask<String> ft = new FutureTask<String>(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return StringHelper.valueOf(loc).getString(fname);
                }
            });
            future = this.localizedNames.putIfAbsent(loc, ft);
            if (null == future) {
                future = ft;
                ft.run();
            }
        }
        try {
            return (String)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            return this.getName();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            LOG.warn((Object)t.getMessage(), t);
            return this.getName();
        }
    }
}

