/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.database;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageAccount;
import com.openexchange.file.storage.FileStorageAccountManager;
import com.openexchange.file.storage.FileStorageAccountManagerLookupService;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.database.DatabaseFolder;
import com.openexchange.folderstorage.database.LocalizedDatabaseFolder;
import com.openexchange.folderstorage.database.getfolder.SystemInfostoreFolder;
import com.openexchange.folderstorage.database.getfolder.SystemPrivateFolder;
import com.openexchange.folderstorage.database.getfolder.SystemPublicFolder;
import com.openexchange.folderstorage.database.getfolder.SystemSharedFolder;
import com.openexchange.folderstorage.type.PrivateType;
import com.openexchange.folderstorage.type.SharedType;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.InfostoreFacades;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.mail.MailSessionParameterNames;
import com.openexchange.preferences.ServerUserSetting;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderIteratorSQL;
import com.openexchange.tools.oxfolder.OXFolderLoader;
import com.openexchange.tools.oxfolder.OXFolderProperties;
import gnu.trove.list.TIntList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntProcedure;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class DatabaseFolderConverter {
    private static final TIntObjectMap<FolderConverter> SYSTEM_CONVERTERS;
    private static final TIntObjectMap<FolderConverter> CONVERTERS;
    private static final String DEFAULT_ID = "0";

    private DatabaseFolderConverter() {
    }

    private static int getContactCollectorFolder(int userId, int contextId, Connection con) throws OXException {
        Integer folderId = ServerUserSetting.getInstance(con).getContactCollectionFolder(contextId, userId);
        return null == folderId ? -1 : folderId;
    }

    private static int getPublishedMailAttachmentsFolder(Session session) {
        if (null == session) {
            return -1;
        }
        Integer i = (Integer)session.getParameter(MailSessionParameterNames.getParamPublishingInfostoreFolderID());
        return null == i ? -1 : i;
    }

    public static FileStorageAccount getDefaultFileStorageAccess(Session session) throws OXException {
        FileStorageAccountManagerLookupService lookupService = ServerServiceRegistry.getInstance().getService(FileStorageAccountManagerLookupService.class);
        if (null == lookupService) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{FileStorageAccountManagerLookupService.class.getName()});
        }
        FileStorageAccountManager defaultAccountManager = lookupService.getAccountManager(DEFAULT_ID, session);
        if (null != defaultAccountManager) {
            return defaultAccountManager.getAccount(DEFAULT_ID, session);
        }
        return null;
    }

    public static DatabaseFolder convert(FolderObject fo, User user, UserConfiguration userConfiguration, Context ctx, Session session, Connection con) throws OXException {
        try {
            DatabaseFolder retval;
            int folderId = fo.getObjectID();
            if (3 == folderId) {
                return SystemSharedFolder.getSystemSharedFolder(fo, user, userConfiguration, ctx, con);
            }
            FolderConverter folderConverter = (FolderConverter)SYSTEM_CONVERTERS.get(folderId);
            if (null != folderConverter) {
                FileStorageAccount defaultAccount;
                DatabaseFolder databaseFolder = folderConverter.convert(fo);
                if (9 == folderId && !InfostoreFacades.isInfoStoreAvailable() && null != (defaultAccount = DatabaseFolderConverter.getDefaultFileStorageAccess(session))) {
                    databaseFolder.setName(defaultAccount.getDisplayName());
                }
                return databaseFolder;
            }
            folderConverter = (FolderConverter)CONVERTERS.get(folderId);
            if (null != folderConverter) {
                retval = folderConverter.convert(fo);
            } else if (fo.isDefaultFolder()) {
                int module = fo.getModule();
                if (module == 1) {
                    retval = new LocalizedDatabaseFolder(fo);
                    retval.setName("Tasks");
                } else if (module == 3) {
                    retval = new LocalizedDatabaseFolder(fo);
                    retval.setName("Contacts");
                } else if (module == 2) {
                    retval = new LocalizedDatabaseFolder(fo);
                    retval.setName("Calendar");
                } else {
                    retval = new DatabaseFolder(fo);
                }
            } else if (folderId == DatabaseFolderConverter.getContactCollectorFolder(user.getId(), ctx.getContextId(), con)) {
                retval = new LocalizedDatabaseFolder(fo);
                retval.setName("Collected addresses");
            } else if (folderId == DatabaseFolderConverter.getPublishedMailAttachmentsFolder(session)) {
                retval = new LocalizedDatabaseFolder(fo);
                retval.setName("E-Mail attachments");
            } else {
                retval = new DatabaseFolder(fo);
            }
            int userId = user.getId();
            int[] groups = user.getGroups();
            int[] modules = userConfiguration.getAccessibleModules();
            if (PrivateType.getInstance().equals(retval.getType()) && userId != retval.getCreatedBy()) {
                retval.setType(SharedType.getInstance());
                retval.setGlobal(false);
                retval.setCacheable(OXFolderProperties.isEnableSharedFolderCaching());
                retval.setDefault(false);
                TIntList visibleSubfolders = OXFolderIteratorSQL.getVisibleSubfolders(folderId, userId, groups, modules, ctx, con);
                if (visibleSubfolders.isEmpty()) {
                    retval.setSubfolderIDs(new String[0]);
                    retval.setSubscribedSubfolders(false);
                } else {
                    String[] tmp = new String[visibleSubfolders.size()];
                    for (int i = 0; i < tmp.length; ++i) {
                        tmp[i] = String.valueOf(visibleSubfolders.get(i));
                    }
                    retval.setSubfolderIDs(tmp);
                    retval.setSubscribedSubfolders(true);
                }
                int parent = fo.getParentFolderID();
                if (1 == parent || !OXFolderIteratorSQL.isVisibleFolder(parent, userId, groups, modules, ctx, con)) {
                    retval.setParentID(new StringBuilder(8).append("u:").append(retval.getCreatedBy()).toString());
                } else {
                    retval.setParentID(String.valueOf(parent));
                }
            } else if (10 == folderId) {
                FileStorageAccount defaultAccount;
                boolean lookupDb = true;
                if (!InfostoreFacades.isInfoStoreAvailable() && null != (defaultAccount = DatabaseFolderConverter.getDefaultFileStorageAccess(session))) {
                    retval.setSubfolderIDs(null);
                    lookupDb = false;
                }
                if (lookupDb) {
                    TIntList subfolders = OXFolderIteratorSQL.getVisibleSubfolders(folderId, userId, groups, modules, ctx, null);
                    if (subfolders.isEmpty()) {
                        retval.setSubfolderIDs(new String[0]);
                        retval.setSubscribedSubfolders(false);
                    } else {
                        int len = subfolders.size();
                        String[] arr = new String[len];
                        for (int i = 0; i < len; ++i) {
                            arr[i] = String.valueOf(subfolders.get(i));
                        }
                        retval.setSubfolderIDs(arr);
                        retval.setSubscribedSubfolders(true);
                    }
                }
                retval.setCacheable(true);
                retval.setGlobal(false);
            } else if (15 == folderId) {
                FileStorageAccount defaultAccount;
                if (!InfostoreFacades.isInfoStoreAvailable() && null != (defaultAccount = DatabaseFolderConverter.getDefaultFileStorageAccess(session))) {
                    retval.setSubfolderIDs(null);
                    retval.setCacheable(true);
                    retval.setGlobal(false);
                }
            } else if (fo.containsSubfolderIds()) {
                List<Integer> subfolderIds = fo.getSubfolderIds();
                if (subfolderIds.isEmpty()) {
                    retval.setSubfolderIDs(new String[0]);
                    retval.setSubscribedSubfolders(false);
                } else {
                    ArrayList<String> tmp = new ArrayList<String>(subfolderIds.size());
                    for (Integer id : subfolderIds) {
                        tmp.add(id.toString());
                    }
                    retval.setSubfolderIDs(tmp.toArray(new String[tmp.size()]));
                    retval.setSubscribedSubfolders(true);
                }
            } else {
                TIntList subfolderIds = OXFolderLoader.getSubfolderInts(folderId, ctx, con);
                if (subfolderIds.isEmpty()) {
                    retval.setSubfolderIDs(new String[0]);
                    retval.setSubscribedSubfolders(false);
                } else {
                    final ArrayList tmp = new ArrayList(subfolderIds.size());
                    subfolderIds.forEach(new TIntProcedure(){

                        public boolean execute(int id) {
                            tmp.add(String.valueOf(id));
                            return true;
                        }
                    });
                    retval.setSubfolderIDs(tmp.toArray(new String[tmp.size()]));
                    retval.setSubscribedSubfolders(true);
                }
            }
            return retval;
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
    }

    static {
        TIntObjectHashMap m = new TIntObjectHashMap(4);
        m.put(2, (Object)new FolderConverter(){

            @Override
            public DatabaseFolder convert(FolderObject fo) throws OXException {
                return SystemPublicFolder.getSystemPublicFolder(fo);
            }
        });
        m.put(9, (Object)new FolderConverter(){

            @Override
            public DatabaseFolder convert(FolderObject fo) throws OXException {
                return SystemInfostoreFolder.getSystemInfostoreFolder(fo);
            }
        });
        m.put(1, (Object)new FolderConverter(){

            @Override
            public DatabaseFolder convert(FolderObject fo) throws OXException {
                return SystemPrivateFolder.getSystemPrivateFolder(fo);
            }
        });
        SYSTEM_CONVERTERS = m;
        m = new TIntObjectHashMap(4);
        m.put(15, (Object)new FolderConverter(){

            @Override
            public DatabaseFolder convert(FolderObject fo) throws OXException {
                LocalizedDatabaseFolder retval = new LocalizedDatabaseFolder(fo);
                retval.setName("Public infostore");
                return retval;
            }
        });
        m.put(10, (Object)new FolderConverter(){

            @Override
            public DatabaseFolder convert(FolderObject fo) throws OXException {
                LocalizedDatabaseFolder retval = new LocalizedDatabaseFolder(fo);
                retval.setName("Userstore");
                return retval;
            }
        });
        m.put(6, (Object)new FolderConverter(){

            @Override
            public DatabaseFolder convert(FolderObject fo) throws OXException {
                LocalizedDatabaseFolder retval = new LocalizedDatabaseFolder(fo);
                retval.setName("Global address book");
                retval.setParentID(FolderStorage.PUBLIC_ID);
                return retval;
            }
        });
        m.put(5, (Object)new FolderConverter(){

            @Override
            public DatabaseFolder convert(FolderObject fo) throws OXException {
                LocalizedDatabaseFolder retval = new LocalizedDatabaseFolder(fo);
                retval.setName("Shared address book");
                retval.setParentID(FolderStorage.PUBLIC_ID);
                return retval;
            }
        });
        CONVERTERS = m;
    }

    private static interface FolderConverter {
        public DatabaseFolder convert(FolderObject var1) throws OXException;
    }
}

