/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.cache.osgi;

import com.openexchange.caching.CacheService;
import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderEventConstants;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.cache.CacheFolderStorage;
import com.openexchange.folderstorage.cache.CacheServiceRegistry;
import com.openexchange.folderstorage.cache.lock.TreeLockManagement;
import com.openexchange.folderstorage.cache.lock.UserLockManagement;
import com.openexchange.folderstorage.cache.memory.FolderMapManagement;
import com.openexchange.folderstorage.cache.osgi.CacheFolderStorageServiceTracker;
import com.openexchange.log.LogFactory;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.osgi.DeferredActivator;
import com.openexchange.osgi.ServiceRegistry;
import com.openexchange.push.PushEventConstants;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondEventConstants;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.threadpool.ThreadPoolService;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class CacheFolderStorageActivator
extends DeferredActivator {
    static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(CacheFolderStorageActivator.class));
    private List<ServiceRegistration<?>> registrations;
    private CacheFolderStorage cacheFolderStorage;
    private List<ServiceTracker<?, ?>> serviceTrackers;
    private static final String DEFAULT = "default";
    private static final Pattern PAT_FIX = Pattern.compile(Pattern.quote("default") + "([0-9]+)" + Pattern.quote("default"));

    protected Class<?>[] getNeededServices() {
        return new Class[]{CacheService.class, ThreadPoolService.class, ConfigurationService.class, SessiondService.class, MailAccountStorageService.class};
    }

    protected void handleAvailability(Class<?> clazz) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Re-available service: " + clazz.getName()));
        }
        CacheServiceRegistry.getServiceRegistry().addService(clazz, this.getService(clazz));
        if (CacheService.class.equals(clazz)) {
            try {
                this.initCacheFolderStorage();
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                this.unregisterCacheFolderStorage();
            }
        }
    }

    protected void handleUnavailability(Class<?> clazz) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("Absent service: " + clazz.getName()));
        }
        if (CacheService.class.equals(clazz)) {
            try {
                this.disposeCacheFolderStorage();
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                this.unregisterCacheFolderStorage();
            }
        }
        CacheServiceRegistry.getServiceRegistry().removeService(clazz);
    }

    protected void startBundle() throws Exception {
        try {
            Class<?>[] classes;
            ServiceRegistry registry = CacheServiceRegistry.getServiceRegistry();
            registry.clearRegistry();
            for (Class<?> classe : classes = this.getNeededServices()) {
                Object service = this.getService(classe);
                if (null == service) continue;
                registry.addService(classe, service);
            }
            this.initCacheFolderStorage();
            this.serviceTrackers = new ArrayList(4);
            this.serviceTrackers.add(new ServiceTracker(this.context, FolderStorage.class, (ServiceTrackerCustomizer)new CacheFolderStorageServiceTracker(this.context)));
            for (ServiceTracker<?, ?> serviceTracker : this.serviceTrackers) {
                serviceTracker.open();
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    protected void stopBundle() throws Exception {
        try {
            if (null != this.serviceTrackers) {
                for (ServiceTracker<?, ?> serviceTracker : this.serviceTrackers) {
                    serviceTracker.close();
                }
                this.serviceTrackers.clear();
                this.serviceTrackers = null;
            }
            this.disposeCacheFolderStorage();
            CacheServiceRegistry.getServiceRegistry().clearRegistry();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void disposeCacheFolderStorage() throws OXException {
        this.unregisterCacheFolderStorage();
        if (null != this.cacheFolderStorage) {
            this.cacheFolderStorage.onCacheAbsent();
            this.cacheFolderStorage = null;
        }
    }

    private void initCacheFolderStorage() throws OXException {
        this.cacheFolderStorage = CacheFolderStorage.getInstance();
        this.cacheFolderStorage.onCacheAvailable();
        Hashtable<String, String> dictionary = new Hashtable<String, String>();
        ((Dictionary)dictionary).put("tree", FolderStorage.ALL_TREE_ID);
        this.registrations = new ArrayList(4);
        this.registrations.add(this.context.registerService(FolderStorage.class, (Object)this.cacheFolderStorage, dictionary));
        final CacheFolderStorage tmp = this.cacheFolderStorage;
        Object eventHandler = new EventHandler(){

            public void handleEvent(Event event) {
                Session session = (Session)event.getProperty("com.openexchange.push.session");
                String folderId = (String)event.getProperty("com.openexchange.push.folder");
                Boolean contentRelated = (Boolean)event.getProperty("com.openexchange.push.content-related");
                try {
                    tmp.removeFromCache(CacheFolderStorageActivator.sanitizeFolderId(folderId), FolderStorage.REAL_TREE_ID, null != contentRelated && contentRelated != false, session);
                }
                catch (OXException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        };
        Hashtable<String, String[]> dict = new Hashtable<String, String[]>(1);
        ((Dictionary)dict).put("event.topics", PushEventConstants.getAllTopics());
        this.registrations.add(this.context.registerService(EventHandler.class, eventHandler, dict));
        eventHandler = new EventHandler(){

            public void handleEvent(Event event) {
                if ("com/openexchange/folderstorage/identifiers".equals(event.getTopic())) {
                    Session session = (Session)event.getProperty("com.openexchange.folderstorage.session");
                    String oldFolder = (String)event.getProperty("com.openexchange.folderstorage.oldIdentifier");
                    tmp.removeSingleFromCache(CacheFolderStorageActivator.sanitizeFolderId(oldFolder), FolderStorage.REAL_TREE_ID, session.getUserId(), session.getContextId(), true, session);
                    return;
                }
                Session session = (Session)event.getProperty("com.openexchange.folderstorage.session");
                Integer contextId = (Integer)event.getProperty("com.openexchange.folderstorage.context");
                Integer userId = (Integer)event.getProperty("com.openexchange.folderstorage.user");
                String folderId = (String)event.getProperty("com.openexchange.folderstorage.folder");
                Boolean contentRelated = (Boolean)event.getProperty("com.openexchange.folderstorage.content-related");
                try {
                    if (null == session) {
                        tmp.removeSingleFromCache(CacheFolderStorageActivator.sanitizeFolderId(folderId), FolderStorage.REAL_TREE_ID, null == userId ? -1 : userId, contextId, true, session);
                    } else {
                        tmp.removeFromCache(CacheFolderStorageActivator.sanitizeFolderId(folderId), FolderStorage.REAL_TREE_ID, null != contentRelated && contentRelated != false, session);
                    }
                }
                catch (OXException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        };
        dict = new Hashtable(1);
        ((Dictionary)dict).put("event.topics", FolderEventConstants.getAllTopics());
        this.registrations.add(this.context.registerService(EventHandler.class, eventHandler, dict));
        eventHandler = new EventHandler(){

            public void handleEvent(Event event) {
                String topic = event.getTopic();
                if ("com/openexchange/sessiond/remove/session".equals(topic)) {
                    this.handleDroppedSession((Session)event.getProperty("com.openexchange.sessiond.session"));
                } else if ("com/openexchange/sessiond/remove/container".equals(topic) || "com/openexchange/sessiond/remove/data".equals(topic)) {
                    Map map = (Map)event.getProperty("com.openexchange.sessiond.container");
                    for (Session session : map.values()) {
                        this.handleDroppedSession(session);
                    }
                }
            }

            private void handleDroppedSession(Session session) {
                if (null == ((SessiondService)CacheFolderStorageActivator.this.getService(SessiondService.class)).getAnyActiveSessionForUser(session.getUserId(), session.getContextId())) {
                    FolderMapManagement.getInstance().dropFor(session);
                    TreeLockManagement.getInstance().dropFor(session);
                    UserLockManagement.getInstance().dropFor(session);
                }
            }
        };
        dict = new Hashtable(1);
        ((Dictionary)dict).put("event.topics", SessiondEventConstants.getAllTopics());
        this.registrations.add(this.context.registerService(EventHandler.class, eventHandler, dict));
    }

    protected static String sanitizeFolderId(String id) {
        String fid = id;
        if (fid.startsWith(DEFAULT)) {
            try {
                Matcher matcher = PAT_FIX.matcher(fid);
                if (matcher.matches()) {
                    fid = DEFAULT + matcher.group(1);
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Couldn't sanitize folder identifier: " + id + ". Returning unchanged."), (Throwable)e);
                return id;
            }
        }
        return fid;
    }

    private void unregisterCacheFolderStorage() {
        if (null != this.registrations) {
            while (!this.registrations.isEmpty()) {
                this.registrations.remove(0).unregister();
            }
            this.registrations = null;
        }
    }
}

