/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.cache.memory;

import com.openexchange.folderstorage.cache.memory.FolderMap;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.session.Session;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public final class FolderMapManagement {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(FolderMapManagement.class));
    private static final FolderMapManagement INSTANCE = new FolderMapManagement();
    private final ConcurrentMap<Key, FolderMap> map = new ConcurrentHashMap<Key, FolderMap>();

    public static FolderMapManagement getInstance() {
        return INSTANCE;
    }

    private FolderMapManagement() {
    }

    public void clear() {
        this.map.clear();
    }

    public void dropFor(Session session) {
        this.map.remove(FolderMapManagement.keyFor(session));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Cleaned user-sensitive folder cache for user " + session.getUserId() + " in context " + session.getContextId()));
        }
    }

    public void dropFor(int userId, int contextId) {
        this.map.remove(FolderMapManagement.keyFor(userId, contextId));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Cleaned user-sensitive folder cache for user " + userId + " in context " + contextId));
        }
    }

    public FolderMap getFor(Session session) {
        FolderMap newFolderMap;
        Key key = FolderMapManagement.keyFor(session);
        FolderMap folderMap = (FolderMap)this.map.get(key);
        if (null == folderMap && null == (folderMap = this.map.putIfAbsent(key, newFolderMap = new FolderMap(1024, 300, TimeUnit.SECONDS, session.getUserId(), session.getContextId())))) {
            folderMap = newFolderMap;
        }
        return folderMap;
    }

    public FolderMap optFor(Session session) {
        return null == session ? null : (FolderMap)this.map.get(FolderMapManagement.keyFor(session));
    }

    public FolderMap optFor(int userId, int contextId) {
        return (FolderMap)this.map.get(FolderMapManagement.keyFor(userId, contextId));
    }

    private static Key keyFor(Session session) {
        return new Key(session.getUserId(), session.getContextId());
    }

    private static Key keyFor(int userId, int contextId) {
        return new Key(userId, contextId);
    }

    private static final class Key {
        private final int cid;
        private final int user;
        private final int hash;

        protected Key(int user, int cid) {
            this.user = user;
            this.cid = cid;
            int prime = 31;
            int result = 1;
            result = 31 * result + cid;
            this.hash = result = 31 * result + user;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            if (this.cid != other.cid) {
                return false;
            }
            return this.user == other.user;
        }
    }
}

