/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.cache.lock;

import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.session.Session;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class TreeLockManagement {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(TreeLockManagement.class));
    private static final TreeLockManagement INSTANCE = new TreeLockManagement();
    private final ConcurrentMap<Key, ConcurrentMap<String, ReadWriteLock>> map = new ConcurrentHashMap<Key, ConcurrentMap<String, ReadWriteLock>>();

    public static TreeLockManagement getInstance() {
        return INSTANCE;
    }

    private TreeLockManagement() {
    }

    public void clear() {
        this.map.clear();
    }

    public void dropFor(Session session) {
        this.map.remove(TreeLockManagement.keyFor(session));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Cleaned folder locks for user " + session.getUserId() + " in context " + session.getContextId()));
        }
    }

    public ReadWriteLock getFor(String treeId, Session session) {
        return this.getFor(treeId, session.getUserId(), session.getContextId());
    }

    public ReadWriteLock getFor(String treeId, int userId, int contextId) {
        ReentrantReadWriteLock nrwl;
        ReadWriteLock readWriteLock;
        ConcurrentHashMap<String, ReentrantReadWriteLock> nlm;
        Key key = TreeLockManagement.keyFor(userId, contextId);
        ConcurrentHashMap<String, ReentrantReadWriteLock> lockMap = (ConcurrentHashMap<String, ReentrantReadWriteLock>)this.map.get(key);
        if (null == lockMap && null == (lockMap = (ConcurrentMap)this.map.putIfAbsent(key, nlm = new ConcurrentHashMap<String, ReentrantReadWriteLock>(4)))) {
            lockMap = nlm;
        }
        if (null == (readWriteLock = (ReadWriteLock)lockMap.get(treeId)) && null == (readWriteLock = (ReadWriteLock)lockMap.putIfAbsent(treeId, nrwl = new ReentrantReadWriteLock()))) {
            readWriteLock = nrwl;
        }
        return readWriteLock;
    }

    public ReadWriteLock optFor(String treeId, Session session) {
        Key key = TreeLockManagement.keyFor(session);
        ConcurrentMap lockMap = (ConcurrentMap)this.map.get(key);
        if (null == lockMap) {
            return null;
        }
        return (ReadWriteLock)lockMap.get(treeId);
    }

    private static Key keyFor(Session session) {
        return new Key(session.getUserId(), session.getContextId());
    }

    private static Key keyFor(int userId, int contextId) {
        return new Key(userId, contextId);
    }

    private static final class Key {
        private final int cid;
        private final int user;
        private final int hash;

        protected Key(int user, int cid) {
            this.user = user;
            this.cid = cid;
            int prime = 31;
            int result = 1;
            result = 31 * result + cid;
            this.hash = result = 31 * result + user;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            if (this.cid != other.cid) {
                return false;
            }
            return this.user == other.user;
        }
    }
}

