/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database.internal;

import com.openexchange.database.internal.ConnectionLifecycle;
import com.openexchange.database.internal.ConnectionPoolMBean;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.pooling.ExhaustedActions;
import com.openexchange.pooling.PoolingException;
import com.openexchange.pooling.ReentrantLockPool;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public class ConnectionPool
extends ReentrantLockPool<Connection>
implements ConnectionPoolMBean {
    static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(ConnectionPool.class));
    public static final long DEFAULT_CHECK_TIME = 120000L;
    private final ConnectionLifecycle lifecycle = (ConnectionLifecycle)this.getLifecycle();
    public static final ReentrantLockPool.Config DEFAULT_CONFIG = new ReentrantLockPool.Config();

    public ConnectionPool(String url, Properties info, ReentrantLockPool.Config config) {
        super(new ConnectionLifecycle(url, info), config);
    }

    public Connection getWithoutTimeout() throws PoolingException {
        try {
            return this.lifecycle.createWithoutTimeout();
        }
        catch (SQLException e) {
            throw new PoolingException("Cannot create pooled object.", e);
        }
    }

    public void backWithoutTimeout(Connection con) {
        this.lifecycle.destroy(con);
    }

    public int getNumBrokenConnections() {
        return this.getNumBroken();
    }

    public int getNumberOfDBConnections() {
        return this.getPoolSize();
    }

    static {
        ConnectionPool.DEFAULT_CONFIG.minIdle = 0;
        ConnectionPool.DEFAULT_CONFIG.maxIdle = -1;
        ConnectionPool.DEFAULT_CONFIG.maxIdleTime = 60000L;
        ConnectionPool.DEFAULT_CONFIG.maxActive = -1;
        ConnectionPool.DEFAULT_CONFIG.maxWait = 10000L;
        ConnectionPool.DEFAULT_CONFIG.maxLifeTime = -1L;
        ConnectionPool.DEFAULT_CONFIG.exhaustedAction = ExhaustedActions.BLOCK;
        ConnectionPool.DEFAULT_CONFIG.testOnActivate = false;
        ConnectionPool.DEFAULT_CONFIG.testOnDeactivate = true;
        ConnectionPool.DEFAULT_CONFIG.testOnIdle = false;
        ConnectionPool.DEFAULT_CONFIG.testThreads = false;
    }
}

