/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.contact.storage;

import com.openexchange.contact.SortOptions;
import com.openexchange.contact.storage.ContactStorage;
import com.openexchange.contact.storage.internal.SearchAdapter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.search.SearchTerm;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public abstract class DefaultContactStorage
implements ContactStorage {
    @Override
    public SearchIterator<Contact> all(Session session, String folderId, ContactField[] fields) throws OXException {
        return this.all(session, folderId, fields, SortOptions.EMPTY);
    }

    @Override
    public SearchIterator<Contact> list(Session session, String folderId, String[] ids, ContactField[] fields) throws OXException {
        return this.list(session, folderId, ids, fields, SortOptions.EMPTY);
    }

    @Override
    public <O> SearchIterator<Contact> search(Session session, SearchTerm<O> term, ContactField[] fields) throws OXException {
        return this.search(session, term, fields, SortOptions.EMPTY);
    }

    @Override
    public SearchIterator<Contact> search(Session session, ContactSearchObject contactSearch, ContactField[] fields) throws OXException {
        return this.search(session, contactSearch, fields, SortOptions.EMPTY);
    }

    @Override
    public SearchIterator<Contact> deleted(Session session, String folderId, Date since, ContactField[] fields) throws OXException {
        return this.deleted(session, folderId, since, fields, SortOptions.EMPTY);
    }

    @Override
    public SearchIterator<Contact> modified(Session session, String folderId, Date since, ContactField[] fields) throws OXException {
        return this.modified(session, folderId, since, fields, SortOptions.EMPTY);
    }

    @Override
    public SearchIterator<Contact> search(Session session, ContactSearchObject contactSearch, ContactField[] fields, SortOptions sortOptions) throws OXException {
        return this.search(session, DefaultContactStorage.getSearchTerm(contactSearch), fields, sortOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Session session, String folderId) throws OXException {
        Date simulatedLastRead = new Date(Long.MAX_VALUE);
        SearchIterator<Contact> searchIterator = null;
        try {
            searchIterator = this.all(session, folderId, new ContactField[]{ContactField.OBJECT_ID});
            if (null != searchIterator) {
                while (searchIterator.hasNext()) {
                    this.delete(session, folderId, String.valueOf(((Contact)searchIterator.next()).getObjectID()), simulatedLastRead);
                }
            }
        }
        finally {
            if (null != searchIterator) {
                try {
                    searchIterator.close();
                }
                catch (OXException e) {}
            }
        }
    }

    protected static ContactField[] allFields() {
        return ContactField.values();
    }

    protected static SearchIterator<Contact> getSearchIterator(Collection<Contact> contacts2) {
        if (null == contacts2) {
            List emptyList = Collections.emptyList();
            return new SearchIteratorAdapter(emptyList.iterator(), 0);
        }
        return new SearchIteratorAdapter(contacts2.iterator(), contacts2.size());
    }

    protected static int parse(String id) throws OXException {
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            throw ContactExceptionCodes.ID_PARSING_FAILED.create(e, id);
        }
    }

    protected static int[] parse(String[] ids) throws OXException {
        try {
            int[] intIDs = new int[ids.length];
            for (int i = 0; i < intIDs.length; ++i) {
                intIDs[i] = Integer.parseInt(ids[i]);
            }
            return intIDs;
        }
        catch (NumberFormatException e) {
            throw ContactExceptionCodes.ID_PARSING_FAILED.create(e, null != ids ? ids.toString() : null);
        }
    }

    protected static SearchTerm<?> getSearchTerm(ContactSearchObject contactSearch) throws OXException {
        return new SearchAdapter(contactSearch).getSearchTerm();
    }
}

