/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.consistency;

import com.openexchange.consistency.ConsistencyExceptionCodes;
import com.openexchange.consistency.ConsistencyMBean;
import com.openexchange.exception.OXException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;

final class MBeanConsistency
implements ConsistencyMBean {
    private final MBeanServerConnection mbsc;
    private final ObjectName name;

    public MBeanConsistency(MBeanServerConnection mbsc, ObjectName name) {
        this.mbsc = mbsc;
        this.name = name;
    }

    @Override
    public List<String> listMissingFilesInContext(int contextId) throws MBeanException {
        try {
            return (List)this.mbsc.invoke(this.name, "listMissingFilesInContext", new Object[]{contextId}, new String[]{"int"});
        }
        catch (InstanceNotFoundException e) {
            this.exception(e);
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (ReflectionException e) {
            this.exception(e);
        }
        catch (IOException e) {
            this.exception(e);
        }
        return null;
    }

    @Override
    public Map<Integer, List<String>> listMissingFilesInFilestore(int filestoreId) throws MBeanException {
        try {
            return (Map)this.mbsc.invoke(this.name, "listMissingFilesInFilestore", new Object[]{filestoreId}, new String[]{"int"});
        }
        catch (InstanceNotFoundException e) {
            this.exception(e);
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (ReflectionException e) {
            this.exception(e);
        }
        catch (IOException e) {
            this.exception(e);
        }
        return null;
    }

    @Override
    public Map<Integer, List<String>> listMissingFilesInDatabase(int databaseId) throws MBeanException {
        try {
            return (Map)this.mbsc.invoke(this.name, "listMissingFilesInDatabase", new Object[]{databaseId}, new String[]{"int"});
        }
        catch (InstanceNotFoundException e) {
            this.exception(e);
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (ReflectionException e) {
            this.exception(e);
        }
        catch (IOException e) {
            this.exception(e);
        }
        return null;
    }

    @Override
    public Map<Integer, List<String>> listAllMissingFiles() throws MBeanException {
        try {
            return (Map)this.mbsc.invoke(this.name, "listAllMissingFiles", new Object[0], new String[0]);
        }
        catch (InstanceNotFoundException e) {
            this.exception(e);
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (ReflectionException e) {
            this.exception(e);
        }
        catch (IOException e) {
            this.exception(e);
        }
        return null;
    }

    @Override
    public List<String> listUnassignedFilesInContext(int contextId) throws MBeanException {
        try {
            return (List)this.mbsc.invoke(this.name, "listUnassignedFilesInContext", new Object[]{contextId}, new String[]{"int"});
        }
        catch (InstanceNotFoundException e) {
            this.exception(e);
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (ReflectionException e) {
            this.exception(e);
        }
        catch (IOException e) {
            this.exception(e);
        }
        return null;
    }

    @Override
    public Map<Integer, List<String>> listUnassignedFilesInFilestore(int filestoreId) throws MBeanException {
        try {
            return (Map)this.mbsc.invoke(this.name, "listUnassignedFilesInFilestore", new Object[]{filestoreId}, new String[]{"int"});
        }
        catch (InstanceNotFoundException e) {
            this.exception(e);
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (ReflectionException e) {
            this.exception(e);
        }
        catch (IOException e) {
            this.exception(e);
        }
        return null;
    }

    @Override
    public Map<Integer, List<String>> listUnassignedFilesInDatabase(int databaseId) throws MBeanException {
        try {
            return (Map)this.mbsc.invoke(this.name, "listUnassignedFilesInDatabase", new Object[]{databaseId}, new String[]{"int"});
        }
        catch (InstanceNotFoundException e) {
            this.exception(e);
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (ReflectionException e) {
            this.exception(e);
        }
        catch (IOException e) {
            this.exception(e);
        }
        return null;
    }

    @Override
    public Map<Integer, List<String>> listAllUnassignedFiles() throws MBeanException {
        try {
            return (Map)this.mbsc.invoke(this.name, "listAllUnassignedFiles", new Object[0], new String[0]);
        }
        catch (InstanceNotFoundException e) {
            this.exception(e);
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (ReflectionException e) {
            this.exception(e);
        }
        catch (IOException e) {
            this.exception(e);
        }
        return null;
    }

    @Override
    public void repairFilesInContext(int contextId, String resolverPolicy) throws MBeanException {
        try {
            this.mbsc.invoke(this.name, "repairFilesInContext", new Object[]{contextId, resolverPolicy}, new String[]{"int", "java.lang.String"});
        }
        catch (InstanceNotFoundException e) {
            this.exception(e);
        }
        catch (MBeanException e) {
            this.exception(e);
        }
        catch (ReflectionException e) {
            this.exception(e);
        }
        catch (IOException e) {
            this.exception(e);
        }
    }

    @Override
    public void repairFilesInFilestore(int filestoreId, String resolverPolicy) throws MBeanException {
        try {
            this.mbsc.invoke(this.name, "repairFilesInFilestore", new Object[]{filestoreId, resolverPolicy}, new String[]{"int", "java.lang.String"});
        }
        catch (InstanceNotFoundException e) {
            this.exception(e);
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (ReflectionException e) {
            this.exception(e);
        }
        catch (IOException e) {
            this.exception(e);
        }
    }

    @Override
    public void repairFilesInDatabase(int databaseId, String resolverPolicy) throws MBeanException {
        try {
            this.mbsc.invoke(this.name, "repairFilesInDatabase", new Object[]{databaseId, resolverPolicy}, new String[]{"int", "java.lang.String"});
        }
        catch (InstanceNotFoundException e) {
            this.exception(e);
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (ReflectionException e) {
            this.exception(e);
        }
        catch (IOException e) {
            this.exception(e);
        }
    }

    @Override
    public void repairAllFiles(String resolverPolicy) throws MBeanException {
        try {
            this.mbsc.invoke(this.name, "repairAllFiles", new Object[]{resolverPolicy}, new String[]{"java.lang.String"});
        }
        catch (InstanceNotFoundException e) {
            this.exception(e);
        }
        catch (MBeanException e) {
            throw e;
        }
        catch (ReflectionException e) {
            this.exception(e);
        }
        catch (IOException e) {
            this.exception(e);
        }
    }

    private void exception(OXException e) throws MBeanException {
        Exception wrapMe = new Exception(e.getMessage());
        throw new MBeanException(wrapMe, e.getMessage());
    }

    private void exception(Exception e) throws MBeanException {
        OXException oxe = ConsistencyExceptionCodes.COMMUNICATION_PROBLEM.create(e, e.getMessage());
        Exception wrapMe = new Exception(oxe.getMessage());
        throw new MBeanException(wrapMe, e.getMessage());
    }
}

