/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.cache.impl;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheKey;
import com.openexchange.caching.CacheService;
import com.openexchange.caching.ElementAttributes;
import com.openexchange.caching.dynamic.OXObjectFactory;
import com.openexchange.caching.dynamic.Refresher;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderProperties;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;

public final class FolderCacheManager {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(FolderCacheManager.class));
    private static volatile FolderCacheManager instance;
    private static final String REGION_NAME = "OXFolderCache";
    private volatile Cache folderCache;
    private final Lock cacheLock = new ReentrantLock(true);

    private FolderCacheManager() throws OXException {
        this.initCache();
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public static boolean isEnabled() {
        return OXFolderProperties.isEnableFolderCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initInstance() throws OXException {
        if (instance != null) return;
        Class<FolderCacheManager> clazz = FolderCacheManager.class;
        synchronized (FolderCacheManager.class) {
            if (instance != null) return;
            instance = new FolderCacheManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FolderCacheManager getInstance() throws OXException {
        if (!OXFolderProperties.isEnableFolderCache()) {
            throw OXFolderExceptionCode.CACHE_NOT_ENABLED.create();
        }
        if (instance != null) return instance;
        Class<FolderCacheManager> clazz = FolderCacheManager.class;
        synchronized (FolderCacheManager.class) {
            if (instance != null) return instance;
            instance = new FolderCacheManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void releaseInstance() {
        if (instance == null) return;
        Class<FolderCacheManager> clazz = FolderCacheManager.class;
        synchronized (FolderCacheManager.class) {
            if (instance == null) return;
            instance = null;
            CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
            if (null == cacheService) return;
            try {
                cacheService.freeCache(REGION_NAME);
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            return;
        }
    }

    public void initCache() throws OXException {
        if (this.folderCache != null) {
            return;
        }
        this.folderCache = ServerServiceRegistry.getInstance().getService(CacheService.class).getCache(REGION_NAME);
    }

    public void releaseCache() throws OXException {
        Cache folderCache = this.folderCache;
        if (folderCache == null) {
            return;
        }
        folderCache.clear();
        this.folderCache = null;
    }

    CacheKey getCacheKey(int cid, int objectId) {
        return this.folderCache.newCacheKey(cid, objectId);
    }

    Lock getCacheLock() {
        return this.cacheLock;
    }

    public FolderObject getFolderObject(int objectId, boolean fromCache, Context ctx, Connection readCon) throws OXException {
        Cache folderCache = this.folderCache;
        if (null == folderCache) {
            throw OXFolderExceptionCode.CACHE_NOT_ENABLED.create("foldercache.properties");
        }
        if (fromCache) {
            if (null != readCon) {
                this.putIfAbsentInternal(new LoadingFolderProvider(objectId, ctx, readCon), ctx, null);
            }
        } else {
            this.putFolderObject(this.loadFolderObjectInternal(objectId, ctx, readCon), ctx, true, null);
        }
        return ((FolderObject)Refresher.refresh((String)REGION_NAME, (Cache)folderCache, (OXObjectFactory)new FolderFactory(ctx, objectId), (boolean)true)).clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FolderObject getFolderObject(int objectId, Context ctx) {
        FolderObject retval;
        Cache folderCache = this.folderCache;
        if (null == folderCache) {
            return null;
        }
        this.cacheLock.lock();
        try {
            Object tmp = folderCache.get((Serializable)this.getCacheKey(ctx.getContextId(), objectId));
            retval = tmp instanceof FolderObject ? (FolderObject)tmp : null;
        }
        finally {
            this.cacheLock.unlock();
        }
        return null == retval ? retval : retval.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FolderObject loadFolderObject(int folderId, Context ctx, Connection readCon) throws OXException {
        CacheKey key = this.getCacheKey(ctx.getContextId(), folderId);
        Cache folderCache = this.folderCache;
        if (folderCache.isReplicated()) {
            this.cacheLock.lock();
            try {
                Object tmp = folderCache.get((Serializable)key);
                if (tmp instanceof FolderObject) {
                    folderCache.remove((Serializable)key);
                    CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
                    if (null != cacheService) {
                        try {
                            Cache globalCache = cacheService.getCache("GlobalFolderCache");
                            CacheKey cacheKey = cacheService.newCacheKey(ctx.getContextId(), new Serializable[]{FolderStorage.REAL_TREE_ID, String.valueOf(key)});
                            globalCache.remove((Serializable)cacheKey);
                        }
                        catch (OXException e) {
                            LOG.warn((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
            finally {
                this.cacheLock.unlock();
            }
        }
        if (null != readCon) {
            this.putIfAbsent(this.loadFolderObjectInternal(folderId, ctx, readCon), ctx, null);
        }
        return ((FolderObject)Refresher.refresh((String)REGION_NAME, (Cache)folderCache, (OXObjectFactory)new FolderFactory(ctx, folderId), (boolean)true)).clone();
    }

    FolderObject loadFolderObjectInternal(int folderId, Context ctx, Connection readCon) throws OXException {
        if (folderId <= 0) {
            throw OXFolderExceptionCode.NOT_EXISTS.create(folderId, ctx.getContextId());
        }
        return FolderObject.loadFolderObjectFromDB(folderId, ctx, readCon);
    }

    public FolderObject putIfAbsent(FolderObject folderObj, Context ctx, ElementAttributes elemAttribs) throws OXException {
        if (null == this.folderCache) {
            throw OXFolderExceptionCode.CACHE_NOT_ENABLED.create();
        }
        if (!folderObj.containsObjectID()) {
            throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("id", Autoboxing.I((int)-1), Autoboxing.I((int)ctx.getContextId()));
        }
        return this.putIfAbsentInternal(new InstanceFolderProvider(folderObj.clone()), ctx, elemAttribs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FolderObject putIfAbsentInternal(FolderProvider folderProvider, Context ctx, ElementAttributes elemAttribs) throws OXException {
        FolderObject retval;
        block12: {
            CacheKey key = this.getCacheKey(ctx.getContextId(), folderProvider.getObjectID());
            this.cacheLock.lock();
            try {
                Cache folderCache = this.folderCache;
                Object tmp = folderCache.get((Serializable)key);
                if (tmp instanceof FolderObject) {
                    retval = (FolderObject)tmp;
                    break block12;
                }
                Condition cond = null;
                if (tmp instanceof Condition) {
                    cond = (Condition)tmp;
                } else {
                    folderCache.remove((Serializable)key);
                    CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
                    if (null != cacheService) {
                        try {
                            Cache globalCache = cacheService.getCache("GlobalFolderCache");
                            CacheKey cacheKey = cacheService.newCacheKey(ctx.getContextId(), new Serializable[]{FolderStorage.REAL_TREE_ID, String.valueOf(key)});
                            globalCache.remove((Serializable)cacheKey);
                        }
                        catch (OXException e) {
                            LOG.warn((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
                if (elemAttribs == null || folderCache.isDistributed()) {
                    folderCache.put((Serializable)key, (Serializable)folderProvider.getFolderObject());
                } else {
                    folderCache.put((Serializable)key, (Serializable)folderProvider.getFolderObject(), elemAttribs);
                }
                if (null != cond) {
                    cond.signalAll();
                }
                retval = null;
            }
            finally {
                this.cacheLock.unlock();
            }
        }
        return null == retval ? retval : retval.clone();
    }

    public void putFolderObject(FolderObject folderObj, Context ctx) throws OXException {
        this.putFolderObject(folderObj, ctx, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFolderObject(FolderObject folderObj, Context ctx, boolean overwrite, ElementAttributes elemAttribs) throws OXException {
        Cache folderCache = this.folderCache;
        if (null == folderCache) {
            return;
        }
        if (!folderObj.containsObjectID()) {
            throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create("id", Autoboxing.I((int)-1), Autoboxing.I((int)ctx.getContextId()));
        }
        if (null != elemAttribs) {
            elemAttribs.setIsLateral(false);
        }
        FolderObject clone = folderObj.clone();
        CacheKey key = this.getCacheKey(ctx.getContextId(), folderObj.getObjectID());
        this.cacheLock.lock();
        try {
            Object tmp = folderCache.get((Serializable)key);
            Condition cond = null;
            if (overwrite) {
                if (tmp instanceof FolderObject) {
                    folderCache.remove((Serializable)key);
                    CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
                    if (null != cacheService) {
                        try {
                            Cache globalCache = cacheService.getCache("GlobalFolderCache");
                            CacheKey cacheKey = cacheService.newCacheKey(ctx.getContextId(), new Serializable[]{FolderStorage.REAL_TREE_ID, String.valueOf(key)});
                            globalCache.remove((Serializable)cacheKey);
                        }
                        catch (OXException e) {
                            LOG.warn((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                } else if (tmp instanceof Condition) {
                    cond = (Condition)tmp;
                }
            } else {
                if (tmp instanceof FolderObject) {
                    return;
                }
                if (tmp instanceof Condition) {
                    cond = (Condition)tmp;
                }
            }
            if (elemAttribs == null || folderCache.isDistributed()) {
                folderCache.put((Serializable)key, (Serializable)clone);
            } else {
                folderCache.put((Serializable)key, (Serializable)clone, elemAttribs);
            }
            if (null != cond) {
                cond.signalAll();
            }
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFolderObject(int key, Context ctx) throws OXException {
        CacheService cacheService;
        Cache folderCache = this.folderCache;
        if (null == folderCache) {
            return;
        }
        if (key > 0) {
            CacheKey cacheKey = this.getCacheKey(ctx.getContextId(), key);
            this.cacheLock.lock();
            try {
                Object tmp = folderCache.get((Serializable)cacheKey);
                if (!(tmp instanceof Condition)) {
                    folderCache.remove((Serializable)cacheKey);
                }
            }
            finally {
                this.cacheLock.unlock();
            }
        }
        if (null != (cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class))) {
            try {
                Cache globalCache = cacheService.getCache("GlobalFolderCache");
                CacheKey cacheKey = cacheService.newCacheKey(ctx.getContextId(), new Serializable[]{FolderStorage.REAL_TREE_ID, String.valueOf(key)});
                globalCache.remove((Serializable)cacheKey);
            }
            catch (OXException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFolderObjects(int[] keys, Context ctx) throws OXException {
        Cache folderCache = this.folderCache;
        if (null == folderCache) {
            return;
        }
        if (keys == null || keys.length == 0) {
            return;
        }
        ArrayList<CacheKey> cacheKeys = new ArrayList<CacheKey>();
        for (int key : keys) {
            if (key <= 0) continue;
            cacheKeys.add(this.getCacheKey(ctx.getContextId(), key));
        }
        this.cacheLock.lock();
        try {
            for (CacheKey cacheKey : cacheKeys) {
                Object tmp = folderCache.get((Serializable)cacheKey);
                if (tmp instanceof Condition) continue;
                folderCache.remove((Serializable)cacheKey);
            }
        }
        finally {
            this.cacheLock.unlock();
        }
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null != cacheService) {
            try {
                Cache globalCache = cacheService.getCache("GlobalFolderCache");
                for (int key : keys) {
                    CacheKey cacheKey = cacheService.newCacheKey(ctx.getContextId(), new Serializable[]{FolderStorage.REAL_TREE_ID, String.valueOf(key)});
                    globalCache.remove((Serializable)cacheKey);
                }
            }
            catch (OXException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void clearAll() throws OXException {
        Cache folderCache = this.folderCache;
        if (null == folderCache) {
            return;
        }
        folderCache.clear();
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null != cacheService) {
            try {
                Cache globalCache = cacheService.getCache("GlobalFolderCache");
                globalCache.clear();
            }
            catch (OXException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public ElementAttributes getDefaultFolderObjectAttributes() throws OXException {
        Cache folderCache = this.folderCache;
        if (null == folderCache) {
            return null;
        }
        return folderCache.getDefaultElementAttributes();
    }

    private static final class LoadingFolderProvider
    implements FolderProvider {
        private final Connection readCon;
        private final int folderId;
        private final Context ctx;

        public LoadingFolderProvider(int folderId, Context ctx, Connection readCon) {
            this.folderId = folderId;
            this.ctx = ctx;
            this.readCon = readCon;
        }

        @Override
        public FolderObject getFolderObject() throws OXException {
            if (this.folderId <= 0) {
                throw OXFolderExceptionCode.NOT_EXISTS.create(Autoboxing.I((int)this.folderId), Autoboxing.I((int)this.ctx.getContextId()));
            }
            return FolderObject.loadFolderObjectFromDB(this.folderId, this.ctx, this.readCon);
        }

        @Override
        public int getObjectID() {
            return this.folderId;
        }
    }

    private static final class InstanceFolderProvider
    implements FolderProvider {
        private final FolderObject folderObject;

        public InstanceFolderProvider(FolderObject folderObject) {
            this.folderObject = folderObject;
        }

        @Override
        public FolderObject getFolderObject() {
            return this.folderObject;
        }

        @Override
        public int getObjectID() {
            return this.folderObject.getObjectID();
        }
    }

    private static interface FolderProvider {
        public FolderObject getFolderObject() throws OXException;

        public int getObjectID();
    }

    private class FolderFactory
    implements OXObjectFactory<FolderObject> {
        private static final long serialVersionUID = -4809018496183864081L;
        private final Context ctx;
        private final int folderId;

        FolderFactory(Context ctx, int folderId) {
            this.ctx = ctx;
            this.folderId = folderId;
        }

        public Lock getCacheLock() {
            return FolderCacheManager.this.getCacheLock();
        }

        public Serializable getKey() {
            return FolderCacheManager.this.getCacheKey(this.ctx.getContextId(), this.folderId);
        }

        public FolderObject load() throws OXException {
            return FolderCacheManager.this.loadFolderObjectInternal(this.folderId, this.ctx, null);
        }
    }
}

