/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.writer;

import com.openexchange.ajax.writer.DataWriter;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.data.conversion.ical.ConversionWarning;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.importexport.ImportResult;
import com.openexchange.json.OXJSONWriter;
import com.openexchange.tools.session.ServerSession;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class ImportExportWriter
extends DataWriter {
    private final ServerSession session;

    public ImportExportWriter(ServerSession session) {
        this(new OXJSONWriter(), session);
    }

    public ImportExportWriter(OXJSONWriter jsonwriter, ServerSession session) {
        super(null, jsonwriter);
        this.session = session;
    }

    public void writeObject(ImportResult importResult) throws JSONException {
        if (importResult.hasError()) {
            OXException exception = importResult.getException();
            JSONObject jsonObject = new JSONObject();
            ResponseWriter.addException(jsonObject, exception, null != this.session ? this.session.getUser().getLocale() : null);
            this.jsonwriter.object();
            this.writeDepth1(jsonObject);
            List<ConversionWarning> warnings = importResult.getWarnings();
            if (warnings != null && warnings.size() > 0) {
                this.jsonwriter.key("warnings");
                this.jsonwriter.array();
                for (ConversionWarning warning : warnings) {
                    this.jsonwriter.object();
                    JSONObject jsonWarning = new JSONObject();
                    ResponseWriter.addWarning(jsonWarning, warning, null != this.session ? this.session.getUser().getLocale() : null);
                    this.writeDepth1(jsonWarning);
                    this.jsonwriter.endObject();
                }
                this.jsonwriter.endArray();
                this.writeParameter("id", importResult.getObjectId());
                this.writeParameter("last_modified", importResult.getDate());
                this.writeParameter("folder_id", importResult.getFolder());
            }
            this.jsonwriter.endObject();
        } else {
            this.jsonwriter.object();
            this.writeParameter("id", importResult.getObjectId());
            this.writeParameter("last_modified", importResult.getDate());
            this.writeParameter("folder_id", importResult.getFolder());
            this.jsonwriter.endObject();
        }
    }

    private void writeDepth1(JSONObject json) throws JSONException {
        Set entrySet = json.entrySet();
        int len = entrySet.size();
        Iterator iter = entrySet.iterator();
        for (int i = 0; i < len; ++i) {
            Map.Entry e = (Map.Entry)iter.next();
            this.jsonwriter.key((String)e.getKey()).value(e.getValue());
        }
    }

    public String toString() {
        return this.getObject().toString();
    }

    public Object getObject() {
        return ((OXJSONWriter)this.jsonwriter).getObject();
    }

    public void writeObjects(List<ImportResult> importResult) throws JSONException {
        this.jsonwriter.array();
        for (int a = 0; a < importResult.size(); ++a) {
            this.writeObject(importResult.get(a));
        }
        this.jsonwriter.endArray();
    }
}

