/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.responseRenderers;

import com.openexchange.ajax.container.FileHolder;
import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.ajax.helper.DownloadUtility;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.ResponseRenderer;
import com.openexchange.exception.Log;
import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.images.ImageScalingService;
import com.openexchange.tools.images.ScaleType;
import com.openexchange.tools.servlet.http.Tools;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.activation.FileTypeMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FileResponseRenderer
implements ResponseRenderer {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(FileResponseRenderer.class));
    private static final int BUFLEN = 2048;
    private static final String PARAMETER_CONTENT_DISPOSITION = "content_disposition";
    private static final String PARAMETER_CONTENT_TYPE = "content_type";
    protected static final String SAVE_AS_TYPE = "application/octet-stream";
    private volatile ImageScalingService scaler;
    private final String DELIVERY = "delivery";
    private final String DOWNLOAD = "download";
    private final String VIEW = "view";

    @Override
    public int getRanking() {
        return 0;
    }

    public void setScaler(ImageScalingService scaler) {
        this.scaler = scaler;
    }

    @Override
    public boolean handles(AJAXRequestData request, AJAXRequestResult result) {
        return result.getResultObject() instanceof IFileHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(AJAXRequestData request, AJAXRequestResult result, HttpServletRequest req, HttpServletResponse resp) {
        String contentDisposition;
        String delivery;
        IFileHolder file = (IFileHolder)result.getResultObject();
        String fileContentType = file.getContentType();
        String fileName = file.getName();
        String contentType = req.getParameter(PARAMETER_CONTENT_TYPE);
        if (null == contentType) {
            contentType = fileContentType;
        }
        if ((delivery = req.getParameter("delivery")) == null) {
            delivery = file.getDelivery();
        }
        if (null == (contentDisposition = req.getParameter(PARAMETER_CONTENT_DISPOSITION))) {
            contentDisposition = file.getDisposition();
        }
        InputStream documentData = null;
        try {
            int read;
            file = this.rotateIfImage(file);
            file = this.cropIfImage(request, file);
            file = this.scaleIfImage(request, file);
            InputStream stream = file.getStream();
            if (null == stream) {
                resp.sendError(404, "Image not found.");
                Streams.close((Closeable)file);
                Streams.close((Closeable)documentData);
                return;
            }
            documentData = new BufferedInputStream(stream);
            String userAgent = req.getHeader("user-agent");
            if (SAVE_AS_TYPE.equals(contentType) || delivery != null && delivery.equalsIgnoreCase("download")) {
                if (null == contentDisposition) {
                    StringBuilder sb = new StringBuilder(32).append("attachment");
                    DownloadUtility.appendFilenameParameter(fileName, SAVE_AS_TYPE, userAgent, sb);
                    resp.setHeader("Content-Disposition", sb.toString());
                } else {
                    Tools.setHeaderForFileDownload(userAgent, resp, fileName, contentDisposition);
                }
                resp.setContentType(contentType);
            } else {
                DownloadUtility.CheckedDownload checkedDownload = DownloadUtility.checkInlineDownload(documentData, fileName, fileContentType, contentDisposition, userAgent);
                if (delivery == null || !delivery.equalsIgnoreCase("view")) {
                    if (contentDisposition == null) {
                        resp.setHeader("Content-Disposition", checkedDownload.getContentDisposition());
                    } else if (contentDisposition.indexOf(59) < 0) {
                        String disposition = checkedDownload.getContentDisposition();
                        int pos = disposition.indexOf(59);
                        if (pos >= 0) {
                            resp.setHeader("Content-Disposition", contentDisposition + disposition.substring(pos));
                        } else {
                            resp.setHeader("Content-Disposition", contentDisposition);
                        }
                    } else {
                        resp.setHeader("Content-Disposition", contentDisposition);
                    }
                }
                if (contentType == null) {
                    resp.setContentType(checkedDownload.getContentType());
                } else {
                    resp.setContentType(contentType);
                }
                documentData = checkedDownload.getInputStream();
            }
            Tools.removeCachingHeader(resp);
            if (delivery == null || !delivery.equalsIgnoreCase("download")) {
                String eTag = result.getHeader("ETag");
                if (null != eTag) {
                    long expires = result.getExpires();
                    Tools.setETag(eTag, expires > 0L ? new Date(System.currentTimeMillis() + expires) : null, resp);
                } else {
                    long expires = result.getExpires();
                    if (expires < 0L) {
                        Tools.setExpiresInOneYear(resp);
                    } else if (expires > 0L) {
                        Tools.setExpires(new Date(System.currentTimeMillis() + expires), resp);
                    }
                }
            }
            ServletOutputStream outputStream = resp.getOutputStream();
            int len = 2048;
            byte[] buf = new byte[2048];
            while ((read = documentData.read(buf, 0, 2048)) > 0) {
                outputStream.write(buf, 0, read);
            }
            outputStream.flush();
            Streams.close((Closeable)file);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (OXException e2) {
                LOG.error((Object)e2.getMessage(), (Throwable)e2);
                return;
            }
        }
        finally {
            Streams.close((Closeable)file);
            Streams.close(documentData);
        }
        Streams.close((Closeable)documentData);
        return;
    }

    private IFileHolder rotateIfImage(IFileHolder file) throws IOException, OXException {
        ImageScalingService scaler = this.scaler;
        if (scaler == null) {
            return file;
        }
        if (!this.isImage(file)) {
            return file;
        }
        InputStream rotated = scaler.rotateAccordingExif(file.getStream(), file.getContentType());
        if (null == rotated) {
            // empty if block
        }
        return new FileHolder(rotated, -1L, file.getContentType(), "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IFileHolder scaleIfImage(AJAXRequestData request, IFileHolder file) throws IOException, OXException {
        ImageScalingService scaler = this.scaler;
        if (scaler == null) {
            return file;
        }
        if (!this.isImage(file)) {
            return file;
        }
        int width = -1;
        int height = -1;
        if (request.isSet("width")) {
            width = request.getParameter("width", Integer.TYPE);
        }
        if (request.isSet("height")) {
            height = request.getParameter("height", Integer.TYPE);
        }
        if (width == -1 && height == -1) {
            return file;
        }
        try {
            InputStream input = file.getStream();
            InputStream scaled = null == input ? null : scaler.scale(input, width, height, ScaleType.getType(request.getParameter("scaleType")));
            FileHolder fileHolder = new FileHolder(scaled, -1L, "image/png", "");
            return fileHolder;
        }
        finally {
            Streams.close((Closeable)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IFileHolder cropIfImage(AJAXRequestData request, IFileHolder file) throws IOException, OXException {
        if (!(null != this.scaler && this.isImage(file) && request.isSet("cropWidth") && request.isSet("cropHeight"))) {
            return file;
        }
        int cropX = request.isSet("cropX") ? request.getParameter("cropX", Integer.TYPE) : 0;
        int cropY = request.isSet("cropY") ? request.getParameter("cropY", Integer.TYPE) : 0;
        int cropWidth = request.getParameter("cropWidth", Integer.TYPE);
        int cropHeight = request.getParameter("cropHeight", Integer.TYPE);
        try {
            InputStream croppedImage = this.scaler.crop(file.getStream(), cropX, cropY, cropWidth, cropHeight, file.getContentType());
            FileHolder fileHolder = new FileHolder(croppedImage, -1L, file.getContentType(), file.getName());
            return fileHolder;
        }
        finally {
            Streams.close((Closeable)file);
        }
    }

    private boolean isImage(IFileHolder file) {
        String fileName;
        String contentType = file.getContentType();
        return null != contentType && contentType.startsWith("image/") || (fileName = file.getName()) != null && (contentType = FileTypeMap.getDefaultFileTypeMap().getContentType(fileName)).startsWith("image/");
    }
}

