/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler;

import com.openexchange.ajax.requesthandler.AJAXStateHandler;
import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class AJAXState {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(AJAXState.class));
    private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private final Set<String> initializers = new HashSet<String>();
    private final Queue<AJAXStateHandler> handlers = new ConcurrentLinkedQueue<AJAXStateHandler>();

    public boolean containsProperty(String name) {
        return this.properties.containsKey(name);
    }

    public <V> V optProperty(String name) {
        return (V)this.properties.get(name);
    }

    public <V> V getProperty(String name) throws OXException {
        Object value = this.properties.get(name);
        if (null == value) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        return (V)value;
    }

    public Object putProperty(String name, Object value) {
        return this.properties.put(name, value);
    }

    public <V> V removeProperty(String name) {
        return (V)this.properties.remove(name);
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public Set<String> propertyNames() {
        return new HashSet<String>(this.properties.keySet());
    }

    public boolean addInitializer(String identifier, AJAXStateHandler handler) {
        this.handlers.add(handler);
        return this.initializers.add(identifier);
    }

    public void close() {
        while (!this.handlers.isEmpty()) {
            AJAXStateHandler handler = this.handlers.poll();
            try {
                handler.cleanUp(this);
            }
            catch (OXException e) {
                LOG.error((Object)("Failed closeing handler: " + handler.getClass().getName()), (Throwable)e);
            }
        }
        this.initializers.clear();
        this.properties.clear();
    }
}

