/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler;

import com.openexchange.exception.OXException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class AJAXRequestResult {
    private static final String JSON = "json".intern();
    public static final long SECOND_IN_MILLIS = 1000L;
    public static final long MINUTE_IN_MILLIS = 60000L;
    public static final long HOUR_IN_MILLIS = 3600000L;
    public static final long DAY_IN_MILLIS = 86400000L;
    public static final long WEEK_IN_MILLIS = 604800000L;
    public static final long YEAR_IN_MILLIS = 31449600000L;
    public static final AJAXRequestResult EMPTY_REQUEST_RESULT = new AJAXRequestResult(){

        @Override
        public void setResultObject(Object resultObject) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }

        @Override
        public void setResultObject(Object object, String format) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }

        @Override
        public void setFormat(String format) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }

        @Override
        public void setTimestamp(Date timestamp) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }

        @Override
        public void setHeader(String header, String value) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }

        @Override
        public void setDeferred(boolean deferred) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }

        @Override
        public void setExpires(long expires) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }

        @Override
        public void setType(ResultType resultType) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }

        @Override
        public AJAXRequestResult addWarnings(Collection<OXException> warnings) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }

        @Override
        public void setParameter(String name, Object value) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }

        @Override
        public void setResponseProperty(String name, Object value) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }

        @Override
        public void removeHeader(String header) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }

        @Override
        public void removeParameter(String name) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }

        @Override
        public void removeResponseProperty(String name) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }
    };
    private ResultType resultType;
    private Object resultObject;
    private Date timestamp;
    private Collection<OXException> warnings;
    private boolean deferred;
    private final Map<String, String> headers = new LinkedHashMap<String, String>(8);
    private final Map<String, Object> parameters = new HashMap<String, Object>(8);
    private final Map<String, Object> responseProperties = new HashMap<String, Object>(4);
    private String format;
    private long expires;
    private OXException exception;
    private long duration = -1L;

    public AJAXRequestResult() {
        this(null, null, null);
    }

    public AJAXRequestResult(Object resultObject) {
        this(resultObject, null, null);
    }

    public AJAXRequestResult(Object resultObject, Date timestamp) {
        this(resultObject, timestamp, null);
    }

    public AJAXRequestResult(Object resultObject, String format) {
        this(resultObject, null, format);
    }

    public AJAXRequestResult(Object resultObject, Date timestamp, String format) {
        this.resultObject = resultObject;
        this.timestamp = null == timestamp ? null : new Date(timestamp.getTime());
        this.format = null == format ? JSON : format;
        this.resultType = ResultType.COMMON;
        this.expires = -1L;
    }

    public long getDuration() {
        return this.duration;
    }

    public AJAXRequestResult setDuration(long duration) {
        this.duration = duration < 0L ? -1L : duration;
        return this;
    }

    public AJAXRequestResult setDurationByStart(long start) {
        return this.setDuration(System.currentTimeMillis() - start);
    }

    public AJAXRequestResult addDuration(long duration) {
        if (this.duration < 0L) {
            return this.setDuration(duration);
        }
        this.duration += duration;
        return this;
    }

    public AJAXRequestResult addDurationByStart(long start) {
        return this.addDuration(System.currentTimeMillis() - start);
    }

    public ResultType getType() {
        return this.resultType;
    }

    public void setType(ResultType resultType) {
        this.resultType = resultType;
    }

    public long getExpires() {
        return this.expires;
    }

    public void setExpires(long expires) {
        this.expires = expires;
    }

    public boolean isDeferred() {
        return this.deferred;
    }

    public void setDeferred(boolean deferred) {
        this.deferred = deferred;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.resultObject == null ? 0 : this.resultObject.hashCode());
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AJAXRequestResult)) {
            return false;
        }
        AJAXRequestResult other = (AJAXRequestResult)obj;
        if (this.resultObject == null ? other.resultObject != null : !this.resultObject.equals(other.resultObject)) {
            return false;
        }
        return !(this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp));
    }

    public Object getResultObject() {
        return this.resultObject;
    }

    public void setResultObject(Object resultObject) {
        this.resultObject = resultObject;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public Date getTimestamp() {
        return null == this.timestamp ? null : new Date(this.timestamp.getTime());
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Collection<OXException> getWarnings() {
        return null == this.warnings ? Collections.emptySet() : Collections.unmodifiableCollection(this.warnings);
    }

    public AJAXRequestResult addWarnings(Collection<OXException> warnings) {
        if (null == warnings || warnings.isEmpty()) {
            return this;
        }
        if (null == this.warnings) {
            this.warnings = new HashSet<OXException>(warnings);
        } else {
            this.warnings.addAll(warnings);
        }
        return this;
    }

    public void setHeader(String header, String value) {
        if (null == value) {
            this.headers.remove(header);
        } else {
            this.headers.put(header, value);
        }
    }

    public void removeHeader(String header) {
        this.headers.remove(header);
    }

    public String getHeader(String header) {
        return this.headers.get(header);
    }

    public Map<String, String> getHeaders() {
        return new HashMap<String, String>(this.headers);
    }

    public void setParameter(String name, Object value) {
        if (null == value) {
            this.parameters.remove(name);
        } else {
            this.parameters.put(name, value);
        }
    }

    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    public Object getParameter(String name) {
        return this.parameters.get(name);
    }

    public Map<String, Object> getParameters() {
        return new HashMap<String, Object>(this.parameters);
    }

    public void setResponseProperty(String name, Object value) {
        if (null == value) {
            this.responseProperties.remove(name);
        } else {
            this.responseProperties.put(name, value);
        }
    }

    public void removeResponseProperty(String name) {
        this.responseProperties.remove(name);
    }

    public Object getResponseProperty(String name) {
        return this.responseProperties.get(name);
    }

    public Map<String, Object> getResponseProperties() {
        return this.responseProperties;
    }

    public String toString() {
        return new StringBuilder(34).append(super.toString()).append(" resultObject=").append(this.resultObject).append(", timestamp=").append(this.timestamp).append(" warnings=").append(null == this.warnings ? "<none>" : this.warnings.toString()).toString();
    }

    public void setResultObject(Object object, String format) {
        this.setResultObject(object);
        this.setFormat(format);
    }

    public void setException(OXException exception) {
        this.exception = exception;
    }

    public OXException getException() {
        return this.exception;
    }

    public static enum ResultType {
        COMMON,
        ETAG;

    }
}

