/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.HTTPRequestInputStreamProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.notify.hostname.HostnameService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AJAXRequestDataTools {
    private static final AJAXRequestDataTools INSTANCE = new AJAXRequestDataTools();
    protected static final Pattern SPLIT_CSV = Pattern.compile("\\s*,\\s*");
    private static final Set<String> BOOL_VALS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("true", "1", "yes", "y", "on")));

    public static AJAXRequestDataTools getInstance() {
        return INSTANCE;
    }

    protected AJAXRequestDataTools() {
    }

    public AJAXRequestData parseRequest(HttpServletRequest req, boolean preferStream, boolean isFileUpload, ServerSession session, String prefix) throws IOException, OXException {
        String parameter;
        AJAXRequestData retval = new AJAXRequestData();
        AJAXRequestDataTools.parseHostName(retval, req, session);
        retval.setMultipart(isFileUpload);
        retval.setHttpServletRequest(req);
        retval.setModule(this.getModule(prefix, req));
        retval.setServletRequestURI(AJAXServlet.getServletSpecificURI(req));
        retval.setPathInfo(req.getPathInfo());
        retval.setAction(this.getAction(req));
        retval.setFormat(req.getParameter("format"));
        Set entrySet = req.getParameterMap().entrySet();
        for (Map.Entry entry : entrySet) {
            retval.putParameter((String)entry.getKey(), ((String[])entry.getValue())[0]);
        }
        String eTag = req.getHeader("If-None-Match");
        if (null != eTag) {
            retval.setETag(eTag);
        }
        if (null != (parameter = req.getParameter("decorators"))) {
            for (String id : SPLIT_CSV.split(parameter, 0)) {
                retval.addDecoratorId(id.trim());
            }
        }
        if (preferStream || AJAXRequestDataTools.parseBoolParameter("binary", req)) {
            retval.setUploadStreamProvider(new HTTPRequestInputStreamProvider(req));
        } else {
            String body = AJAXServlet.getBody(req);
            if (AJAXRequestDataTools.startsWith('{', body)) {
                try {
                    retval.setData(new JSONObject(body));
                }
                catch (JSONException e) {
                    retval.setData(body);
                }
            } else if (AJAXRequestDataTools.startsWith('[', body)) {
                try {
                    retval.setData(new JSONArray(body));
                }
                catch (JSONException e) {
                    retval.setData(body);
                }
            } else {
                retval.setData(0 == body.length() ? null : body);
            }
        }
        return retval;
    }

    private static boolean parseBoolParameter(String name, HttpServletRequest req) {
        return AJAXRequestDataTools.parseBoolParameter(req.getParameter(name));
    }

    public static boolean parseBoolParameter(String name, AJAXRequestData requestData) {
        return AJAXRequestDataTools.parseBoolParameter(requestData.getParameter(name));
    }

    public static boolean parseBoolParameter(String parameter) {
        if (null == parameter) {
            return false;
        }
        return BOOL_VALS.contains(parameter.trim().toLowerCase(Locale.ENGLISH));
    }

    public static void parseHostName(AJAXRequestData request, HttpServletRequest req, ServerSession session) {
        request.setSecure(Tools.considerSecure(req));
        HostnameService hostnameService = ServerServiceRegistry.getInstance().getService(HostnameService.class);
        if (null == hostnameService) {
            request.setHostname(req.getServerName());
        } else {
            String hn = hostnameService.getHostname(session.getUserId(), session.getContextId());
            request.setHostname(null == hn ? req.getServerName() : hn);
        }
        request.setRemoteAddress(req.getRemoteAddr());
        request.setRoute(Tools.getRoute(req.getSession(true).getId()));
    }

    private static boolean startsWith(char startingChar, String toCheck) {
        if (null == toCheck) {
            return false;
        }
        int len = toCheck.length();
        if (len <= 0) {
            return false;
        }
        int i = 0;
        if (Character.isWhitespace(toCheck.charAt(i))) {
            while (++i < len && Character.isWhitespace(toCheck.charAt(i))) {
            }
        }
        if (i >= len) {
            return false;
        }
        return startingChar == toCheck.charAt(i);
    }

    public String getModule(String prefix, HttpServletRequest req) {
        String module;
        String pathInfo = req.getRequestURI();
        int lastIndex = pathInfo.lastIndexOf(59);
        if (lastIndex > 0) {
            pathInfo = pathInfo.substring(0, lastIndex);
        }
        if ((module = pathInfo.substring(prefix.length())).endsWith("/")) {
            module = module.substring(0, module.length() - 1);
        }
        return module;
    }

    public String getAction(HttpServletRequest req) {
        String action = req.getParameter("action");
        if (null == action) {
            return req.getMethod().toUpperCase(Locale.US);
        }
        return action;
    }
}

