/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.container;

import com.openexchange.ajax.parser.ResponseParser;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.session.Session;
import com.openexchange.tools.UnsynchronizedStringWriter;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;

public final class Response {
    private static final Locale DEFAULT_LOCALE = Locale.US;
    private final Map<String, Object> properties;
    private Locale locale;
    private transient JSONObject json = null;
    private Object data;
    private Date timestamp;
    private OXException exception;
    private final List<OXException> warnings = new LinkedList<OXException>();

    public Response(JSONObject response) {
        this(DEFAULT_LOCALE);
        this.json = response;
    }

    public Response(Session session) throws OXException {
        this(null == session ? DEFAULT_LOCALE : Response.getServerSessionFrom(session).getUser().getLocale());
    }

    public Response(ServerSession session) {
        this(null == session ? DEFAULT_LOCALE : session.getUser().getLocale());
    }

    public Response() {
        this(DEFAULT_LOCALE);
    }

    public Response(Locale locale) {
        this.properties = new HashMap<String, Object>(8);
        this.locale = locale;
    }

    public Response setProperties(Map<String, Object> properties) {
        if (null != properties) {
            this.properties.putAll(properties);
        }
        return this;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Response setLocale(ServerSession session) {
        this.locale = null == session ? DEFAULT_LOCALE : session.getUser().getLocale();
        return this;
    }

    public Response setLocale(Session session) throws OXException {
        this.locale = null == session ? DEFAULT_LOCALE : Response.getServerSessionFrom(session).getUser().getLocale();
        return this;
    }

    public Response setLocale(Locale locale) {
        this.locale = null == locale ? DEFAULT_LOCALE : locale;
        return this;
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Deprecated
    public JSONObject getJSON() throws JSONException {
        if (null == this.json) {
            this.json = ResponseWriter.getJSON(this);
        }
        return this.json;
    }

    public void reset() {
        this.json = null;
        this.data = null;
        this.timestamp = null;
        this.exception = null;
        this.warnings.clear();
    }

    public Object getData() {
        return this.data;
    }

    public String getErrorMessage() {
        if (null == this.exception) {
            return null;
        }
        return this.exception.getMessage();
    }

    public String getFormattedErrorMessage() {
        if (null == this.exception) {
            return null;
        }
        return this.exception.getDisplayMessage(DEFAULT_LOCALE);
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public boolean hasError() {
        return this.exception != null;
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    @Deprecated
    public static Response parse(String body) throws JSONException {
        return ResponseParser.parse(body);
    }

    @Deprecated
    public static void write(Response response, Writer writer) throws JSONException, IOException {
        ResponseWriter.write(response, writer);
    }

    @Deprecated
    public static void write(Response response, JSONWriter writer) throws JSONException {
        ResponseWriter.write(response, writer);
    }

    public String toString() {
        UnsynchronizedStringWriter writer = new UnsynchronizedStringWriter();
        JSONObject json = new JSONObject();
        try {
            ResponseWriter.write(this, json);
            json.write((Writer)writer);
        }
        catch (JSONException e) {
            e.printStackTrace(new PrintWriter(writer));
        }
        return writer.toString();
    }

    public Response setException(OXException exception) {
        if (Category.CATEGORY_WARNING.equals(exception.getCategory())) {
            this.addWarning(exception);
        } else {
            this.exception = exception;
        }
        return this;
    }

    public Response addWarning(OXException warning) {
        if (!Category.CATEGORY_WARNING.equals(warning.getCategory())) {
            warning.setCategory(Category.CATEGORY_WARNING);
        }
        this.warnings.add(warning);
        return this;
    }

    public Response addWarnings(Collection<OXException> warnings) {
        for (OXException warning : warnings) {
            if (Category.CATEGORY_WARNING.equals(this.exception.getCategory())) continue;
            warning.setCategory(Category.CATEGORY_WARNING);
        }
        warnings.addAll(warnings);
        return this;
    }

    public OXException getException() {
        return this.exception;
    }

    public List<OXException> getWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    private static ServerSession getServerSessionFrom(Session session) throws OXException {
        if (session instanceof ServerSession) {
            return (ServerSession)session;
        }
        return ServerSessionAdapter.valueOf(session);
    }
}

