/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.PermissionServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.helper.ParamContainer;
import com.openexchange.ajax.requesthandler.DefaultDispatcherPrefixService;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.api2.sync.RdbFolderSyncInterface;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.EnumComponent;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.monitoring.MonitoringInfo;
import com.openexchange.session.Session;
import com.openexchange.tools.UnsynchronizedStringWriter;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderUtility;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONWriter;

public class SyncServlet
extends PermissionServlet {
    private static final long serialVersionUID = 8749478304854849616L;
    private static final transient Log LOG = LogFactory.getLog(SyncServlet.class);
    public static final String ACTION_REFRESH_SERVER = "refresh_server";
    private static final int RADIX = 10;

    @Override
    protected void incrementRequests() {
        MonitoringInfo.incrementNumberOfConnections((int)5);
    }

    @Override
    protected void decrementRequests() {
        MonitoringInfo.decrementNumberOfConnections((int)5);
    }

    @Override
    protected boolean hasModulePermission(ServerSession session) {
        return session.getUserConfiguration().hasSyncML();
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/javascript; charset=UTF-8");
        Tools.disableCaching(resp);
        try {
            this.actionPut(req, resp);
        }
        catch (OXException e) {
            e.log(LOG);
            PrintWriter writer = resp.getWriter();
            Response response = new Response();
            response.setException(e);
            try {
                ResponseWriter.write(response, writer);
            }
            catch (JSONException e1) {
                LOG.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
        catch (Exception e) {
            OXException wrapper = SyncServlet.getWrappingOXException(e);
            LOG.error((Object)wrapper.getMessage(), (Throwable)wrapper);
            PrintWriter writer = resp.getWriter();
            Response response = new Response();
            response.setException(wrapper);
            try {
                ResponseWriter.write(response, writer);
            }
            catch (JSONException e1) {
                LOG.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    private final void actionPut(HttpServletRequest req, HttpServletResponse resp) throws IOException, OXException {
        String actionStr = SyncServlet.checkStringParam(req, "action");
        if (!actionStr.equalsIgnoreCase(ACTION_REFRESH_SERVER)) {
            throw SyncServlet.getWrappingOXException(new Exception("Action \"" + actionStr + "\" NOT supported via PUT on " + DefaultDispatcherPrefixService.getInstance().getPrefix() + "sync"));
        }
        this.actionPutClearFolderContent(req, resp);
    }

    private final void actionPutClearFolderContent(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            this.actionPutClearFolderContent(SyncServlet.getSessionObject((ServletRequest)req), resp.getWriter(), SyncServlet.getBody(req), ParamContainer.getInstance(req, EnumComponent.SYNCML, resp));
        }
        catch (JSONException e) {
            SyncServlet.writeErrorResponse((HttpServletResponseWrapper)resp, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void actionPutClearFolderContent(Session sessionObj, Writer writer, String body, ParamContainer paramContainer) throws JSONException, IOException {
        Response response;
        try {
            response = new Response(sessionObj);
        }
        catch (OXException e1) {
            ResponseWriter.write(new Response().setException(e1), writer);
            return;
        }
        UnsynchronizedStringWriter strWriter = new UnsynchronizedStringWriter();
        JSONWriter jsonWriter = new JSONWriter((Writer)strWriter);
        Date lastModifiedDate = null;
        jsonWriter.array();
        try {
            Context ctx = ContextStorage.getStorageContext(sessionObj.getContextId());
            Date timestamp = null;
            JSONArray jsonArr = new JSONArray(body);
            int length = jsonArr.length();
            RdbFolderSyncInterface folderSyncInterface = null;
            MailServletInterface mailInterface = null;
            try {
                long lastModified = 0L;
                OXFolderAccess access = new OXFolderAccess(ctx);
                for (int i = 0; i < length; ++i) {
                    String deleteIdentifier = jsonArr.getString(i);
                    int delFolderId = -1;
                    delFolderId = SyncServlet.getUnsignedInteger(deleteIdentifier);
                    if (delFolderId >= 0) {
                        FolderObject delFolderObj;
                        if (timestamp == null) {
                            timestamp = paramContainer.checkDateParam("timestamp");
                        }
                        if (folderSyncInterface == null) {
                            folderSyncInterface = new RdbFolderSyncInterface(sessionObj, ctx, access);
                        }
                        try {
                            delFolderObj = access.getFolderObject(delFolderId);
                        }
                        catch (OXException exc) {
                            if (!LOG.isWarnEnabled()) continue;
                            LOG.warn((Object)exc.getMessage(), (Throwable)exc);
                            continue;
                        }
                        if (delFolderObj.getLastModified().getTime() > timestamp.getTime()) {
                            jsonWriter.value((long)delFolderObj.getObjectID());
                            continue;
                        }
                        folderSyncInterface.clearFolder(delFolderObj, timestamp);
                        lastModified = Math.max(lastModified, delFolderObj.getLastModified().getTime());
                        continue;
                    }
                    if (deleteIdentifier.startsWith("u:")) {
                        throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(OXFolderUtility.getUserName(sessionObj.getUserId(), ctx), deleteIdentifier, ctx.getContextId());
                    }
                    if (UserConfigurationStorage.getInstance().getUserConfigurationSafe(sessionObj.getUserId(), ctx).hasWebMail()) {
                        if (mailInterface == null) {
                            mailInterface = MailServletInterface.getInstance(sessionObj);
                        }
                        mailInterface.clearFolder(deleteIdentifier);
                        continue;
                    }
                    jsonWriter.value((Object)deleteIdentifier);
                }
                if (lastModified != 0L) {
                    lastModifiedDate = new Date(lastModified);
                }
            }
            finally {
                if (mailInterface != null) {
                    mailInterface.close(true);
                    mailInterface = null;
                }
            }
        }
        catch (OXException e) {
            e.log(LOG);
            if (!e.getCategory().equals(Category.CATEGORY_PERMISSION_DENIED)) {
                response.setException(e);
            }
        }
        catch (Exception e) {
            OXException wrapper = SyncServlet.getWrappingOXException(e);
            LOG.error((Object)wrapper.getMessage(), (Throwable)wrapper);
            response.setException(wrapper);
        }
        jsonWriter.endArray();
        response.setData(new JSONArray(strWriter.toString()));
        response.setTimestamp(lastModifiedDate);
        ResponseWriter.write(response, writer);
    }

    private static final void writeErrorResponse(HttpServletResponseWrapper resp, Throwable e) throws IOException {
        OXException wrapper = SyncServlet.getWrappingOXException(e);
        LOG.error((Object)wrapper.getMessage(), (Throwable)wrapper);
        SyncServlet.writeErrorResponse(resp, wrapper);
    }

    private static final void writeErrorResponse(HttpServletResponseWrapper resp, OXException e) throws IOException {
        PrintWriter writer = resp.getWriter();
        Response response = new Response();
        response.setException(e);
        try {
            ResponseWriter.write(response, writer);
        }
        catch (JSONException e1) {
            LOG.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    private static final OXException getWrappingOXException(Throwable cause) {
        return AjaxExceptionCodes.UNEXPECTED_ERROR.create(cause, cause.getMessage());
    }

    private static final String checkStringParam(HttpServletRequest req, String paramName) throws OXException {
        String paramVal = req.getParameter(paramName);
        if (paramVal == null) {
            throw OXFolderExceptionCode.MISSING_PARAMETER.create(paramName);
        }
        return paramVal;
    }

    private static final int getUnsignedInteger(String s) {
        int digit;
        if (s == null) {
            return -1;
        }
        int max = s.length();
        if (max <= 0) {
            return -1;
        }
        if (s.charAt(0) == '-') {
            return -1;
        }
        int result = 0;
        int i = 0;
        int limit = -2147483647;
        int multmin = -214748364;
        if (i < max) {
            if ((digit = Character.digit(s.charAt(i++), 10)) < 0) {
                return -1;
            }
            result = -digit;
        }
        while (i < max) {
            if ((digit = Character.digit(s.charAt(i++), 10)) < 0) {
                return -1;
            }
            if (result < -214748364) {
                return -1;
            }
            if ((result *= 10) < -2147483647 + digit) {
                return -1;
            }
            result -= digit;
        }
        return -result;
    }
}

