/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.PermissionServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.exception.OXException;
import com.openexchange.log.LogFactory;
import com.openexchange.multiple.MultipleHandler;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class MultipleAdapterServlet
extends PermissionServlet {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MultipleAdapterServlet.class));

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handle(req, resp);
    }

    protected void handle(HttpServletRequest req, HttpServletResponse resp) {
        resp.setStatus(200);
        resp.setContentType("text/javascript; charset=UTF-8");
        Tools.disableCaching(resp);
        if (this.handleOverride(req, resp)) {
            return;
        }
        ServerSession session = MultipleAdapterServlet.getSessionObject((ServletRequest)req);
        try {
            String action = req.getParameter("action");
            JSONObject request = this.toJSON(req, action);
            MultipleHandler handler = this.createMultipleHandler();
            if (action == null) {
                throw AjaxExceptionCodes.MISSING_PARAMETER.create("action");
            }
            Object response = handler.performRequest(action, request, session, Tools.considerSecure(req));
            Date timestamp = handler.getTimestamp();
            this.writeResponseSafely(response, session.getUser().getLocale(), timestamp, handler.getWarnings(), resp);
        }
        catch (OXException x) {
            this.writeException(x, session.getUser().getLocale(), resp);
        }
        catch (Throwable t) {
            this.writeException(this.wrap(t), session.getUser().getLocale(), resp);
        }
    }

    private OXException wrap(Throwable t) {
        return AjaxExceptionCodes.UNEXPECTED_ERROR.create(t, t.getMessage());
    }

    protected boolean handleOverride(HttpServletRequest req, HttpServletResponse resp) {
        return false;
    }

    private void writeResponseSafely(Object data, Locale locale, Date timestamp, Collection<OXException> warnings, HttpServletResponse resp) {
        Response response = new Response(locale);
        response.setData(data);
        if (null != timestamp) {
            response.setTimestamp(timestamp);
        }
        if (null != warnings && !warnings.isEmpty()) {
            response.addWarnings(warnings);
        }
        try {
            this.writeResponse(response, resp);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void writeException(OXException x, Locale locale, HttpServletResponse resp) {
        x.log(LOG);
        Response response = new Response(locale);
        response.setException(x);
        try {
            this.writeResponse(response, resp);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private JSONObject toJSON(HttpServletRequest req, String action) throws JSONException, IOException {
        String body;
        JSONObject request = new JSONObject();
        Enumeration parameterNames = req.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            String parameter = req.getParameter(parameterName);
            request.put(parameterName, (Object)parameter);
        }
        if (this.requiresBody(action) && (body = MultipleAdapterServlet.getBody(req)) != null && !body.equals("")) {
            Object value = this.toJSONConformantValue(body);
            request.put("data", value);
        }
        return this.modify(req, action, request);
    }

    protected JSONObject modify(HttpServletRequest req, String action, JSONObject request) throws JSONException {
        return request;
    }

    private Object toJSONConformantValue(String body) throws JSONException {
        return new JSONObject("{ body : " + body + " }").get("body");
    }

    protected abstract boolean requiresBody(String var1);

    protected abstract MultipleHandler createMultipleHandler();
}

