/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.DataServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.parser.ContactParser;
import com.openexchange.ajax.parser.DataParser;
import com.openexchange.ajax.request.ContactRequest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactInterface;
import com.openexchange.groupware.contact.ContactInterfaceDiscoveryService;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.upload.UploadFile;
import com.openexchange.groupware.upload.impl.UploadEvent;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;

public class Contact
extends DataServlet {
    private static final long serialVersionUID = 1635881627528234660L;
    private static final transient Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(Contact.class));

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ServerSession session = Contact.getSessionObject((ServletRequest)httpServletRequest);
        Response response = new Response(session);
        try {
            String action = Contact.parseMandatoryStringParameter(httpServletRequest, "action");
            JSONObject jsonObj = null;
            try {
                jsonObj = Contact.convertParameter2JSONObject(httpServletRequest);
            }
            catch (JSONException e) {
                LOG.error((Object)"doGet", (Throwable)e);
                response.setException(OXJSONExceptionCodes.JSON_BUILD_ERROR.create(e, new Object[0]));
                this.writeResponse(response, httpServletResponse);
                return;
            }
            if (action.equals("image")) {
                int id = DataParser.checkInt(jsonObj, "id");
                int inFolder = DataParser.checkInt(jsonObj, "folder");
                OutputStream os = null;
                Context ctx = session.getContext();
                ContactInterface contactInterface = ServerServiceRegistry.getInstance().getService(ContactInterfaceDiscoveryService.class).getContactInterfaceProvider(inFolder, ctx.getContextId()).newContactInterface(session);
                try {
                    com.openexchange.groupware.container.Contact contactObj = contactInterface.getObjectById(id, inFolder);
                    String imageContentType = contactObj.getImageContentType();
                    if (imageContentType != null) {
                        httpServletResponse.setContentType(imageContentType);
                        Tools.removeCachingHeader(httpServletResponse);
                        os = httpServletResponse.getOutputStream();
                        if (contactObj.getImage1() != null) {
                            os.write(contactObj.getImage1());
                        }
                    } else {
                        LOG.warn((Object)("image doesn't contain a content type: object_id=" + id));
                    }
                }
                catch (OXException e) {
                    LOG.error((Object)"actionImage", (Throwable)e);
                    httpServletResponse.sendError(500, "");
                }
                if (os != null) {
                    os.flush();
                }
                return;
            }
            ContactRequest contactRequest = new ContactRequest(session);
            JSONValue responseObj = contactRequest.action(action, jsonObj);
            response.setTimestamp(contactRequest.getTimestamp());
            response.setData(responseObj);
        }
        catch (JSONException e) {
            OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error((Object)oje.getMessage(), (Throwable)oje);
            response.setException(oje);
        }
        catch (OXException e) {
            response.setException(e);
        }
        this.writeResponse(response, httpServletResponse);
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Response response;
        block11: {
            ServerSession session = Contact.getSessionObject((ServletRequest)httpServletRequest);
            response = new Response(session);
            try {
                String action = Contact.parseMandatoryStringParameter(httpServletRequest, "action");
                String data = Contact.getBody(httpServletRequest);
                if (data.length() > 0) {
                    JSONObject jsonObj;
                    try {
                        jsonObj = Contact.convertParameter2JSONObject(httpServletRequest);
                    }
                    catch (JSONException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                        response.setException(OXJSONExceptionCodes.JSON_BUILD_ERROR.create(e, new Object[0]));
                        this.writeResponse(response, httpServletResponse);
                        return;
                    }
                    ContactRequest contactRequest = new ContactRequest(session);
                    if (data.charAt(0) == '[') {
                        JSONArray jsonDataArray = new JSONArray(data);
                        jsonObj.put("data", (Object)jsonDataArray);
                        JSONValue responseObj = contactRequest.action(action, jsonObj);
                        response.setTimestamp(contactRequest.getTimestamp());
                        response.setData(responseObj);
                    } else if (data.charAt(0) == '{') {
                        JSONObject jsonDataObj = new JSONObject(data);
                        jsonObj.put("data", (Object)jsonDataObj);
                        JSONValue responseObj = contactRequest.action(action, jsonObj);
                        response.setTimestamp(contactRequest.getTimestamp());
                        response.setData(responseObj);
                    } else {
                        httpServletResponse.sendError(400, "invalid json object");
                    }
                    if (null != contactRequest.getTimestamp()) {
                        response.setTimestamp(contactRequest.getTimestamp());
                    }
                    break block11;
                }
                httpServletResponse.sendError(400, "no data found");
            }
            catch (JSONException e) {
                OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
                LOG.error((Object)oje.getMessage(), (Throwable)oje);
                response.setException(oje);
            }
            catch (OXException e) {
                response.setException(e);
            }
        }
        this.writeResponse(response, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String action;
        Response response;
        String callbackSite;
        block32: {
            httpServletResponse.setContentType("text/html");
            callbackSite = null;
            ServerSession session = Contact.getSessionObject((ServletRequest)httpServletRequest);
            response = new Response(session);
            action = "error";
            try {
                action = Contact.parseMandatoryStringParameter(httpServletRequest, "action");
                ContactInterfaceDiscoveryService discoveryService = ServerServiceRegistry.getInstance().getService(ContactInterfaceDiscoveryService.class);
                if (action.equals("new")) {
                    UploadEvent upload = null;
                    try {
                        upload = this.processUpload(httpServletRequest);
                        UploadFile uploadFile = upload.getUploadFileByFieldName("file");
                        if (uploadFile == null) {
                            throw AjaxExceptionCodes.NO_UPLOAD_IMAGE.create();
                        }
                        String obj = upload.getFormField("json");
                        if (obj == null) {
                            throw AjaxExceptionCodes.MISSING_PARAMETER.create("json");
                        }
                        com.openexchange.groupware.container.Contact contactobject = new com.openexchange.groupware.container.Contact();
                        JSONObject jsonobject = new JSONObject(obj);
                        ContactParser contactparser = new ContactParser();
                        contactparser.parse(contactobject, jsonobject);
                        if (!contactobject.containsParentFolderID()) {
                            throw OXException.mandatoryField((String)"missing folder");
                        }
                        FileInputStream fis = new FileInputStream(uploadFile.getTmpFile());
                        try {
                            UnsynchronizedByteArrayOutputStream tmp = new UnsynchronizedByteArrayOutputStream((int)uploadFile.getSize());
                            byte[] buf = new byte[2048];
                            int len = -1;
                            while ((len = fis.read(buf)) != -1) {
                                tmp.write(buf, 0, len);
                            }
                            contactobject.setImage1(tmp.toByteArray());
                        }
                        finally {
                            fis.close();
                        }
                        contactobject.setImageContentType(uploadFile.getContentType());
                        ContactInterface contactInterface = discoveryService.newContactInterface(contactobject.getParentFolderID(), session);
                        contactInterface.insertContactObject(contactobject);
                        JSONObject jData = new JSONObject();
                        jData.put("id", contactobject.getObjectID());
                        response.setData(jData);
                        break block32;
                    }
                    finally {
                        if (upload != null) {
                            upload.cleanUp();
                        }
                    }
                }
                if (action.equals("update")) {
                    int id = Contact.parseMandatoryIntParameter(httpServletRequest, "id");
                    int inFolder = Contact.parseMandatoryIntParameter(httpServletRequest, "folder");
                    Date timestamp = Contact.parseMandatoryDateParameter(httpServletRequest, "timestamp");
                    UploadEvent upload = null;
                    try {
                        upload = this.processUpload(httpServletRequest);
                        UploadFile uploadFile = upload.getUploadFileByFieldName("file");
                        String obj = upload.getFormField("json");
                        if (obj == null) {
                            throw AjaxExceptionCodes.MISSING_PARAMETER.create("json");
                        }
                        com.openexchange.groupware.container.Contact contactobject = new com.openexchange.groupware.container.Contact();
                        JSONObject jsonobject = new JSONObject(obj);
                        ContactParser contactparser = new ContactParser();
                        contactparser.parse(contactobject, jsonobject);
                        contactobject.setObjectID(id);
                        if (null == uploadFile) {
                            contactobject.setImage1(null);
                        } else {
                            FileInputStream fis = new FileInputStream(uploadFile.getTmpFile());
                            try {
                                UnsynchronizedByteArrayOutputStream tmp = new UnsynchronizedByteArrayOutputStream((int)uploadFile.getSize());
                                byte[] buf = new byte[2048];
                                int len = -1;
                                while ((len = fis.read(buf)) != -1) {
                                    tmp.write(buf, 0, len);
                                }
                                contactobject.setImage1(tmp.toByteArray());
                            }
                            finally {
                                fis.close();
                            }
                            contactobject.setImageContentType(uploadFile.getContentType());
                        }
                        int folderId = contactobject.getParentFolderID();
                        ContactInterface targetContactInterface = discoveryService.newContactInterface(folderId, session);
                        boolean doUpdate = true;
                        ContactInterface srcContactIface = discoveryService.newContactInterface(inFolder, session);
                        if (!targetContactInterface.getClass().equals(srcContactIface.getClass())) {
                            doUpdate = false;
                            com.openexchange.groupware.container.Contact toMove = ContactRequest.move2AnotherProvider(id, inFolder, contactobject, srcContactIface, folderId, targetContactInterface, session, timestamp);
                        }
                        if (doUpdate) {
                            targetContactInterface.updateContactObject(contactobject, inFolder, timestamp);
                        }
                        break block32;
                    }
                    finally {
                        if (upload != null) {
                            upload.cleanUp();
                        }
                    }
                }
                throw AjaxExceptionCodes.UNKNOWN_ACTION.create(action);
            }
            catch (JSONException e) {
                OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
                LOG.error((Object)oje.getMessage(), (Throwable)oje);
                response.setException(oje);
            }
            catch (OXException e) {
                response.setException(e);
            }
        }
        try {
            callbackSite = AJAXServlet.substituteJS(response.getJSON().toString(), action);
            PrintWriter pw = httpServletResponse.getWriter();
            pw.print(callbackSite);
        }
        catch (JSONException e) {
            this.log("Error while writing response object.", e);
            Contact.sendError(httpServletResponse);
        }
    }

    @Override
    protected boolean hasModulePermission(ServerSession session) {
        return session.getUserConfiguration().hasContact();
    }
}

