/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.Mail;
import com.openexchange.ajax.PermissionServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.helper.ParamContainer;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.groupware.EnumComponent;
import com.openexchange.groupware.upload.impl.UploadException;
import com.openexchange.groupware.upload.impl.UploadQuotaChecker;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.servlet.UploadServletException;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class AJAXFile
extends PermissionServlet {
    private static final long serialVersionUID = 1L;
    private static final transient Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(AJAXFile.class));
    private static final String MIME_TEXT_HTML_CHARSET_UTF_8 = "text/html; charset=UTF-8";
    private static final String MIME_APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String STR_NULL = "null";
    private static final String FILE_TYPE_ALL = "file";
    private static final String FILE_TYPE_TEXT = "text";
    private static final String FILE_TYPE_MEDIA = "media";
    private static final String FILE_TYPE_IMAGE = "image";
    private static final String FILE_TYPE_AUDIO = "audio";
    private static final String FILE_TYPE_VIDEO = "video";
    private static final String FILE_TYPE_APPLICATION = "application";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/javascript; charset=UTF-8");
        Tools.disableCaching(resp);
        ServerSession session = AJAXFile.getSessionObject((ServletRequest)req);
        String action = req.getParameter("action");
        if ("keepalive".equalsIgnoreCase(action)) {
            this.actionKeepAlive(req, resp);
        } else if ("get".equalsIgnoreCase(action)) {
            this.actionGet(req, resp);
        } else {
            Response response = new Response(session);
            response.setException(UploadException.UploadCode.UNKNOWN_ACTION_VALUE.create(action == null ? STR_NULL : action).setAction(null));
            try {
                ResponseWriter.write(response, resp.getWriter());
            }
            catch (JSONException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                ServletException se = new ServletException(e.getMessage(), (Throwable)e);
                se.initCause((Throwable)e);
                throw se;
            }
        }
    }

    private void actionKeepAlive(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            ResponseWriter.write(this.actionKeepAlive(AJAXFile.getSessionObject((ServletRequest)req), ParamContainer.getInstance(req, EnumComponent.UPLOAD, resp)), resp.getWriter());
        }
        catch (JSONException e) {
            Response response = new Response(AJAXFile.getSessionObject((ServletRequest)req));
            response.setException(OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]));
            try {
                ResponseWriter.write(response, resp.getWriter());
            }
            catch (JSONException e1) {
                LOG.error((Object)e1.getMessage(), (Throwable)e1);
                ServletException se = new ServletException(e1.getMessage(), (Throwable)e1);
                se.initCause((Throwable)e1);
                throw se;
            }
        }
    }

    private Response actionKeepAlive(ServerSession session, ParamContainer paramContainer) {
        Response response = new Response(session);
        try {
            String id = paramContainer.checkStringParam("id");
            ManagedFileManagement management = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class);
            management.getByID(id);
        }
        catch (OXException e) {
            response.setException(e);
        }
        response.setData(JSONObject.NULL);
        response.setTimestamp(null);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actionGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServerSession session = AJAXFile.getSessionObject((ServletRequest)req);
        try {
            String id = req.getParameter("id");
            if (id == null || id.length() == 0) {
                throw UploadException.UploadCode.MISSING_PARAM.create("id").setAction("get");
            }
            String userAgent = req.getHeader("user-agent") == null ? null : req.getHeader("user-agent").toLowerCase(Locale.ENGLISH);
            boolean internetExplorer = userAgent != null && userAgent.indexOf("msie") > -1 && userAgent.indexOf("windows") > -1;
            ManagedFileManagement management = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class);
            ManagedFile file = management.getByID(id);
            String fileName = Mail.getSaveAsFileName(file.getFileName(), internetExplorer, file.getContentType());
            ContentType contentType = new ContentType(file.getContentType());
            if (contentType.getBaseType().equalsIgnoreCase(MIME_APPLICATION_OCTET_STREAM)) {
                String ct = MimeType2ExtMap.getContentType(fileName);
                int pos = ct.indexOf(47);
                contentType.setPrimaryType(ct.substring(0, pos));
                contentType.setSubType(ct.substring(pos + 1));
            }
            contentType.setParameter("name", fileName);
            resp.setContentType(contentType.toString());
            resp.setHeader("Content-disposition", new StringBuilder(50).append("inline; filename=\"").append(fileName).append('\"').toString());
            FileInputStream contentInputStream = null;
            Tools.removeCachingHeader(resp);
            ServletOutputStream out = resp.getOutputStream();
            try {
                int len;
                contentInputStream = new FileInputStream(file.getFile());
                byte[] buffer = new byte[65535];
                while ((len = ((InputStream)contentInputStream).read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
                out.flush();
            }
            finally {
                if (contentInputStream != null) {
                    ((InputStream)contentInputStream).close();
                    contentInputStream = null;
                }
            }
        }
        catch (UploadException e) {
            LOG.error((Object)e.getMessage(), (Throwable)((Object)e));
            resp.setContentType(MIME_TEXT_HTML_CHARSET_UTF_8);
            Tools.disableCaching(resp);
            JSONObject responseObj = null;
            try {
                Response response = new Response(session);
                response.setException(e);
                responseObj = ResponseWriter.getJSON(response);
            }
            catch (JSONException e1) {
                LOG.error((Object)e1.getMessage(), (Throwable)e1);
            }
            throw new UploadServletException(resp, AJAXFile.substituteJS(responseObj == null ? STR_NULL : responseObj.toString(), e.getAction() == null ? STR_NULL : e.getAction()), e.getMessage(), (Throwable)((Object)e));
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            resp.setStatus(200);
            resp.setContentType("text/javascript; charset=UTF-8");
            Tools.disableCaching(resp);
            Response response = new Response();
            response.setException(e);
            try {
                ResponseWriter.write(response, resp.getWriter());
            }
            catch (JSONException e1) {
                LOG.error((Object)e1.getMessage(), (Throwable)e1);
                ServletException se = new ServletException(e1.getMessage(), (Throwable)e1);
                se.initCause((Throwable)e1);
                throw se;
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block19: {
            ServerSession session = AJAXFile.getSessionObject((ServletRequest)req);
            Tools.disableCaching(resp);
            resp.setContentType(MIME_TEXT_HTML_CHARSET_UTF_8);
            String action = null;
            try {
                List items;
                if (!FileUploadBase.isMultipartContent((RequestContext)new ServletRequestContext(req))) break block19;
                DiskFileItemFactory factory = new DiskFileItemFactory();
                factory.setSizeThreshold(0);
                factory.setRepository(new File(ServerConfig.getProperty(ServerConfig.Property.UploadDirectory)));
                ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
                String moduleParam = req.getParameter("module");
                if (moduleParam == null) {
                    throw UploadException.UploadCode.MISSING_PARAM.create("module");
                }
                String fileTypeFilter = req.getParameter("type");
                if (fileTypeFilter == null) {
                    throw UploadException.UploadCode.MISSING_PARAM.create("type");
                }
                ServerSession sessionObj = AJAXFile.getSessionObject((ServletRequest)req);
                UploadQuotaChecker checker = UploadQuotaChecker.getUploadQuotaChecker(AJAXFile.getModuleInteger(moduleParam), sessionObj, sessionObj.getContext());
                upload.setSizeMax(checker.getQuotaMax());
                upload.setFileSizeMax(checker.getFileQuotaMax());
                try {
                    action = AJAXFile.getAction(req);
                }
                catch (OXException e) {
                    throw UploadException.UploadCode.UPLOAD_FAILED.create(e, e.getMessage()).setAction(action);
                }
                if (!"new".equalsIgnoreCase(action)) {
                    throw UploadException.UploadCode.INVALID_ACTION_VALUE.create(action).setAction(action);
                }
                try {
                    List tmp;
                    items = tmp = upload.parseRequest(req);
                }
                catch (FileUploadException e) {
                    throw UploadException.UploadCode.UPLOAD_FAILED.create(e, new Object[0]).setAction(action);
                }
                int size = items.size();
                Iterator iter = items.iterator();
                JSONArray jArray = new JSONArray();
                try {
                    ManagedFileManagement management = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class);
                    for (int i = 0; i < size; ++i) {
                        FileItem fileItem = (FileItem)iter.next();
                        if (!AJAXFile.isValidFile(fileItem)) continue;
                        ContentType ct = new ContentType(fileItem.getContentType());
                        if (!AJAXFile.checkFileType(fileTypeFilter, ct)) {
                            throw UploadException.UploadCode.INVALID_FILE_TYPE.create(action == null ? STR_NULL : action, fileItem.getContentType(), fileTypeFilter);
                        }
                        jArray.put((Object)AJAXFile.processFileItem(fileItem, management));
                    }
                }
                catch (UploadException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw UploadException.UploadCode.UPLOAD_FAILED.create(e, new Object[0]).setAction(action);
                }
                Response response = new Response(session);
                response.setData(jArray);
                String jsResponse = AJAXFile.substituteJS(ResponseWriter.getJSON(response).toString(), action);
                PrintWriter writer = resp.getWriter();
                ((Writer)writer).write(jsResponse);
                ((Writer)writer).flush();
            }
            catch (OXException e) {
                JSONObject responseObj = null;
                try {
                    Response response = new Response(session);
                    response.setException(e);
                    responseObj = ResponseWriter.getJSON(response);
                }
                catch (JSONException e1) {
                    LOG.error((Object)e1.getMessage(), (Throwable)e1);
                }
                throw new UploadServletException(resp, AJAXFile.substituteJS(responseObj == null ? STR_NULL : responseObj.toString(), STR_NULL), e.getMessage(), e);
            }
            catch (JSONException e) {
                OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
                JSONObject responseObj = null;
                try {
                    Response response = new Response(session);
                    response.setException(oje);
                    responseObj = ResponseWriter.getJSON(response);
                }
                catch (JSONException e1) {
                    LOG.error((Object)e1.getMessage(), (Throwable)e1);
                }
                throw new UploadServletException(resp, AJAXFile.substituteJS(responseObj == null ? STR_NULL : responseObj.toString(), action == null ? STR_NULL : action), e.getMessage(), e);
            }
        }
    }

    private static boolean isValidFile(FileItem fileItem) {
        if (fileItem.isFormField() || fileItem.getSize() <= 0L) {
            return false;
        }
        String name = fileItem.getName();
        return name != null && name.length() > 0;
    }

    private static boolean checkFileType(String filter, ContentType fileContentType) {
        if (FILE_TYPE_ALL.equalsIgnoreCase(filter)) {
            return true;
        }
        if (FILE_TYPE_TEXT.equalsIgnoreCase(filter)) {
            return fileContentType.startsWith("text/");
        }
        if (FILE_TYPE_MEDIA.equalsIgnoreCase(filter)) {
            return fileContentType.startsWith("image/") || fileContentType.startsWith("audio/") || fileContentType.startsWith("video/");
        }
        if (FILE_TYPE_IMAGE.equalsIgnoreCase(filter)) {
            return fileContentType.startsWith("image/");
        }
        if (FILE_TYPE_AUDIO.equalsIgnoreCase(filter)) {
            return fileContentType.startsWith("audio/");
        }
        if (FILE_TYPE_VIDEO.equalsIgnoreCase(filter)) {
            return fileContentType.startsWith("video/");
        }
        if (FILE_TYPE_APPLICATION.equalsIgnoreCase(filter)) {
            return fileContentType.startsWith("application/");
        }
        return false;
    }

    private static String processFileItem(FileItem fileItem, ManagedFileManagement management) throws Exception {
        ManagedFile managedFile = management.createManagedFile(fileItem.getInputStream());
        managedFile.setFileName(fileItem.getName());
        managedFile.setContentType(fileItem.getContentType());
        managedFile.setSize(fileItem.getSize());
        return managedFile.getID();
    }

    @Override
    protected boolean hasModulePermission(ServerSession session) {
        return true;
    }
}

