/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.stream;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public final class UnsynchronizedByteArrayOutputStream
extends ByteArrayOutputStream {
    public UnsynchronizedByteArrayOutputStream() {
        this(32);
    }

    public UnsynchronizedByteArrayOutputStream(int size) {
        super(size);
    }

    @Override
    public void write(int b) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        this.buf[this.count] = (byte)b;
        this.count = newcount;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        if (null != out) {
            out.write(this.buf, 0, this.count);
        }
    }

    @Override
    public void reset() {
        this.count = 0;
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.count);
    }

    public void discard(int discardSize) {
        if (discardSize < 0 || discardSize > this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (discardSize == 0) {
            return;
        }
        byte[] newbuf = new byte[this.count - discardSize];
        System.arraycopy(this.buf, discardSize, newbuf, 0, newbuf.length);
        this.buf = newbuf;
        this.count = newbuf.length;
    }

    @Override
    public byte[] toByteArray() {
        byte[] newbuf = new byte[this.count];
        System.arraycopy(this.buf, 0, newbuf, 0, this.count);
        return newbuf;
    }

    public byte[] toByteArray(int off, int size) {
        if (off < 0 || off > this.count || size < 0 || off + size > this.count || off + size < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (size == 0) {
            return new byte[0];
        }
        byte[] newbuf = new byte[size];
        System.arraycopy(this.buf, off, newbuf, 0, size);
        return newbuf;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    @Override
    public String toString(String enc) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, enc);
    }

    @Override
    @Deprecated
    public String toString(int hibyte) {
        return new String(this.buf, hibyte, 0, this.count);
    }

    @Override
    public void close() throws IOException {
    }
}

